 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kdbmcat
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kdbmcat.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - print contents of (ascii) DBM database
|
|       Purpose: main program for kdbmcat
|
|         Input:
|		char *clui_info->tb_string; {name of toolbox}
|		int   clui_info->tb_flag; {TRUE if -tb specified}
|
|		char *clui_info->oname_string; {name of object}
|		int   clui_info->oname_flag; {TRUE if -oname specified}
|
|		int clui_info->manpage_flag; {TRUE if -manpage specified}
|
|		int clui_info->cms_flag; {TRUE if -cms specified}
|
|		int clui_info->functions_flag; {TRUE if -functions specified}
|
|		char *clui_info->dbm_string; {path to dbm file}
|		int   clui_info->dbm_flag; {TRUE if -dbm specified}
|
|        Output:
|       Returns:
|
|    Written By: 
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	kdbm	*dbm;
	kdatum  key, data;

	kobject object = NULL, toolbox = NULL;
	char *oname, *tbname, *path, temp[KLENGTH];
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "SUPPORT");
	kexit_handler(kdbmcat_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "SUPPORT", "kdbmcat",
		kdbmcat_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kdbmcat_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	tbname = clui_info->tb_string;
	oname  = clui_info->oname_string;

	if (tbname != NULL && (toolbox = kcms_open_toolbox(tbname)) == NULL)
	{
	   kerror(NULL, "main()", "Cannot open toolbox %s.", tbname);
	   kexit(KEXIT_FAILURE);
	}

	if (oname != NULL && (object = kcms_open_cmobj(toolbox, oname)) == NULL)
	{
	   kerror(NULL, "main()","Cannot open object '%s' to copy", oname);
	   kcms_close(toolbox);
	   kexit(KEXIT_FAILURE);
	}

	if (toolbox != NULL && object == NULL)
	{
	   kcms_get_attribute(toolbox, KCMS_PATH, &path);
	   ksprintf(temp,"%s/repos/db/cms", path);
	}
	else if (object != NULL)
	{
	   kcms_get_attribute(object, KCMS_PATH, &path);
	   ksprintf(temp,"%s/db/cms", path);
	}
	else if (clui_info->dbm_string != NULL)
	{
	   ksprintf(temp,"%s", clui_info->dbm_string);
	}
/* -main_before_lib_call_end */

/* -main_library_call */
        if ((dbm = kdbm_open(temp, O_RDONLY, 0666)) == NULL)
        {
           kinfo(KSTANDARD, "kdbmcat:  Failed to open database '%s'", temp);
           kexit(KEXIT_FAILURE);
        }

        key = kdbm_firstkey(dbm);
        while (key.dptr != NULL)
        {
           data = kdbm_fetch(dbm, key);
           kfprintf(kstdout,"'%s': %s\n", key.dptr, data.dptr);

           key = kdbm_nextkey(dbm);
        }
        kdbm_close(dbm);
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kdbmcat_usage_additions
| 
|       Purpose: Prints usage additions in kdbmcat_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kdbmcat
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kdbmcat_usage_additions(void)
{
	kfprintf(kstderr, "\tprint contents of (ascii) DBM database\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kdbmcat_free_args
| 
|       Purpose: Frees CLUI struct allocated in kdbmcat_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kdbmcat
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kdbmcat_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->tb_string);
	kfree(clui_info->oname_string);
	kfree(clui_info->dbm_string);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
