eval 'exec perl -S $0 $*'
                if $runnning_under_some_shell;

#========================================================================
# Program Name: kuptbdef - no short description specified
# Purposed:	long description goes here
#
# RCS ID:	Khoros: $Id$
# RCS Log:	$Log$
#========================================================================

# Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
# All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.


if (! defined $ENV{'KHOROS_TOOLBOX'})
{
   die "The KHOROS_TOOLBOX environment variable must be set.\n";
}

$notfound = 1;
foreach $toolbox_file (sort split(/:/, $ENV{'KHOROS_TOOLBOX'}))
{
   open(TBS,"<$toolbox_file") || do
   {
      warn "Can not open $toolbox_file.  Please check to make sure your\n";
      die  "KHOROS_TOOLBOX environment variable points to existing files.\n";
   };

   while (<TBS>)
   {
      chop($_);
      @line = split(':',$_);
      if ($line[0] eq "SUPPORT")
      {
         if ( $notfound )
         {
            $support_path = $line[1];
            $notfound = 0;
         }
         else
         {
            warn "The SUPPORT toolbox is defined twice.  Please check your\n";
            warn "KHOROS_TOOLBOX environment variable and the file(s)\n";
            warn "pointed to by it and make sure that all toolboxes are\n";
            die  "only defined once.\n";
         }
      }
   }
}

if ( $notfound )
{
   print "The SUPPORT toolbox is not defined in any of the files pointed to\n";
   die   "by the environment variable KHOROS_TOOLBOX.\n";
}


@INC = ("$support_path/repos/perl", @INC);
require "khoros.pl";
require "kutils.pl";

$whatis = 'update toolbox.def imake config file';
@clui_args  = (
        '[tb]',    'toolbox',  'name of toolbox',
        '[f]',     '',         'force overwrite of toolbox.def'
);

# initialize Khoros perl lib
&khoros'initialize("MIGRATION",$whatis,@clui_args);

&khoros'parse_args(@ARGV);                   # parse the command-line

# ------------------------------------------------------------------------
# Put your code here
# ------------------------------------------------------------------------

unless (defined $khoros'toolboxPath{'BOOTSTRAP'})
{
   die "Can't determine path to BOOTSTRAP toolbox\n"
}
$bootpath = $khoros'toolboxPath{'BOOTSTRAP'};
# $bootpath = '/research/data/khoros_test/bootstrap';

@toolboxes = &khoros'get_toolbox_list();
print "ALL TOOLBOXES: @toolboxes\n";

foreach $toolbox (@toolboxes)
{
   &UpdateImakeConfig($toolbox);
   print STDERR "\n";
}

#========================================================================
#
#========================================================================
sub UpdateImakeConfig
{
   local($toolbox) = @_;
   local($TOOLBOX);
   local($tbpath);
   local(*OLD, *NEW, *TEMPLATE);
   local($filename);
   local($line);
   local(@deptbs);


   print STDERR "Toolbox: $toolbox\n";
   $TOOLBOX = "\U$toolbox";
   $toolbox = "\L$toolbox";
   $tbpath = $khoros'toolboxPath{$TOOLBOX}; # '

   if (-f "$tbpath/repos/config/imake_config/toolbox.def"
       && !$khoros'seenswitch{'f'})
   {
      print STDERR "    toolbox already has toolbox.def -- won't overwrite it\n";
      return;
   }

   #------------------------------------------------------------------------
   # first we parse the information we want out of the existing imake config
   #------------------------------------------------------------------------
   $filename = "$tbpath/repos/config/imake_config/$toolbox.def";
   open(OLD, "< $filename") || do
   {
      warn "    Could not read old imake config file:\n\t$filename\n";
      return;
   };
   undef $line;
   while (<OLD>)
   {
      $_ = $line.$_;
      # escaped newline, suck in next line.
      if (/\\$/)
      {
         ($line = $_) =~ s/\\$//;
         next;
      }

      s/\n./ /g;

      push(@deptbs, $1) if /^\s*#\s*include\s+<(.*)\.def>/;

      @libs = &GetLibs($1) if /^\s*TOOLBOX_LIBRARIES\s*=\s*(.*)/;
      @flibs = &GetLibs($1) if /^\s*FOR_TOOLBOX_LIBRARIES\s*=\s*(.*)/;
      @xlibs = &GetLibs($1) if /^\s*X_TOOLBOX_LIBRARIES\s*=\s*(.*)/;

      undef $line;
   }
   close;


   #------------------------------------------------------------------------
   # first we parse the information we want out of the existing imake config
   #------------------------------------------------------------------------
   $filename = "$tbpath/repos/config/imake_config/toolbox.def";
   open(NEW, "> $filename") || do
   {
      warn "    Could not write new imake config file:\n\t$filename\n";
      return;
   };

   $filename = "$bootpath/objects/library/kcms/templates/toolbox/toolbox.def";
   open(TEMPLATE, "< $filename") || do
   {
      warn "    Could not read new imake config template:\n\t$filename\n";
      close NEW;
      return;
   };

   while (<TEMPLATE>)
   {
      s/#TOOLBOX-NAME#/$TOOLBOX/g;
      s/#toolbox-name#/$toolbox/g;

      /^#include DESIGN_INCLUDE/ && do
      {
         unless (grep(/design/i, @deptbs))
         {
            if (grep(/dataserv/i, @deptbs))
            {
               print NEW "#include DATASERV_INCLUDE\n";
               next;
            }
            if (grep(/bootstrap/i, @deptbs))
            {
               print NEW "#include BOOTSTRAP_INCLUDE\n";
               next;
            }

            warn "UNEXPECTED ERROR: dependent toolboxes are: @deptbs\n";
         }
      };

      print NEW;

      if (/-toolbox_libraries /)
      {
         foreach $library (@libs) {
            print NEW "AddLibrary($library, C, \$(${TOOLBOX}_NAME)/lib)\n";
         }
         foreach $library (@flibs) {
            print NEW "AddLibrary($library, FOR, \$(${TOOLBOX}_NAME)/lib)\n";
         }
         foreach $library (@xlibs) {
            print NEW "AddLibrary($library, X, \$(${TOOLBOX}_NAME)/lib)\n";
         }
      }
   }
   close TEMPLATE;
   close NEW;
}

sub GetLibs
{
   local($libline) = @_;
   local($item);

   @matchlibs = ();
   foreach $item (split(/\s+/, $libline))
   {
      push(@matchlibs, $1) if $item =~ /^\s*-l(\S+)/;
   }
   @matchlibs = reverse @matchlibs;

   return @matchlibs;
}
