eval 'exec perl -S $0 $*'
                if $runnning_under_some_shell;

#========================================================================
# Program Name: kmigimake - no short description specified
# Purposed:	long description goes here
#
# RCS ID:	Khoros: $Id$
# RCS Log:	$Log$
#========================================================================

# Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
# All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.


if (! defined $ENV{'KHOROS_TOOLBOX'})
{
   die "The KHOROS_TOOLBOX environment variable must be set.\n";
}

$notfound = 1;
foreach $toolbox_file (sort split(/:/, $ENV{'KHOROS_TOOLBOX'}))
{
   open(TBS,"<$toolbox_file") || do
   {
      warn "Can not open $toolbox_file.  Please check to make sure your\n";
      die  "KHOROS_TOOLBOX environment variable points to existing files.\n";
   };

   while (<TBS>)
   {
      chop($_);
      @line = split(':',$_);
      if ($line[0] eq "SUPPORT")
      {
         if ( $notfound )
         {
            $support_path = $line[1];
            $notfound = 0;
         }
         else
         {
            warn "The SUPPORT toolbox is defined twice.  Please check your\n";
            warn "KHOROS_TOOLBOX environment variable and the file(s)\n";
            warn "pointed to by it and make sure that all toolboxes are\n";
            die  "only defined once.\n";
         }
      }
   }
}

if ( $notfound )
{
   print "The SUPPORT toolbox is not defined in any of the files pointed to\n";
   die   "by the environment variable KHOROS_TOOLBOX.\n";
}


@INC = ("$support_path/repos/perl", @INC);
require 'find.pl';
require "khoros.pl";
require "kutils.pl";

$whatis = 'no short description specified';
@clui_args  = (
        '[tb]',     'toolbox',      'name of toolbox'
);

# initialize Khoros perl lib
&khoros'initialize("MIGRATION",$whatis,@clui_args);

&khoros'parse_args(@ARGV);                   # parse the command-line
@patterns =
   (
    '#include <tbname.def>',      'AddToolbox(<TBNAME>)',
    '\bTOOLBOX_LIBRARIES\b',      'C_TOOLBOX_LIBRARIES',
    '\bTOOLBOX_DEP_LIBRARIES\b',  'C_TOOLBOX_DEP_LIBRARIES',
    '\bLOCAL_LIBRARIES\b',        'BOOTSTRAP_LIBRARIES',
    '\bLOCAL_DEP_LIBRARIES\b',    'BOOTSTRAP_DEP_LIBRARIES',
    '\bIMAKEFILE = ',             'OBJECT_TYPE = ',
    '\bTOOLBOX = ',               'TOOLBOX_NAME = ',
    '\bPROGRAM_NAME\b',           'BINARY_NAME',
    '\bLIBRARY_NAME\b',           'BINARY_NAME'
    );

@toolboxes = &khoros'get_toolbox_list();

$i = 0;
while ($i < @patterns)
{
   push(@match_regex, $patterns[$i]);
   $i++;
   push(@substitute_regex, $patterns[$i]);
   $i++;
}

print "TOOLBOXES: @toolboxes\n";
foreach $tbname (@toolboxes)
{
   $toolbox = "\L$tbname";
   $TOOLBOX = "\U$tbname";
   $tbpath  = $khoros'toolboxPath{$TOOLBOX};
   print "UPDATING TOOLBOX: $TOOLBOX\n";

   $match_regex[0] = "#include\\s+<$toolbox.def>";
   $substitute_regex[0] = "#include ${TOOLBOX}_INCLUDE";

   foreach $type ('kroutine', 'xvroutine', 'pane', 'library', 'script')
   {
      chop($objlist = `kecho -tb $toolbox -type $type -echo objects`);
      next if $objlist =~ /^\s*$/;
      @objects = split(/\s+/, $objlist);
      foreach $object (@objects)
      {
	 $OBJECT_NAME = "\L$object";
         $opath = "$tbpath/objects/$type/$object";
	 &UpdateImakefile("$opath/src/Imakefile", $OBJECT_NAME);
	 &UpdateImakefile("$opath/Imakefile", $OBJECT_NAME);
      }
      &UpdateImakefile("$tbpath/objects/$type/Imakefile", '');
   }
   &UpdateImakefile("$tbpath/objects/Imakefile", '');

   &find("$tbpath/manual") if -d "$tbpath/manual";
   &find("$tbpath/examples") if -d "$tbpath/examples";
   &find("$tbpath/testsuite") if -d "$tbpath/testsuite";
}

sub UpdateImakefile
{
   local($filename, $object) = @_;
   local(*INFILE);
   local(*OUTFILE);
   local($newfile);
   local($updated);


   return unless -f $filename;
   $newfile = "$filename.$$";
   print "   $filename ... ";
   open(INFILE, "< $filename") || do
   {
      warn "could not open: $!\n";
      return;
   };

   open(OUTFILE, "> $newfile") || do
   {
      close(INFILE);
      print STDERR "could not write $newfile: $!\n";
      return;
   };

   $updated = 0;
   while (<INFILE>)
   {
      for ($i = 0; $i < @match_regex; ++$i)
      {
	 /$match_regex[$i]/ && do
	 {
	    s/$match_regex[$i]/$substitute_regex[$i]/;
	    $updated = 1;
	 };
      }

      print OUTFILE;

      /\bTOOLBOX_NAME\s*=/ && $updated && do
      {
	 print OUTFILE "OBJECT_NAME = $object\n";
	 $updated = 1;
      }
   }
   close INFILE;
   close OUTFILE;

   if ($updated)
   {
      rename($filename, "$filename.bak") && rename($newfile, $filename);
      print "UPDATED.\n";
   }
   else
   {
      print "unchanged.\n";
      unlink($newfile);
   }
}

# ========================================================================
# wanted()
#    This function is invoked by the &find() function.
# ========================================================================
sub wanted
{
   $_ eq 'Imakefile' && &UpdateImakefile($name, '');
}
