 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for uisupdate
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "uisupdate.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Updates an old Khoros 1.0 Patch 5 UIS file to a new Khoros 2.0 UIS file.
|
|       Purpose: main program for uisupdate
|
|         Input:
|		char *clui_info->i_file; {old UIS file}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		int clui_info->force_flag; {TRUE if -force specified}
|
|        Output:
|       Returns:
|
|    Written By: 
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "MIGRATION");
	kexit_handler(uisupdate_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "MIGRATION", "uisupdate",
		uisupdate_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	uisupdate_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
/* -main_before_lib_call_end */

/* -main_library_call */
        if (!(update_uis(clui_info->i_file, clui_info->force_flag)))
	    kexit(KEXIT_FAILURE);
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: uisupdate_usage_additions
| 
|       Purpose: Prints usage additions in uisupdate_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname uisupdate
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void uisupdate_usage_additions(void)
{
	kfprintf(kstderr, "\tUpdates an old Khoros 1.0 Patch 5 UIS file to a new Khoros\n");
	kfprintf(kstderr, "\t2.0 UIS file.\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: uisupdate_free_args
| 
|       Purpose: Frees CLUI struct allocated in uisupdate_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname uisupdate
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
uisupdate_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
