 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>		       Parsing  Routines                      <<<<
   >>>>                                                       <<<<
   >>>>	       ~ oldparse lines out of the User Interface     <<<<
   >>>>                Description (database)		      <<<<
   >>>>   			including:                    <<<<
   >>>>                                                       <<<<
   >>>>                                                       <<<<
   >>>>		kvf_oldparse_startform_line()		      <<<<   
   >>>>		kvf_oldparse_startmaster_line()		      <<<<   
   >>>>		kvf_oldparse_startsubmenu_line()	      <<<<   
   >>>>		kvf_oldparse_startsubform_line()	      <<<<   
   >>>>		kvf_oldparse_subformbutton_line()	      <<<<   
   >>>>		kvf_oldparse_psuedosubform_line()	      <<<<   
   >>>>		kvf_oldparse_master_action_line()	      <<<<   
   >>>>		kvf_oldparse_startguide_line()		      <<<<   
   >>>>		kvf_oldparse_startpane_line()		      <<<<   
   >>>>		kvf_oldparse_guide_line()		      <<<<   
   >>>>		kvf_oldparse_quit_line()		      <<<<   
   >>>>		kvf_oldparse_subform_action_line()	      <<<<   
   >>>>		kvf_oldparse_help_line()		      <<<<   
   >>>>		kvf_oldparse_input_line()		      <<<<   
   >>>>		kvf_oldparse_output_line()		      <<<<   
   >>>>		kvf_oldparse_int_line()		      	      <<<<   
   >>>>		kvf_oldparse_float_line()		      <<<<   
   >>>>		kvf_oldparse_logic_line()		      <<<<   
   >>>>		kvf_oldparse_string_line()		      <<<<   
   >>>>		kvf_oldparse_routine_line()	      	      <<<<   
   >>>>		kvf_oldparse_toggle_line()		      <<<<   
   >>>>		kvf_oldparse_blank_line()		      <<<<   
   >>>>		kvf_oldparse_pane_action_line()		      <<<<   
   >>>>		kvf_oldparse_includepane_line()		      <<<<   
   >>>>		kvf_oldparse_includesubform_line()	      <<<<   
   >>>>		kvf_oldparse_mutexcl_line()		      <<<<   
   >>>>		kvf_oldparse_workspace_line()		      <<<<   
   >>>>		kvf_oldparse_ansinfile_line()		      <<<<   
   >>>>		kvf_oldparse_list_line()		      <<<<   
   >>>>		kvf_oldparse_cycle_line()		      <<<<   
   >>>>		kvf_oldparse_end_line()		      	      <<<<   
   >>>>		kvf_gen_oldparse()		      	      <<<<   
   >>>>                                                       <<<<
   >>>>		kvf_create_readerror_mesg()	      	      <<<<   
   >>>>		kvf_create_mesg()		      	      <<<<   
   >>>>                                                       <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  */

#include "uisupdate.h"
#include "parser.h"

#define kvf_check_boolean(val)	(((val != 0) && (val != 1))? 0 : 1)
#define kvf_check_pos(pos, width) ((pos > width)? 0 : 1)

static char *kvf_create_readerror_mesg  PROTO((char *, char *, int, int));
static char *kvf_create_mesg		PROTO((char *, char *, char *, int));

/************************************************************
*
*      Routine: kvf_oldparse_startform_line(line, &line_info);
*
*      Purpose: Parses a Start Form line  (-F:  typeflag = StartForm)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*
*************************************************************/

int kvf_oldparse_startform_line(
   char      *line,
   Line_Info *line_info)
{
	char tmp_title[KLENGTH], tmp_var[KLENGTH], flag;
	int  release, version;
	char *mesg;
	int  status;

        status = sscanf(line, startform_oldscan, &flag, 
			&release, &version,
			&line_info->activate, &line_info->selected,
			&line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, 
			&line_info->xpos, &line_info->ypos, 
			tmp_title, tmp_var);
	

	if (status < 12) 
	{
	    mesg = kvf_create_readerror_mesg("kvf_oldparse_startform_line",
					  line, status, 12);
	    kerror("kforms", NULL, mesg);
	    kfree(mesg);
	    return(FALSE);
   	} 

	if ((kstrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) kfree (line_info->title);
	    line_info->title = kstring_copy(tmp_title, NULL);
	}
	
	if ((kstrcmp(tmp_var,"")) == 0) 
        {
	    mesg = kvf_create_mesg("kvf_oldparse_startform_line", line,
			         "'variable' field MUST be specified", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
        }
	else 
	{ 
	    if (line_info->variable != NULL) kfree (line_info->variable);
	    line_info->variable = kstring_copy(tmp_var, NULL);
	}

	if (!(kvf_check_boolean(line_info->activate)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_startform_line", line,
			         	"'activate' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}
	

        if (!(kvf_check_pos(line_info->xpos, line_info->width)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_startform_line", line, 
			  		"X position is greater than width", 2);
	    status = kprompt(KSTANDARD, "Cont", "Stop", 0, mesg);
	    kfree(mesg);
	    if (status == 0) return(FALSE);
	}

 	if (!(kvf_check_pos(line_info->ypos, line_info->height)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_startform_line", line, 
			  		"Y position is greater than height", 2);
	    status = kprompt(KSTANDARD, "Cont", "Stop", 0, mesg);
	    kfree(mesg);
	    if (status == 0) return(FALSE);
	}

	line_info->typeflag = KUIS_STARTFORM;

	return(TRUE);
}



/************************************************************
*
*      Routine: kvf_oldparse_startmaster_line(line, &line_info);
*
*      Purpose: Parses a StartMaster line  (-S:  typeflag = StartMaster)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*
*************************************************************/

int kvf_oldparse_startmaster_line(
   char      *line,
   Line_Info *line_info)
{
	char flag, *mesg;
	int status;
	status = sscanf(line, startmaster_oldscan, &flag, &line_info->activate,
			      &line_info->logical_val);

	if (status < 3) 
	{
	    mesg = kvf_create_readerror_mesg("kvf_oldparse_startmaster_line",
					  line, status, 3);
	    kerror("kforms", NULL, mesg);
	    kfree(mesg);
	    return(FALSE);
   	} 

	if (!(kvf_check_boolean(line_info->activate)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_startmaster_line", line,
			         	"'activate' flag must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg);
	    kfree(mesg);
	    return(FALSE);
	}
	if (!(kvf_check_boolean(line_info->logical_val)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_startmaster_line", line,
			       	"'mutually exclusive' flag must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg);
	    kfree(mesg);
	    return(FALSE);
	}
	line_info->typeflag = KUIS_STARTMASTER;
	return(TRUE);
}



/************************************************************
*
*      Routine: kvf_oldparse_startsubmenu_line(line, &line_info);
*
*      Purpose: Parses a Start SubMenu line  (-D:  typeflag = StartSubMenu)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*
*************************************************************/

int kvf_oldparse_startsubmenu_line(
   char      *line,
   Line_Info *line_info)
{
	char tmp_title[KLENGTH], tmp_var[KLENGTH], flag;
	char *mesg;
	int  status;

        status = sscanf(line, startsubmenu_oldscan, &flag, 
			&line_info->activate, &line_info->selected, 
		        &line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, 
			&line_info->xpos, &line_info->ypos, 
			tmp_title, tmp_var);
	
	if (status < 11) 
	{
	    mesg = kvf_create_readerror_mesg("kvf_oldparse_startsubmenu_line",
					  line, status, 11);
	    kerror("kforms", NULL, mesg);
	    kfree(mesg);
	    return(FALSE);
   	} 

	if ((kstrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) kfree (line_info->title);
	    line_info->title = kstring_copy(tmp_title, NULL);
	}
	
	if ((kstrcmp(tmp_var," ")) == 0) 
        {
	    mesg = kvf_create_mesg("kvf_oldparse_startsubmenu_line", line,
			       	"'variable' field MUST be specified", 1);
	    kerror("kforms", NULL, mesg);
	    kfree(mesg);
	    return(FALSE);
        }
	else 
	{ 
	    if (line_info->variable != NULL)
		kfree (line_info->variable);
	    line_info->variable = kstring_copy(tmp_var, NULL);
	}

	if (!(kvf_check_boolean(line_info->activate)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_startsubmenu_line", line,
			         "'activate' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg);
	    kfree(mesg);
	    return(FALSE);
	}

	line_info->typeflag = KUIS_STARTSUBMENU;

	return(TRUE);
}



/************************************************************
*
*      Routine: kvf_oldparse_startsubform_line(line, &line_info);
*
*      Purpose: Parses a Start SubForm line  (-M:  typeflag = StartSubForm)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*
*************************************************************/

int kvf_oldparse_startsubform_line(
   char      *line,
   Line_Info *line_info)
{
	char tmp_title[KLENGTH], tmp_var[KLENGTH], flag;
	char *mesg;
	int  status;

        status = sscanf(line, startsubform_oldscan, &flag, 
			&line_info->activate, &line_info->selected, 
		        &line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, 
			&line_info->xpos, &line_info->ypos, 
			tmp_title, tmp_var);
	
	if (status < 11) 
	{
	    mesg = kvf_create_readerror_mesg("kvf_oldparse_startsubform_line",
					  line, status, 11);
	    kerror("kforms", NULL, mesg);
	    kfree(mesg);
	    return(FALSE);
   	} 

	if ((kstrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL)
		kfree (line_info->title);
	    line_info->title = kstring_copy(tmp_title, NULL);
	}
	
	if ((kstrcmp(tmp_var,"")) == 0) 
        {
	    mesg = kvf_create_mesg("kvf_oldparse_startsubform_line", line,
		         	"'variable' field MUST be specified", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
        }
	else 
	{ 
	    if (line_info->variable != NULL)
		kfree (line_info->variable);
	    line_info->variable = kstring_copy(tmp_var, NULL);
	}

	if (!(kvf_check_boolean(line_info->activate)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_startsubform_line", line,
			         "'activate' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg);
	    kfree(mesg);
	    return(FALSE);
	}

 	if (!(kvf_check_pos(line_info->xpos, line_info->width)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_startsubform_line", line, 
		  		"X position is greater than width", 2);
	    status = kprompt(KSTANDARD, "Cont", "Stop", 0, mesg);
	    kfree(mesg);
	    if (status == 0) return(FALSE);
	}

 	if (!(kvf_check_pos(line_info->ypos, line_info->height)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_startsubform_line", line, 
		  		"Y position is greater than height", 2);
	    status = kprompt(KSTANDARD, "Cont", "Stop", 0, mesg);
	    kfree(mesg);
	    if (status == 0) return(FALSE);
	}

	line_info->typeflag = KUIS_STARTSUBFORM;

	return(TRUE);
}



/************************************************************
*
*      Routine: kvf_oldparse_subformbutton_line(line, &line_info);
*
*      Purpose: Parses a SubFormButton line  (-d:  typeflag = SubFormButton)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*
*************************************************************/

int kvf_oldparse_subformbutton_line(
   char      *line,
   Line_Info *line_info)
{
	char temp[KLENGTH], flag;
	int status;
	char *mesg;

        status = sscanf(line, subformbutton_oldscan, &flag, 
			&line_info->activate, &line_info->selected, 
			&line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, temp);

	if (status < 8) 
	{
	    mesg = kvf_create_readerror_mesg("kvf_oldparse_subformbutton_line",
					 line, status, 10);
	    kerror("kforms", NULL, mesg);
	    kfree(mesg);
	    return(FALSE);
	}

	if ((kstrcmp(temp," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL)
		kfree (line_info->title);
	    line_info->title = kstring_copy(temp, NULL);
	}
	
	if (!(kvf_check_boolean(line_info->activate)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_subformbutton_line", line,
			  "activate must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg);
	    kfree(mesg);
            return(FALSE);
        }

	if (!(kvf_check_boolean(line_info->selected)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_subformbutton_line", line,
			  	"'selected' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg);
	    kfree(mesg);
 	    return(FALSE);
        }

	line_info->typeflag = KUIS_SUBFORMBUTTON;

	return(TRUE);
}




/************************************************************
*
*      Routine: kvf_oldparse_psuedosubform_line(line, &line_info);
*
*      Purpose: Parses a PsuedoSubForm line  (-u:  typeflag = PsuedoSubForm)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro 
*
*
*************************************************************/

int kvf_oldparse_psuedosubform_line(
   char      *line,
   Line_Info *line_info)
{
	char temp[KLENGTH], flag;
	int status;
	char *mesg;

        status = sscanf(line, psuedosubform_oldscan, &flag, 
			&line_info->activate, &line_info->selected, 
			&line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, temp);

	if (status < 8) 
	{
	    mesg = kvf_create_readerror_mesg("kvf_oldparse_psuedosubform_line",
					 line, status, 8);
	    kerror("kforms", NULL, mesg);
	    kfree(mesg);
	    return(FALSE);
	}

	if ((kstrcmp(temp," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL)
		kfree (line_info->title);
	    line_info->title = kstring_copy(temp, NULL);
	}
	
	if (!(kvf_check_boolean(line_info->activate)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_psuedosubform_line", line,
			  "activate must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg);
	    kfree(mesg);
            return(FALSE);
        }

	if (!(kvf_check_boolean(line_info->selected)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_psuedosubform_line", line,
			  	"'selected' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg);
	    kfree(mesg);
 	    return(FALSE);
        }

	line_info->typeflag = KUIS_PSEUDOSUBFORM;

	return(TRUE);
}

/************************************************************
*
*      Routine: kvf_oldparse_master_action_line(line, &line_info);
*
*      Purpose: Parses a Master Action line  (-n:  typeflag = MasterAction)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*
*************************************************************/

int kvf_oldparse_master_action_line(
   char      *line,
   Line_Info *line_info)
{
	char tmp_desc[KLENGTH], tmp_title[KLENGTH], tmp_var[KLENGTH], 
	     flag;
	int status;
	char *mesg;

        status = sscanf(line, master_action_oldscan, &flag, 
			&line_info->activate, &line_info->selected, 
			&line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, 
			tmp_title, tmp_desc, tmp_var);
	
	if (status < 10) 
	{
	    mesg = kvf_create_readerror_mesg("kvf_oldparse_master_action_line",
					 line, status, 10);
	    kerror("kforms", NULL, mesg);
	    kfree(mesg);
	    return(FALSE);
    	}

	if ((kstrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL)
		kfree (line_info->title);
	    line_info->title = kstring_copy(tmp_title, NULL);
	}

	if ((kstrcmp(tmp_desc," ")) == 0) line_info->description = NULL;
	else 
	{ 
	    if (line_info->description != NULL)
		kfree (line_info->description);
	    line_info->description = kstring_copy(tmp_desc, NULL);
	}

	if ((kstrcmp(tmp_var,"")) == 0) 
        {
	    mesg = kvf_create_mesg("kvf_oldparse_masteractionline", line,
		         	"'variable' field MUST be specified", 1);
	    kerror("kforms", NULL, mesg);
	    kfree(mesg);
	    return(FALSE);
        }
	else 
	{ 
	    if (line_info->variable != NULL)
		kfree (line_info->variable);
	    line_info->variable = kstring_copy(tmp_var, NULL);
	}


	if (!(kvf_check_boolean(line_info->activate)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_master_action_line", line,
			  "activate must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
            return(FALSE);
        }

	if (!(kvf_check_boolean(line_info->selected)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_master_action_line", line,
		  		"selected must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
            return(FALSE);
        }

	line_info->typeflag = KUIS_MASTERACTION;

	return(TRUE);
}


/************************************************************
*
*      Routine: kvf_oldparse_startguide_line(line, &line_info);
*
*      Purpose: Parses a Start Guide line  (-G:  typeflag = StartGuide)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*
*************************************************************/

int kvf_oldparse_startguide_line(
   char      *line,
   Line_Info *line_info)
{
	char temp[KLENGTH], flag;
	int status;
	char *mesg;

        status = sscanf(line, startguide_oldscan, &flag, 
			&line_info->activate, &line_info->width, 
			&line_info->height, &line_info->x, &line_info->y, 
			&line_info->xpos, &line_info->ypos, temp);
	
	if (status < 9) 
	{
	    mesg = kvf_create_readerror_mesg("kvf_oldparse_startguide_line",
                                          line, status, 9);
	    kerror("kforms", NULL, mesg); kfree(mesg);
            return(FALSE);
	}

	if ((kstrcmp(temp," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) kfree (line_info->title);
	    line_info->title = kstring_copy(temp, NULL);
	}

	if (!(kvf_check_boolean(line_info->activate)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_startguide_line", line,
				"'activate' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
            return(FALSE);
        }

 	if (!(kvf_check_pos(line_info->xpos, line_info->width)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_startguide_line", line, 
		  		"X position is greater than width", 2);
	    status = kprompt(KSTANDARD, "Cont", "Stop", 0, mesg); kfree(mesg);
            if (status == 0) return(FALSE);
        }

 	if (!(kvf_check_pos(line_info->ypos, line_info->height)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_startguide_line", line, 
		  		"Y position is greater than height", 2);

	    status = kprompt(KSTANDARD, "Cont", "Stop", 0, mesg); kfree(mesg);
            if (status == 0) return(FALSE);
	}

	line_info->typeflag = KUIS_STARTGUIDE;

	return(TRUE);
}


/************************************************************
*
*      Routine: kvf_oldparse_startpane_line(line, &line_info);
*
*      Purpose: Parses a Start Form line  (-P:  typeflag = StartForm)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*
*************************************************************/

int kvf_oldparse_startpane_line(
   char      *line,
   Line_Info *line_info)
{
	char tmp_title[KLENGTH], tmp_var[KLENGTH], flag;
	int status;
	char *mesg;

        status = sscanf(line, startpane_oldscan, &flag, 
			&line_info->activate, &line_info->selected,
			&line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, 
			&line_info->xpos, &line_info->ypos, 
			tmp_title, tmp_var);
	

	if (status < 11) 
	{
	    mesg = kvf_create_readerror_mesg("kvf_oldparse_startpane_line",
					 line, status, 11);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
   	}

	if ((kstrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) kfree (line_info->title);
	    line_info->title = kstring_copy(tmp_title, NULL);
	}

	if ((kstrcmp(tmp_var,"")) == 0) 
        {
	    mesg = kvf_create_mesg("kvf_oldparse_startpane_line", line,
		         	"'variable' field MUST be specified", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
        }
	else 
	{ 
	    if (line_info->variable != NULL) kfree (line_info->variable);
	    line_info->variable = kstring_copy(tmp_var, NULL);
	}

	if (!(kvf_check_boolean(line_info->activate)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_startpane_line", line,
		  	 	"'activate' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
            return(FALSE);
        }

 	if (!(kvf_check_pos(line_info->xpos, line_info->width)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_startpane_line", line, 
		  	 	"X position is greater than width", 2);
	    status = kprompt(KSTANDARD, "Cont", "Stop", 0, mesg); kfree(mesg);
            if (status == 0) return(FALSE);
        }

 	if (!(kvf_check_pos(line_info->ypos, line_info->height)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_startpane_line", line, 
		  		"Y position is greater than height", 2);
	    status = kprompt(KSTANDARD, "Cont", "Stop", 0, mesg); kfree(mesg);
            if (status == 0) return(FALSE);
        }


	line_info->typeflag = KUIS_STARTPANE;

	return(TRUE);
}



/************************************************************
*
*      Routine: kvf_oldparse_guide_line(line, &line_info);
*
*      Purpose: Parses a Guide line  (-g:  typeflag = GuideButton)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*
*************************************************************/

int kvf_oldparse_guide_line(
   char      *line,
   Line_Info *line_info)
{
	char temp[KLENGTH], flag;
	int status;
	char *mesg;

        status = sscanf(line, guidebutton_oldscan, &flag, 
			&line_info->activate, &line_info->selected, 
			&line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, temp);

	if (status < 8) 
	{
	    mesg = kvf_create_readerror_mesg("kvf_oldparse_guide_line",
					 line, status, 8);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if ((kstrcmp(temp," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) kfree (line_info->title);
	    line_info->title = kstring_copy(temp, NULL);
	}

	if (!(kvf_check_boolean(line_info->activate)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_guide_line", line,
			  "activate must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
            return(FALSE);
        }

	if (!(kvf_check_boolean(line_info->selected)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_guide_line", line,
		  		"'selected' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
 	    return(FALSE);
        }

	line_info->typeflag = KUIS_GUIDEBUTTON;

	return(TRUE);
}


/************************************************************
*
*      Routine: kvf_oldparse_quit_line(line, &line_info);
*
*      Purpose: Parses a Quit line  (-Q:  typeflag = Quit Form)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*
*************************************************************/

int kvf_oldparse_quit_line(
   char      *line,
   Line_Info *line_info)
{
	char tmp_title[KLENGTH], flag;
	int status;
	char *mesg;

        status = sscanf(line, quitform_oldscan, &flag, 
			&line_info->activate, &line_info->selected,
			&line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, tmp_title);
	
	if (status < 8) 
	{
	    mesg = kvf_create_readerror_mesg("kvf_oldparse_quit_line",line, status,8);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if ((kstrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
  	{ 
	    if (line_info->title != NULL) kfree (line_info->title);
	    line_info->title = kstring_copy(tmp_title, NULL);
  	}

	if (!(kvf_check_boolean(line_info->activate)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_quit_line", line,
		  		"'activate' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
        }

	if (!(kvf_check_boolean(line_info->selected)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_quit_line", line,
		  		"'selected' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
        }

	line_info->typeflag = KUIS_QUIT;

	return(TRUE);
}


/************************************************************
*
*      Routine: kvf_oldparse_subform_action_line(line, &line_info);
*
*      Purpose: Parses an Subform Action line  (-m:  typeflag =  SubformAction)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*
*************************************************************/

int kvf_oldparse_subform_action_line(
   char      *line,
   Line_Info *line_info)
{
	char tmp_title[KLENGTH], tmp_desc[KLENGTH], tmp_var[KLENGTH], 
	     flag;
	int status;
	char *mesg;

        status = sscanf(line, subform_action_oldscan, &flag, 
			&line_info->activate, &line_info->selected, 
			&line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, 
			tmp_title, tmp_desc, tmp_var);
	
	if (status < 10) 
	{
	    mesg = kvf_create_readerror_mesg("kvf_oldparse_subform_action_line",
					 line, status, 10);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
    	}

	if ((kstrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) kfree (line_info->title);
	    line_info->title = kstring_copy(tmp_title, NULL);
	}

	if ((kstrcmp(tmp_desc," ")) == 0) line_info->description = NULL;
	else 
	{ 
	    if (line_info->description != NULL) kfree (line_info->description);
	    line_info->description = kstring_copy(tmp_desc, NULL);
	}

	if ((kstrcmp(tmp_var,"")) == 0) 
        {
	    mesg = kvf_create_mesg("kvf_oldparse_subform_action_line", line,
		         	"'variable' field MUST be specified", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
        }
	else 
	{ 
	    if (line_info->variable != NULL) kfree (line_info->variable);
	    line_info->variable = kstring_copy(tmp_var, NULL);
	}

	if (!(kvf_check_boolean(line_info->activate)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_subform_action_line", line,
		  		"activate must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
            return(FALSE);
        }

	if (!(kvf_check_boolean(line_info->selected)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_subform_action_line", line,
		  		"selected must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
            return(FALSE);
        }

	line_info->typeflag = KUIS_SUBFORMACTION;

	return(TRUE);
}


/************************************************************
*
*      Routine: kvf_oldparse_help_line(line, &line_info);
*
*      Purpose: Parses a Help line  (-H:  typeflag = HelpSel)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*
*************************************************************/

int kvf_oldparse_help_line(
   char      *line,
   Line_Info *line_info)
{
	char tmp_desc[KLENGTH], tmp_title[KLENGTH], 
	     tmp_file[KLENGTH], flag;
	int status;
	char *mesg;

        status = sscanf(line, help_oldscan, &flag, 
			&line_info->activate, &line_info->width, 
			&line_info->height, &line_info->x, &line_info->y, 
			tmp_title, tmp_desc, tmp_file);

	if (status < 9) 
	{
	    mesg = kvf_create_readerror_mesg("kvf_oldparse_help_line",
					 line, status, 9);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if ((kstrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
  	{ 
	    if (line_info->title != NULL) kfree (line_info->title);
	    line_info->title = kstring_copy(tmp_title, NULL);
	}

	if ((kstrcmp(tmp_desc," ")) == 0) line_info->description = NULL;
	else 
	{ 
	    if (line_info->description != NULL) kfree (line_info->description);
	    line_info->description = kstring_copy(tmp_desc, NULL);
	}

	if ((kstrcmp(tmp_file," ")) == 0) line_info->help_file = NULL;
	else 
	{ 
	    if (line_info->help_file != NULL) kfree (line_info->help_file);
	    line_info->help_file = kstring_copy(tmp_file, NULL);
	}

	if (!(kvf_check_boolean(line_info->activate)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_help_line", line,
		  		"activate must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
        }

	line_info->typeflag = KUIS_HELP;
	return(TRUE);
}



/************************************************************
*
*      Routine: kvf_oldparse_input_line(line, &line_info);
*
*      Purpose: Parses an Input line  (-I:  typeflag = InputFile)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*
*************************************************************/

int kvf_oldparse_input_line(
   char      *line,
   Line_Info *line_info)
{
	char tmp_desc[KLENGTH], tmp_title[KLENGTH], tmp_var[KLENGTH], 
	     tmp_filename[KLENGTH], tmp_default[KLENGTH], 
	     tmp_literal[KLENGTH];
	char flag;
	int status;
	char *mesg;

        status = sscanf(line, input_oldscan, &flag, 
			&line_info->activate, &line_info->selected,  
			&line_info->optional, &line_info->opt_sel,
			&line_info->live, &line_info->file_check,
			&line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, 
			&line_info->xpos, &line_info->ypos, 
			tmp_default, tmp_title, tmp_desc, 
			tmp_var, tmp_filename, tmp_literal);
	
	if (status == 19)
        {
            if ((kstrcmp(tmp_literal," ")) == 0) line_info->literal = NULL;
            else
            {
                if (line_info->literal != NULL) kfree (line_info->literal);
                line_info->literal = kstring_copy(tmp_literal, NULL);
            }
	    if ((kstrcmp(tmp_filename," ")) == 0) line_info->filename = NULL;
            else
            {
                if (line_info->filename != NULL) kfree (line_info->filename);
                line_info->filename = kstring_copy(tmp_filename, NULL);
            }
            if ((kstrcmp(tmp_default," ")) == 0) line_info->file_def = NULL;
            else
            {
                if (line_info->file_def != NULL) kfree (line_info->file_def);
                line_info->file_def = kstring_copy(tmp_default, NULL);
            }
        }

	else if (status == 18) 
	{
	    if ((kstrcmp(tmp_filename," ")) == 0) 
	    {
		line_info->filename = NULL;
		line_info->literal = NULL;
	    }
	    else 
	    { 
	        if (line_info->filename != NULL) kfree (line_info->filename);
	        line_info->filename = kstring_copy(tmp_filename, NULL);
	
	        if (line_info->literal != NULL) kfree (line_info->literal);
                line_info->literal = kstring_copy(tmp_filename, NULL);

	    }

	    if ((kstrcmp(tmp_default," ")) == 0) line_info->file_def = NULL;
            else
            {
                if (line_info->file_def != NULL) kfree (line_info->file_def);
                line_info->file_def = kstring_copy(tmp_default, NULL);
            }

	}

	else if (status == 17) 
	{
	    if ((kstrcmp(tmp_default, " ")) == 0)
	    {
	 	line_info->filename = NULL;
	 	line_info->literal = NULL;
	 	line_info->file_def = NULL;

	    }
	    else 
	    {
		if (line_info->file_def != NULL) kfree (line_info->file_def);
                line_info->file_def = kstring_copy(tmp_default, NULL);

		if (line_info->filename != NULL) kfree (line_info->filename);
                line_info->filename = kstring_copy(tmp_default, NULL);
	
	  	if (line_info->literal != NULL) kfree (line_info->literal);
                line_info->literal    = kstring_copy(tmp_default, NULL);
	    }
	}

	else if (status < 17) 
	{
	    mesg = kvf_create_readerror_mesg("kvf_oldparse_input_line",
					 line, status, 17);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if ((kstrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) kfree (line_info->title);
	    line_info->title = kstring_copy(tmp_title, NULL);
	}

	if ((kstrcmp(tmp_desc," ")) == 0) line_info->description = NULL;
	else 
	{ 
	    if (line_info->description != NULL) kfree (line_info->description);
	    line_info->description = kstring_copy(tmp_desc, NULL);
	}

	if ((kstrcmp(tmp_var,"")) == 0) 
        {
	    mesg = kvf_create_mesg("kvf_oldparse_input_line", line,
		         	"'variable' field MUST be specified", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
        }
	else 
	{ 
	    if (line_info->variable != NULL) kfree (line_info->variable);
	    line_info->variable = kstring_copy(tmp_var, NULL);
	}

	if (!(kvf_check_boolean(line_info->activate)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_input_line", line,
		  		"'activate' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->selected)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_input_line", line,
		  		"'selected' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->optional)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_input_line", line,
		  		"'optional' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->opt_sel)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_input_line", line,
		  		"opt_sel must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

        if ((line_info->optional ==0 ) && (line_info->opt_sel != 1))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_input_line", line,
	    "if the 'optional' field = 0, then  the 'opt_sel' must be = 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->live)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_input_line", line,
		  		"'live' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->file_check)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_input_line", line,
		  		"'file_check' field must be > 0 ", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

 	if (!(kvf_check_pos(line_info->xpos, line_info->width)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_input_line", line, 
			 	"X position is greater than width", 2);
	    status = kprompt(KSTANDARD, "Cont", "Stop", 0, mesg); kfree(mesg);
            if (status == 0) return(FALSE);
        }

 	if (!(kvf_check_pos(line_info->ypos, line_info->height)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_input_line", line, 
		  		"Y position is greater than height", 2);
	    status = kprompt(KSTANDARD, "Cont", "Stop", 0, mesg); kfree(mesg);
            if (status == 0) return(FALSE);
        }

	line_info->typeflag = KUIS_INPUTFILE;

	return(TRUE);
}



/************************************************************
*
*      Routine: kvf_oldparse_output_line(line, &line_info);
*
*      Purpose: Parses an Output line  (-O:  typeflag = OutputFile)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*************************************************************/

int kvf_oldparse_output_line(
   char      *line,
   Line_Info *line_info)
{
	char tmp_desc[KLENGTH], tmp_title[KLENGTH], tmp_var[KLENGTH], 
	     tmp_filename[KLENGTH], tmp_default[KLENGTH], 
	     tmp_literal[KLENGTH];
	char flag;
	int  status;
	char *mesg;

        status = sscanf(line, output_oldscan, &flag, 
			&line_info->activate, &line_info->selected, 
			&line_info->optional, &line_info->opt_sel,
		        &line_info->live, &line_info->file_check,
			&line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, 
			&line_info->xpos, &line_info->ypos, 
			tmp_default, tmp_title, tmp_desc, 
			tmp_var, tmp_filename, tmp_literal);
	
	if (status == 19)
        {
            if ((kstrcmp(tmp_literal," ")) == 0) line_info->literal = NULL;
            else
            {
                if (line_info->literal != NULL) kfree (line_info->literal);
                line_info->literal = kstring_copy(tmp_literal, NULL);
            }
	    if ((kstrcmp(tmp_filename," ")) == 0) line_info->filename = NULL;
	    else
	    {
                if (line_info->filename != NULL) kfree (line_info->filename);
                line_info->filename = kstring_copy(tmp_filename, NULL);
	    }
	    if ((kstrcmp(tmp_default," ")) == 0) line_info->file_def = NULL;
	    else
	    {
                if (line_info->file_def != NULL) kfree (line_info->file_def);
                line_info->file_def = kstring_copy(tmp_default, NULL);
	    }
        }

	else if (status == 18) 
	{
	    if ((kstrcmp(tmp_filename," ")) == 0) 
	    {
		line_info->filename = NULL;
		line_info->literal  = NULL;
	    }
	    else 
	    { 
		if (line_info->filename != NULL) kfree (line_info->filename);
                line_info->filename = kstring_copy(tmp_filename, NULL);

		if (line_info->literal != NULL) kfree (line_info->literal);
                line_info->literal = kstring_copy(tmp_filename, NULL);

	    }

	    if ((kstrcmp(tmp_default," ")) == 0) line_info->file_def = NULL;
	    else
	    {
                if (line_info->file_def != NULL) kfree (line_info->file_def);
                line_info->file_def = kstring_copy(tmp_default, NULL);
	    }
	}

	else if (status == 17) 
	{
	    if ((kstrcmp(tmp_default, " ")) == 0)
	    {
		line_info->filename = NULL;
                line_info->literal = NULL;
                line_info->file_def = NULL;
	    }
	    else 
	    {
		if (line_info->file_def != NULL) kfree (line_info->file_def);
                line_info->file_def = kstring_copy(tmp_default, NULL);

                if (line_info->filename != NULL) kfree (line_info->filename);
                line_info->filename = kstring_copy(tmp_default, NULL);

                if (line_info->literal != NULL) kfree (line_info->literal);
                line_info->literal    = kstring_copy(tmp_default, NULL);
	    }
	}

	else if (status < 17) 
	{
	    mesg = kvf_create_readerror_mesg("kvf_oldparse_output_line",
				         line, status, 17);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
    	}

	if ((kstrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) kfree (line_info->title);
	    line_info->title = kstring_copy(tmp_title, NULL);
	}

	if ((kstrcmp(tmp_desc," ")) == 0) line_info->description = NULL;
	else 
	{ 
	    if (line_info->description != NULL) kfree (line_info->description);
	    line_info->description = kstring_copy(tmp_desc, NULL);
	}

	if ((kstrcmp(tmp_var,"")) == 0) 
        {
	    mesg = kvf_create_mesg("kvf_oldparse_output_line", line,
		         	"'variable' field MUST be specified", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
        }
	else 
	{ 
	    if (line_info->variable != NULL) kfree (line_info->variable);
	    line_info->variable = kstring_copy(tmp_var, NULL);
	}

	if (!(kvf_check_boolean(line_info->activate)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_output_line", line,
		  		"'activate' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->selected)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_output_line", line,
		  		"'selected' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->optional)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_output_line", line,
		  		"'optional' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

        if ((line_info->optional ==0 ) && (line_info->opt_sel != 1))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_output_line", line,
	    "if the 'optional' field = 0, then  the 'opt_sel' must be = 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->opt_sel)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_output_line", line,
				"'opt_sel' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->live)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_output_line", line,
		  		"'live' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->file_check)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_output_line", line,
		  		"'file_check' field must > 0", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

 	if (!(kvf_check_pos(line_info->xpos, line_info->width)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_output_line", line, 
		  		"X position is greater than width", 2);
	    status = kprompt(KSTANDARD, "Cont", "Stop", 0, mesg); kfree(mesg);
            if (status == 0) return(FALSE);
        }

 	if (!(kvf_check_pos(line_info->ypos, line_info->height)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_output_line", line, 
		  		"Y position is greater than height", 2);
	    status = kprompt(KSTANDARD, "Cont", "Stop", 0, mesg); kfree(mesg);
            if (status == 0) return(FALSE);
	}

	line_info->typeflag = KUIS_OUTPUTFILE;

	return(TRUE);
}



/************************************************************
*
*      Routine: kvf_oldparse_int_line(line, &line_info);
*
*      Purpose: Parses an Integer line  (-i:  typeflag = IntegerOpt)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*************************************************************/

int kvf_oldparse_int_line(
   char      *line,
   Line_Info *line_info)
{
	char tmp_desc[KLENGTH], tmp_title[KLENGTH], tmp_var[KLENGTH], 
	     tmp_literal[KLENGTH], temp[KLENGTH];
	char flag;
	int  status;
	char *mesg;

        status = sscanf(line, int_oldscan, &flag, 
			&line_info->activate, &line_info->selected, 
			&line_info->optional, &line_info->opt_sel,
			&line_info->live,
			&line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, 
			&line_info->xpos, &line_info->ypos, 
			&line_info->lower_int, &line_info->upper_int, 
			&line_info->int_def, tmp_title, tmp_desc, 
			tmp_var, &line_info->int_val, tmp_literal);

	if (status == 20)
        {
            if ((kstrcmp(tmp_literal," ")) == 0) line_info->literal = NULL;
            else
            {
                if (line_info->literal != NULL) kfree (line_info->literal);
                line_info->literal = kstring_copy(tmp_literal, NULL);
            }
        }

	else if (status == 19)
	{
	     if (!(kvf_check_double((double) line_info->int_val, 
				 (double) line_info->upper_int,
		                 (double) line_info->lower_int,
				 tmp_var, tmp_title)))
		return(FALSE);

	     ksprintf(temp, "%d", line_info->int_val);
	     line_info->literal = kstring_copy(temp, NULL);

	}
	else if (status == 18)  
	{

	     if (!(kvf_check_double((double) line_info->int_def, 
				 (double) line_info->upper_int,
		                 (double) line_info->lower_int,
				 tmp_var, tmp_title)))
	     line_info->int_val = line_info->int_def;
	     ksprintf(temp, "%d", line_info->int_def);
	     line_info->literal = kstring_copy(temp, NULL);

	} /* end if */

	else if (status < 18) 
	{
	    mesg = kvf_create_readerror_mesg("kvf_oldparse_int_line",
					  line, status, 19);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	
	if ((kstrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) kfree (line_info->title);
	    line_info->title = kstring_copy(tmp_title, NULL);
	}

	if ((kstrcmp(tmp_desc," ")) == 0) line_info->description = NULL;
	else 
	{ 
	    if (line_info->description != NULL) kfree (line_info->description);
	    line_info->description = kstring_copy(tmp_desc, NULL);
	}

	if ((kstrcmp(tmp_var,"")) == 0) 
        {
	    mesg = kvf_create_mesg("kvf_oldparse_int_line", line,
			       	"'variable' field MUST be specified", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
        }
	else 
	{ 
	    if (line_info->variable != NULL) kfree (line_info->variable);
	    line_info->variable = kstring_copy(tmp_var, NULL);
	}

	if (!(kvf_check_boolean(line_info->activate)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_int_line", line,
		  		"'activate' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->selected)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_int_line", line,
		 		"'selected' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->optional)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_int_line", line,
			  	   "'optional' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

        if ((line_info->optional ==0 ) && (line_info->opt_sel != 1))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_int_line", line,
	    "if the 'optional' field = 0, then the 'opt_sel' field must be = 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->opt_sel)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_int_line", line,
				"'opt_sel' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->live)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_int_line", line,
	    			"'live' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

 	if (!(kvf_check_pos(line_info->xpos, line_info->width)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_int_line", line, 
		  		"X position is greater than width", 2);
	    status = kprompt(KSTANDARD, "Cont", "Stop", 0, mesg); kfree(mesg);
            if (status == 0) return(FALSE);
        }

 	if (!(kvf_check_pos(line_info->ypos, line_info->height)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_int_line", line, 
		  		"Y position is greater than height", 2);
	    status = kprompt(KSTANDARD, "Cont", "Stop", 0, mesg); kfree(mesg);
            if (status == 0) return(FALSE);
        }



	line_info->typeflag = KUIS_INTEGER;

	return(TRUE);
}



/************************************************************
*
*      Routine: kvf_oldparse_float_line(line, &line_info);
*
*      Purpose: Parses a Float line  (-f:  typeflag = FloatOpt)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*************************************************************/

int kvf_oldparse_float_line(
   char      *line,
   Line_Info *line_info)
{
	char tmp_desc[KLENGTH], tmp_title[KLENGTH], tmp_var[KLENGTH], 
	     tmp_literal[KLENGTH], temp[KLENGTH];
	char flag;
	int  status;
	char *mesg;

        status = sscanf(line, float_oldscan, &flag, 
			&line_info->activate, &line_info->selected, 
			&line_info->optional,  &line_info->opt_sel,
			&line_info->live,
			&line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, 
			&line_info->xpos, &line_info->ypos, 
			&line_info->lower_float, &line_info->upper_float, 
			&line_info->float_def, tmp_title, tmp_desc, 
			tmp_var, &line_info->float_val, tmp_literal);

	if (status == 20)
        {
            if ((kstrcmp(tmp_literal," ")) == 0) line_info->literal = NULL;
            else
            {
                if (line_info->literal != NULL) kfree (line_info->literal);
                line_info->literal = kstring_copy(tmp_literal, NULL);
            }
        }

	else if (status == 19)
	{

	     if (!(kvf_check_double((double) line_info->float_val, 
		     		   (double) line_info->upper_float,
		                   (double) line_info->lower_float,
		 		   tmp_var, tmp_title)))
		return(FALSE);

	     ksprintf(temp, "%g", line_info->float_val);
	     line_info->literal = kstring_copy(temp, NULL);

	}

	else if (status == 18)  
	{
	    if (!(kvf_check_double((double) line_info->float_def, 
		 		 (double)  line_info->upper_float,
		                 (double)  line_info->lower_float,
				  tmp_var, tmp_title)))
		return(FALSE);

	   line_info->float_val = line_info->float_def;
	   ksprintf(temp, "%g", line_info->float_def);
	   line_info->literal = kstring_copy(temp, NULL);

	} /* end if */


	else if (status < 18) 
	{
	    mesg = kvf_create_readerror_mesg("kvf_oldparse_float_line",
					   line, status, 19);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
      	}

	
	if ((kstrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
   	{ 
	    if (line_info->title != NULL) kfree (line_info->title);
	    line_info->title = kstring_copy(tmp_title, NULL);
	}

	if ((kstrcmp(tmp_desc," ")) == 0) line_info->description = NULL;
	else 
	{ 
	    if (line_info->description != NULL) kfree (line_info->description);
	    line_info->description = kstring_copy(tmp_desc, NULL);
	}

	if ((kstrcmp(tmp_var,"")) == 0) 
        {
	    mesg = kvf_create_mesg("kvf_oldparse_float_line", line,
			         "'variable' field MUST be specified", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
        }
	else 
	{ 
	    if (line_info->variable != NULL) kfree (line_info->variable);
	    line_info->variable = kstring_copy(tmp_var, NULL);
	}

	if (!(kvf_check_boolean(line_info->activate)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_float_line", line,
		  		"'activate' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->selected)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_float_line", line,
		  		"'selected' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->optional)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_float_line", line,
		  		"'optional' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

        if ((line_info->optional ==0 ) && (line_info->opt_sel != 1))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_float_line", line,
	    "if the 'optional' field = 0, then  the 'opt_sel' must be = 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->opt_sel)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_float_line", line,
		  		"'opt_sel' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->live)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_float_line", line,
		  		"'live' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

 	if (!(kvf_check_pos(line_info->xpos, line_info->width)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_float_line", line, 
		  		"X position is greater than width", 2);
	    status = kprompt(KSTANDARD, "Cont", "Stop", 0, mesg); kfree(mesg);
            if (status == 0) return(FALSE);
        }

 	if (!(kvf_check_pos(line_info->ypos, line_info->height)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_float_line", line, 
		  		"Y position is greater than height", 2);
	    status = kprompt(KSTANDARD, "Cont", "Stop", 0, mesg); kfree(mesg);
            if (status == 0) return(FALSE);
        }


	line_info->typeflag = KUIS_FLOAT;

	return(TRUE);
}



/************************************************************
*
*      Routine: kvf_oldparse_logic_line(line, &line_info);
*
*      Purpose: Parses a Logic line  (-l:  typeflag = LogicalOpt)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*************************************************************/
int kvf_oldparse_logic_line(
   char      *line,
   Line_Info *line_info)
{
	char tmp_desc[KLENGTH], tmp_title[KLENGTH], tmp_var[KLENGTH];
	char tmp_logic0[KLENGTH], tmp_logic1[KLENGTH]; 
	char flag;
	int status;
	char *mesg;

        status = sscanf(line, logic_oldscan, &flag, 
			&line_info->activate, &line_info->selected, 
			&line_info->optional, &line_info->opt_sel,
			&line_info->live,
			&line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, 
			&line_info->xpos, &line_info->ypos, 
			&line_info->logical_def, tmp_title, 
			tmp_logic0, tmp_logic1, tmp_desc, tmp_var, 
			&line_info->logical_val);
	
	if (status == 18) line_info->logical_val = line_info->logical_def;

	else if (status < 18) 
	{
	    mesg = kvf_create_readerror_mesg("kvf_oldparse_logic_line",
					 line, status, 18);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
       	}

	if ((kstrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) kfree (line_info->title);
	    line_info->title = kstring_copy(tmp_title, NULL);
	}

	if ((kstrcmp(tmp_desc," ")) == 0) line_info->description = NULL;
	else 
	{ 
	    if (line_info->description != NULL) kfree (line_info->description);
	    line_info->description = kstring_copy(tmp_desc, NULL);
	}

	line_info->val_labels = (char **) kcalloc(1, 2* sizeof(char *));
	if ((kstrcmp(tmp_logic0," ")) == 0) line_info->val_labels[0] = NULL;
	else 
	{ 
	    if (line_info->val_labels[0] != NULL) 
		kfree (line_info->val_labels[0]);
	    line_info->val_labels[0] = kstring_copy(tmp_logic0, NULL);
	}

	if ((kstrcmp(tmp_logic1," ")) == 0) line_info->val_labels[1] = NULL;
	else 
	{ 
	    if (line_info->val_labels[1] != NULL) 
		kfree (line_info->val_labels[1]);
	    line_info->val_labels[1] = kstring_copy(tmp_logic1, NULL);
	}

	if ((kstrcmp(tmp_var,"")) == 0) 
        {
	    mesg = kvf_create_mesg("kvf_oldparse_logic_line", line,
		         	"'variable' field MUST be specified", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
        }
	else 
	{ 
	    if (line_info->variable != NULL) kfree (line_info->variable);
	    line_info->variable = kstring_copy(tmp_var, NULL);
	}


	if (!(kvf_check_boolean(line_info->activate)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_logic_line", line,
		  		"'activate' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->selected)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_logic_line", line,
		  		"'selected' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->optional)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_logic_line", line,
		  		"'optional' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->opt_sel)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_logic_line", line,
		  		"'opt_sel' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->live)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_logic_line", line,
		  		"'live' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

 	if (!(kvf_check_pos(line_info->xpos, line_info->width)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_logic_line", line, 
		  		"X position is greater than width", 2);
	    status = kprompt(KSTANDARD, "Cont", "Stop", 0, mesg); kfree(mesg);
            if (status == 0) return(FALSE);
        }

 	if (!(kvf_check_pos(line_info->ypos, line_info->height)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_logic_line", line, 
		  		"Y position is greater than height", 2);
	    status = kprompt(KSTANDARD, "Cont", "Stop", 0, mesg); kfree(mesg);
            if (status == 0) return(FALSE);
        }

	if (!(kvf_check_boolean(line_info->logical_val)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_logic_line", line, 
		  		"Logical value must be 1 or 0", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->logical_def)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_logic_line", line, 
		  		"Logical default value must be 1 or 0", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	line_info->typeflag = KUIS_LOGICAL;

	return(TRUE);
}





/************************************************************
*
*      Routine: kvf_oldparse_cycle_line(line, &line_info);
*
*      Purpose: Parses a Cycle line  (-c:  typeflag = Cycle)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*************************************************************/
int kvf_oldparse_cycle_line(
   char      *line,
   Line_Info *line_info)
{
	char tmp_desc[KLENGTH], tmp_title[KLENGTH], tmp_var[KLENGTH];
	char tmp_label[KLENGTH]; 
	char flag;
	int status, i, j;
	char *mesg, *scanstr;

        status = sscanf(line, cycle_oldscan, &flag, 
			&line_info->activate, &line_info->selected, 
			&line_info->optional, &line_info->opt_sel,
			&line_info->live,
			&line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, 
			&line_info->xpos, &line_info->ypos, 
			&line_info->list_num, &line_info->list_val,
			tmp_title, tmp_desc, tmp_var);
	
	if (status < 17) 
	{
	    mesg = kvf_create_readerror_mesg("kvf_oldparse_cycle_line",
					 line, status, 17);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
       	}

	if ((kstrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) kfree (line_info->title);
	    line_info->title = kstring_copy(tmp_title, NULL);
	}

	if ((kstrcmp(tmp_desc," ")) == 0) line_info->description = NULL;
	else 
	{ 
	    if (line_info->description != NULL) kfree (line_info->description);
	    line_info->description = kstring_copy(tmp_desc, NULL);
	}

	if ((kstrcmp(tmp_var,"")) == 0) 
        {
	    mesg = kvf_create_mesg("kvf_oldparse_cycle_line", line,
		         	"'variable' field MUST be specified", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
        }
	else 
	{ 
	    if (line_info->variable != NULL) kfree (line_info->variable);
	    line_info->variable = kstring_copy(tmp_var, NULL);
	}


	if (!(kvf_check_boolean(line_info->activate)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_cycle_line", line,
		  		"'activate' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->selected)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_cycle_line", line,
		  		"'selected' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->optional)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_cycle_line", line,
		  		"'optional' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->opt_sel)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_cycle_line", line,
		  		"'opt_sel' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->live)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_cycle_line", line,
		  		"'live' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

 	if (!(kvf_check_pos(line_info->xpos, line_info->width)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_cycle_line", line, 
		  		"X position is greater than width", 2);
	    status = kprompt(KSTANDARD, "Cont", "Stop", 0, mesg); kfree(mesg);
            if (status == 0) return(FALSE);
        }

 	if (!(kvf_check_pos(line_info->ypos, line_info->height)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_cycle_line", line, 
		  		"Y position is greater than height", 2);
	    status = kprompt(KSTANDARD, "Cont", "Stop", 0, mesg); kfree(mesg);
            if (status == 0) return(FALSE);
        }

	if (line_info->list_val > line_info->list_num)
	{
	    mesg = kvf_create_mesg("kvf_oldparse_cycle_line", line, 
  		"List value must be less than or equal to number of items in list", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

        i = 0;
	if (line_info->title != NULL)
	{
	    while ((kstrncmp(&line[i], line_info->title, 
		        kstrlen(line_info->title))) != 0)
		i++;
	    i+= kstrlen(line_info->title); 
	}
	if (line_info->description != NULL)
	{
	    while ((kstrncmp(&line[i], line_info->description, 
		        kstrlen(line_info->description))) != 0)
		i++;
	    i+= kstrlen(line_info->description); 
	}
	if (line_info->variable != NULL)
	{
	    while ((kstrncmp(&line[i], line_info->variable, 
		        kstrlen(line_info->variable))) != 0)
		i++;
	    i+= kstrlen(line_info->variable);
	}

	scanstr = kstring_copy("%*[ ]%*['`]%[^'`]", NULL);
	line_info->val_labels = (char **) kcalloc(1, line_info->list_num*
						     sizeof(char *));
	for (j = 0; j < line_info->list_num; j++)
	{
	    status = sscanf(&line[i], scanstr, tmp_label);
	    if (status != 1) 
	    {
	        mesg = kvf_create_mesg("kvf_oldparse_cycle_line", line, 
			"Unable to read correct number of cycle labels", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	        return(FALSE);
	    }
	    line_info->val_labels[j] = kstring_copy(tmp_label, NULL);
	    i = i + kstrlen(line_info->val_labels[j]) + 3;
	    scanstr = kstring_copy("%*[ ]%*['`]%[^'`]%*[ '`]", NULL);
	}

	line_info->typeflag = KUIS_CYCLE;

	
	return(TRUE);
}




/************************************************************
*
*      Routine: kvf_oldparse_list_line(line, &line_info);
*
*      Purpose: Parses a List line  (-x:  typeflag = List)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro 
*
*************************************************************/

int kvf_oldparse_list_line(
   char      *line,
   Line_Info *line_info)
{
	char tmp_desc[KLENGTH], tmp_title[KLENGTH], tmp_var[KLENGTH];
	char tmp_label[KLENGTH]; 
	char flag;
	int status, i, j;
	char *mesg, *scanstr;

        status = sscanf(line, list_oldscan, &flag, 
			&line_info->activate, &line_info->selected, 
			&line_info->optional, &line_info->opt_sel,
			&line_info->live,
			&line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, 
			&line_info->xpos, &line_info->ypos, 
			&line_info->list_num, &line_info->list_val,
			tmp_title, tmp_desc, tmp_var);
	
	if (status < 17) 
	{
	    mesg = kvf_create_readerror_mesg("kvf_oldparse_list_line",
					 line, status, 17);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
       	}

	if ((kstrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) kfree (line_info->title);
	    line_info->title = kstring_copy(tmp_title, NULL);
	}

	if ((kstrcmp(tmp_desc," ")) == 0) line_info->description = NULL;
	else 
	{ 
	    if (line_info->description != NULL) kfree (line_info->description);
	    line_info->description = kstring_copy(tmp_desc, NULL);
	}

	if ((kstrcmp(tmp_var,"")) == 0) 
        {
	    mesg = kvf_create_mesg("kvf_oldparse_logic_line", line,
		         	"'variable' field MUST be specified", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
        }
	else 
	{ 
	    if (line_info->variable != NULL) kfree (line_info->variable);
	    line_info->variable = kstring_copy(tmp_var, NULL);
	}


	if (!(kvf_check_boolean(line_info->activate)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_list_line", line,
		  		"'activate' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->selected)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_list_line", line,
		  		"'selected' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->optional)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_list_line", line,
		  		"'optional' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->opt_sel)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_list_line", line,
		  		"'opt_sel' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->live)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_list_line", line,
		  		"'live' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

 	if (!(kvf_check_pos(line_info->xpos, line_info->width)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_list_line", line, 
		  		"X position is greater than width", 2);
	    status = kprompt(KSTANDARD, "Cont", "Stop", 0, mesg); kfree(mesg);
            if (status == 0) return(FALSE);
        }

 	if (!(kvf_check_pos(line_info->ypos, line_info->height)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_list_line", line, 
		  		"Y position is greater than height", 2);
	    status = kprompt(KSTANDARD, "Cont", "Stop", 0, mesg); kfree(mesg);
            if (status == 0) return(FALSE);
        }

	if ((line_info->list_val < 1) || 
	    (line_info->list_val > line_info->list_num))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_list_line", line, 
  		"List value must be less than or equal to number of items in list", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

        i = 0;
	if (line_info->title != NULL)
	{
	    while ((kstrncmp(&line[i], line_info->title, 
		        kstrlen(line_info->title))) != 0)
		i++;
	    i+= kstrlen(line_info->title); 
	}
	if (line_info->description != NULL)
	{
	    while ((kstrncmp(&line[i], line_info->description, 
		        kstrlen(line_info->description))) != 0)
		i++;
	    i+= kstrlen(line_info->description); 
	}
	if (line_info->variable != NULL)
	{
	    while ((kstrncmp(&line[i], line_info->variable, 
		        kstrlen(line_info->variable))) != 0)
		i++;
	    i+= kstrlen(line_info->variable);
	}

	scanstr = kstring_copy("%*[ ]%*['`]%[^'`]", NULL);
	line_info->val_labels = (char **) kcalloc(1, line_info->list_num*
						     sizeof(char *));
	for (j = 0; j < line_info->list_num; j++)
	{
	    status = sscanf(&line[i], scanstr, tmp_label);
	    if (status != 1) 
	    {
	        mesg = kvf_create_mesg("kvf_oldparse_list_line", line, 
			"Unable to read correct number of list labels", 1);
	        kerror("kforms", NULL, mesg); kfree(mesg);
	        return(FALSE);
	    }
	    line_info->val_labels[j] = kstring_copy(tmp_label, NULL);
	    i = i + kstrlen(line_info->val_labels[j]) + 3;
	    scanstr = kstring_copy("%*[ ]%*['`]%[^'`]%*[ '`]", NULL);
	}

	line_info->typeflag = KUIS_LIST;

	
	return(TRUE);
}




/************************************************************
*
*      Routine: kvf_oldparse_string_line(line, &line_info);
*
*      Purpose: Parses a String line  (-s: typeflag = StringOpt)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*************************************************************/

int kvf_oldparse_string_line(
   char      *line,
   Line_Info *line_info)
{
	char tmp_desc[KLENGTH], tmp_title[KLENGTH], tmp_var[KLENGTH], 
	     tmp_default[10*KLENGTH], tmp_string[10*KLENGTH], 
	     tmp_literal[10*KLENGTH];
	char flag;
	int  status;
	char *mesg;

	/*
	 *  Initialize the tmp strings to be empty so that if we call
	 *  kchar_replace() so that if the field hasn't been initialized by
	 *  sscanf() we don't khoros dump.
	 */
	tmp_string[0] =
	tmp_default[0] =
	tmp_literal[0] = '\0';

        status = sscanf(line, string_oldscan, &flag, 
			&line_info->activate, &line_info->selected, 
			&line_info->optional, &line_info->opt_sel,
			&line_info->live,
			&line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, 
			&line_info->xpos, &line_info->ypos, 
			tmp_default, tmp_title, tmp_desc, 
			tmp_var, tmp_string, tmp_literal);
	
	/*
	 *  Replace all 0x1f characters with ' characters.
	 */
	(void) kchar_replace(tmp_string, 0x1f, '\'', tmp_string);
	(void) kchar_replace(tmp_default, 0x1f, '\'', tmp_default);
	(void) kchar_replace(tmp_literal, 0x1f, '\'', tmp_literal);

	if (status == 18)
        {
            if ((kstrcmp(tmp_literal," ")) == 0) line_info->literal = NULL;
            else
            {
                if (line_info->literal != NULL) kfree (line_info->literal);
                line_info->literal = kstring_copy(tmp_literal, NULL);
            }
	    if ((kstrcmp(tmp_string," ")) == 0) line_info->string_val = NULL;
            else
	    {
                if (line_info->string_val != NULL) kfree (line_info->string_val);
                line_info->string_val = kstring_copy(tmp_string, NULL);
	    }
	    if ((kstrcmp(tmp_default," ")) == 0) line_info->string_def = NULL;
            else
            {
                if (line_info->string_def != NULL) kfree (line_info->string_def);
                line_info->string_def = kstring_copy(tmp_default, NULL);
            }

        }

	else if (status == 17) 
	{
	    if ((kstrcmp(tmp_string," ")) == 0) 
	    {
		line_info->string_val = NULL;
		line_info->literal = NULL;
	    }
	    else 
	    { 
	        if (line_info->string_val != NULL) kfree (line_info->string_val);
	        line_info->string_val = kstring_copy(tmp_string, NULL);

	        if (line_info->literal != NULL) kfree (line_info->literal);
	        line_info->literal = kstring_copy(tmp_string, NULL);
	    }

	    if ((kstrcmp(tmp_default," ")) == 0) line_info->string_def = NULL;
            else
            {
                if (line_info->string_def != NULL) kfree (line_info->string_def);
                line_info->string_def = kstring_copy(tmp_default, NULL);
            }

	 }

	else if (status == 16) 
	{
	    if ((kstrcmp(tmp_default, " ")) == 0)
	    {
	 	line_info->string_val = NULL;
	 	line_info->literal = NULL;
	 	line_info->string_def = NULL;
	    }
	    else 
	    {
	        if (line_info->string_def != NULL) kfree (line_info->string_def);
	        line_info->string_def = kstring_copy(tmp_default, NULL);

	        if (line_info->string_val != NULL) kfree (line_info->string_val);
	        line_info->string_val = kstring_copy(tmp_default, NULL);

	        if (line_info->literal != NULL) kfree (line_info->literal);
	        line_info->literal    = kstring_copy(tmp_default, NULL);
	    }
	}

	if (status < 16) 
	{
	    mesg = kvf_create_readerror_mesg("kvf_oldparse_string_line",
					 line, status, 16);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if ((kstrcmp(tmp_default," ")) == 0) line_info->string_def = NULL;
	else 
	{ 
	    if (line_info->string_def != NULL) kfree (line_info->string_def);
	    line_info->string_def = kstring_copy(tmp_default, NULL);
	}

	if ((kstrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) kfree (line_info->title);
	    line_info->title = kstring_copy(tmp_title, NULL);
	}

	if ((kstrcmp(tmp_desc," ")) == 0) line_info->description = NULL;
	else 
	{ 
	    if (line_info->description != NULL) kfree (line_info->description);
	    line_info->description = kstring_copy(tmp_desc, NULL);
	}

	if ((kstrcmp(tmp_var,"")) == 0) 
        {
	    mesg = kvf_create_mesg("kvf_oldparse_string_line", line,
		         	"'variable' field MUST be specified", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
        }
	else 
	{ 
	    if (line_info->variable != NULL) kfree (line_info->variable);
	    line_info->variable = kstring_copy(tmp_var, NULL);
	}

	if (!(kvf_check_boolean(line_info->activate)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_string_line", line,
		  		"'activate' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->selected)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_string_line", line,
		  		"'selected' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->optional)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_string_line", line,
		 		"'optional' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

        if ((line_info->optional ==0 ) && (line_info->opt_sel != 1))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_string_line", line,
	    "if the 'optional' field = 0, then  the 'opt_sel' must be = 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->opt_sel)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_string_line", line,
		  		"'opt_sel' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->live)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_string_line", line,
		  		"'live' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

 	if (!(kvf_check_pos(line_info->xpos, line_info->width)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_string_line", line, 
		  		"X position is greater than width", 2);
	    status = kprompt(KSTANDARD, "Cont", "Stop", 0, mesg); kfree(mesg);
            if (status == 0) return(FALSE);
        }

 	if (!(kvf_check_pos(line_info->ypos, line_info->height)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_string_line", line, 
		  		"Y position is greater than height", 2);
	    status = kprompt(KSTANDARD, "Cont", "Stop", 0, mesg); kfree(mesg);
            if (status == 0) return(FALSE);
        }

	line_info->typeflag = KUIS_STRING;


	return(TRUE);
}


int kvf_oldparse_flag_line(
   char      *line,
   Line_Info *line_info)
{
        char tmp_desc[KLENGTH], tmp_title[KLENGTH], tmp_var[KLENGTH];
        char flag;
        int status;
        char *mesg;

        status = sscanf(line, flag_scan, &flag,
                        &line_info->activate, &line_info->selected,
                        &line_info->optional, &line_info->opt_sel,
                        &line_info->live,
                        &line_info->width, &line_info->height,
                        &line_info->x, &line_info->y,
                        &line_info->xpos, &line_info->ypos,
                        tmp_title, tmp_desc, tmp_var);

        if (status < 15)
        {
            mesg = kvf_create_readerror_mesg("kvf_parse_flag_line",
					     line, status, 15);
            kerror("kforms", "kvf_parse_flag_line",
                         mesg); kfree(mesg);
	    errno = KUIS_SYNTAX;
            return(FALSE);
        }

        if (line_info->title != NULL) kfree (line_info->title);
        if ((kstrcmp(tmp_title," ")) == 0) line_info->title = NULL;
        else line_info->title = kstring_copy(tmp_title, NULL);

        if (line_info->description != NULL) kfree (line_info->description);
        if ((kstrcmp(tmp_desc," ")) == 0) line_info->description = NULL;
        else line_info->description = kstring_copy(tmp_desc, NULL);

        if (line_info->variable != NULL) kfree (line_info->variable);
        line_info->variable = kstring_copy(tmp_var, NULL);
        line_info->typeflag = KUIS_FLAG;

        return(TRUE);
}


int kvf_oldparse_stringlist_line(
   char      *line,
   Line_Info *line_info)
{
        char tmp_desc[KLENGTH], tmp_title[KLENGTH], tmp_var[KLENGTH],
             tmp_string[10*KLENGTH], tmp_literal[10*KLENGTH],
             tmp_label[KLENGTH];
        char flag;
        int  status, i, j;
        char *mesg, *scanstr;

        /*
         *  Initialize the tmp strings to be empty so that if we call
         *  kchar_replace() so that if the field hasn't been initialized by
         *  sscanf() we don't khoros dump.
         */
        tmp_string[0] =
        tmp_literal[0] = '\0';

        /*
         *  scan in & store everything up to & including variable
         */
        status = sscanf(line, stringlist_scan, &flag,
                        &line_info->activate, &line_info->selected,
                        &line_info->optional, &line_info->opt_sel,
                        &line_info->live,
                        &line_info->width, &line_info->height,
                        &line_info->x, &line_info->y,
                        &line_info->xpos, &line_info->ypos,
                        &line_info->list_num,
                        &line_info->list_val,
                        tmp_title, tmp_desc, tmp_var);

        /*
         *  Replace all 0x1f characters with ' characters.
         */
        (void) kchar_replace(tmp_string, 0x1f, '\'', tmp_string);
        (void) kchar_replace(tmp_literal, 0x1f, '\'', tmp_literal);

        if (status < 17)
        {
            mesg = kvf_create_readerror_mesg("kvf_parse_stringlist_line",
					     line, status, 17);
            kerror("kforms", "kvf_parse_stringlist_line",
                         mesg); kfree(mesg);
	    errno = KUIS_SYNTAX;
            return(FALSE);
        }

        if (line_info->title != NULL) kfree (line_info->title);
        if ((kstrcmp(tmp_title," ")) == 0) line_info->title = NULL;
        else line_info->title = kstring_copy(tmp_title, NULL);

        if (line_info->description != NULL) kfree (line_info->description);
        if ((kstrcmp(tmp_desc," ")) == 0) line_info->description = NULL;
        else line_info->description = kstring_copy(tmp_desc, NULL);

        if (line_info->variable != NULL) kfree (line_info->variable);
        line_info->variable = kstring_copy(tmp_var, NULL);

        /*
         *  move thru line past variable
         */
        i = 0;
        if (line_info->title != NULL)
        {
            while ((kstrncmp(&line[i], line_info->title,
                        kstrlen(line_info->title))) != 0)
                i++;
            i+= kstrlen(line_info->title);
        }
        if (line_info->description != NULL)
        {
            while ((kstrncmp(&line[i], line_info->description,
                        kstrlen(line_info->description))) != 0)
                i++;
            i+= kstrlen(line_info->description);
        }
        if (line_info->variable != NULL)
        {
            while ((kstrncmp(&line[i], line_info->variable,
                        kstrlen(line_info->variable))) != 0)
                i++;
            i+= kstrlen(line_info->variable);
        }

        /*
         * read in strings to appear in list
         */
        if (line_info->val_labelnum !=  line_info->list_num)
        {
            for (j = 0; j < line_info->val_labelnum; j++)
                kfree(line_info->val_labels[j]);
            kfree(line_info->val_labels);

            line_info->val_labels = (char **) kcalloc(1,sizeof(char *) *
                                                        line_info->list_num);
            line_info->val_labelnum = line_info->list_num;
        }

        scanstr = "%*[ ]%*['`]%[^'`]";
        for (j = 0; j < line_info->list_num; j++)
        {
            status = sscanf(&line[i], scanstr, tmp_label);
            if (status != 1)
            {
                mesg = kvf_create_mesg(line, "Unable to read correct number of stringlist values", "all stringlist fields MUST be present", 1);
                kerror("kforms", "kvf_parse_stringlist_line",
                           mesg); kfree(mesg);
		errno = KUIS_SYNTAX;
                return(FALSE);
            }
            if (line_info->val_labels[j] != NULL)
                kfree(line_info->val_labels[j]);
            line_info->val_labels[j] = kstring_copy(tmp_label, NULL);

            i = i + kstrlen(line_info->val_labels[j]) + 3;

            if (j == 0)
               scanstr = "%*[ ]%*['`]%[^'`]%*[ '`]";
        }

        if (line_info->string_def != NULL) kfree(line_info->string_def);
        if ((kstrcmp(line_info->val_labels[line_info->list_val-1], " ")) == 0)
            line_info->string_def = NULL;
        else line_info->string_def =
                kstring_copy(line_info->val_labels[line_info->list_val-1], NULL);

        /*
         *  finally, pull in string value & literal if they are there
         */
        status = sscanf(&line[i],
                        "%*[ ]%*['`]%[^'`]%*['`]%*[ ]%*['`]%[^'`]%*['`]",
                        tmp_string, tmp_literal);

        if (line_info->string_val != NULL) kfree (line_info->string_val);
        if (line_info->literal != NULL) kfree (line_info->literal);

        /* assign both string val & literal */
        if (status == 2)
        {
            if ((kstrcmp(tmp_string," ")) == 0) line_info->string_val = NULL;
            else line_info->string_val = kstring_copy(tmp_string, NULL);

            if ((kstrcmp(tmp_literal," ")) == 0) line_info->literal = NULL;
            else line_info->literal = kstring_copy(tmp_literal, NULL);
        }

        /* assign string val, take same value for literal */
        else if (status == 1)
        {
            if ((kstrcmp(tmp_string," ")) == 0)
            {
                line_info->string_val = NULL;
                line_info->literal = NULL;
            }
            else
            {
                line_info->string_val = kstring_copy(tmp_string, NULL);
                line_info->literal = kstring_copy(tmp_string, NULL);
            }
        }

        /* get string val & literal from default */
        else if (status < 1)
        {
            if (line_info->string_def == NULL)
            {
                line_info->string_val = NULL;
                line_info->literal = NULL;
            }
            else
            {
                line_info->string_val=kstring_copy(line_info->string_def, NULL);
                line_info->literal = kstring_copy(line_info->string_def, NULL);
            }
        }

        line_info->typeflag = KUIS_STRINGLIST;
        return(TRUE);

}


/************************************************************
*
*      Routine: kvf_oldparse_routine_line(line, &line_info);
*
*      Purpose: Parses a Routine line  (-r:  typeflag = Routine)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*************************************************************/

int kvf_oldparse_routine_line(
   char      *line,
   Line_Info *line_info)
{
	char tmp_desc[KLENGTH], tmp_title[KLENGTH], 
	     tmp_routine[KLENGTH], flag;
	int status;
	char *mesg;

        status = sscanf(line, routine_oldscan, &flag, 
			&line_info->activate, &line_info->selected,
			&line_info->exec_type,
		        &line_info->width, &line_info->height, 
		  	&line_info->x, &line_info->y, 
			tmp_title, tmp_desc, tmp_routine);
	
	if (status < 11) 
	{
	    mesg = kvf_create_readerror_mesg("kvf_oldparse_routine_line",
					 line, status, 11);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if ((kstrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) kfree (line_info->title);
	    line_info->title = kstring_copy(tmp_title, NULL);
	}

	if ((kstrcmp(tmp_desc," ")) == 0) line_info->description = NULL;
	else 
	{ 
	    if (line_info->description != NULL) kfree (line_info->description);
	    line_info->description = kstring_copy(tmp_desc, NULL);
	}

	if ((kstrcmp(tmp_routine,"")) == 0) 
        {
	    mesg = kvf_create_mesg("kvf_oldparse_routine_line", line,
		         	"'routine' field MUST be specified", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
        }
	else
	{
	    if (line_info->variable != NULL) kfree (line_info->variable);
 	    line_info->routine = kstring_copy(tmp_routine, NULL);
	}

	if (!(kvf_check_boolean(line_info->activate)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_routine_line", line,
		  		"'activate' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->selected)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_routine_line", line,
		  		"'selected' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if ((line_info->exec_type != 0) && 
	    (line_info->exec_type != 1) &&
	    (line_info->exec_type != 2) &&
	    (line_info->exec_type != 3) &&
	    (line_info->exec_type != 4))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_routine_line", line,
		  		"'exec_type' field must be between 0 and 4", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	line_info->typeflag = KUIS_ROUTINE;

	return(TRUE);
}




/************************************************************
*
*      Routine: kvf_oldparse_toggle_line(line, &line_info);
*
*      Purpose: Parses a Toggle line  (-T:  typeflag = Toggle)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*************************************************************/

int kvf_oldparse_toggle_line(
   char      *line,
   Line_Info *line_info)
{
	char tmp_desc[KLENGTH], tmp_title[KLENGTH], tmp_var[KLENGTH],
	     flag;
	int status;
	char *mesg;

        status = sscanf(line, toggle_oldscan, &flag, 
			&line_info->activate, &line_info->selected, 
			&line_info->optional,  &line_info->opt_sel,
			&line_info->live,
		 	&line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, 
			&line_info->xpos, &line_info->ypos, 
			&line_info->toggle_def, tmp_title, tmp_desc, 
			tmp_var, &line_info->toggle_val);
	


	if (status < 16) 
	{
	    mesg = kvf_create_readerror_mesg("kvf_oldparse_toggle_line",line, status, 15);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if ((kstrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) kfree (line_info->title);
	    line_info->title = kstring_copy(tmp_title, NULL);
	}

	if ((kstrcmp(tmp_desc," ")) == 0) line_info->description = NULL;
	else 
	{ 
	    if (line_info->description != NULL) kfree (line_info->description);
	    line_info->description = kstring_copy(tmp_desc, NULL);
	}

	if ((kstrcmp(tmp_var,"")) == 0) 
        {
	    mesg = kvf_create_mesg("kvf_oldparse_toggle_line", line,
		         	"'variable' field MUST be specified", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
        }
	else 
	{ 
	    if (line_info->variable != NULL) kfree (line_info->variable);
	    line_info->variable = kstring_copy(tmp_var, NULL);
	}

	if (!(kvf_check_boolean(line_info->activate)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_toggle_line", line,
		  		"'activate' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->selected)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_toggle_line", line,
		  		"'selected' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->optional)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_toggle_line", line,
		  		"'optional' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

        if ((line_info->optional ==0 ) && (line_info->opt_sel != 1))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_toggle_line", line,
	    "if the 'optional' field = 0, then  the 'opt_sel' must be = 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->opt_sel)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_toggle_line", line,
		  		"'opt_sel' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->live)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_toggle_line", line,
		  		"'live' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

 	if (!(kvf_check_pos(line_info->xpos, line_info->width)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_toggle_line", line, 
		  		"X position is greater than width", 2);
	    status = kprompt(KSTANDARD, "Cont", "Stop", 0, mesg); kfree(mesg);
            if (status == 0) return(FALSE);
        }

 	if (!(kvf_check_pos(line_info->ypos, line_info->height)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_toggle_line", line, 
		  		"Y position is greater than height", 2);
	    status = kprompt(KSTANDARD, "Cont", "Stop", 0, mesg); kfree(mesg);
            if (status == 0) return(FALSE);
        }

	line_info->typeflag = KUIS_TOGGLE;


	return(TRUE);
}




/************************************************************
*
*      Routine: kvf_oldparse_blank_line(line, &line_info);
*
*      Purpose: Parses a blank line  (-b:  typeflag = Blank)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*************************************************************/

int kvf_oldparse_blank_line(
   char      *line,
   Line_Info *line_info)
{
	char tmp_title[KLENGTH], flag;
	int status;
	char *mesg;

        status = sscanf(line, blank_oldscan, &flag, 
			&line_info->xpos, &line_info->ypos, tmp_title); 

	if (status < 4) 
	{
	    mesg = kvf_create_readerror_mesg("kvf_oldparse_blank_line",
					 line, status, 4);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if ((kstrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) kfree (line_info->title);
	    line_info->title = kstring_copy(tmp_title, NULL);
	}

	line_info->typeflag = KUIS_BLANK;

	return(TRUE);
}




/************************************************************
*
*      Routine: kvf_oldparse_pane_action_line(line, &line_info);
*
*      Purpose: Parses a Pane Action line  (-a:  typeflag = PaneAction)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro & Stephanie Hallett & Mark Young
*
*************************************************************/

int kvf_oldparse_pane_action_line(
   char      *line,
   Line_Info *line_info)
{
	char tmp_desc[KLENGTH], tmp_title[KLENGTH], tmp_var[KLENGTH], 
	     flag;
	int status;
	char *mesg;

        status = sscanf(line, pane_action_oldscan, &flag, 
			&line_info->activate, &line_info->selected, 
			&line_info->width, &line_info->height, 
			&line_info->x, &line_info->y, 
			tmp_title, tmp_desc, tmp_var);
	
	if (status < 10) 
	{
	    mesg = kvf_create_readerror_mesg("kvf_oldparse_pane_action_line",
					 line, status, 10);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if ((kstrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) kfree (line_info->title);
	    line_info->title = kstring_copy(tmp_title, NULL);
	}

	if ((kstrcmp(tmp_desc," ")) == 0) line_info->description = NULL;
	else 
	{ 
	    if (line_info->description != NULL) kfree (line_info->description);
	    line_info->description = kstring_copy(tmp_desc, NULL);
	}

	if ((kstrcmp(tmp_var,"")) == 0) 
        {
	    mesg = kvf_create_mesg("kvf_oldparse_pane_action_line", line,
		         	"'variable' field MUST be specified", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
        }
	else 
	{ 
	    if (line_info->variable != NULL) kfree (line_info->variable);
	    line_info->variable = kstring_copy(tmp_var, NULL);
	}

	if (!(kvf_check_boolean(line_info->activate)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_pane_action_line", line,
		  		"'activate' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (!(kvf_check_boolean(line_info->selected)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_pane_action_line", line,
		  		"'selected' field must be 0 or 1", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	line_info->typeflag = KUIS_PANEACTION;

	return(TRUE);
}



/************************************************************
*
*      Routine: kvf_oldparse_includepane_line(line, &line_info);
*
*      Purpose: Parses an IncludePane line  (-p:  typeflag = IncludePane)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro 
*
*************************************************************/

int kvf_oldparse_includepane_line(
   char      *line,
   Line_Info *line_info)
{
	char tmp_file[KLENGTH], flag, *mesg;
	int status;

        status = sscanf(line, includepane_oldscan, &flag, tmp_file);

	if (status < 2) 
	{
	    mesg = kvf_create_readerror_mesg("kvf_oldparse_includepane_line",
					 line, status, 2);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}
	
	if ((kstrcmp(tmp_file," ")) == 0) 
	{
	    line_info->filename = NULL;
	    mesg = kvf_create_mesg("kvf_oldparse_includepane_line", line,
                                    "-p MUST be followed by filename", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}
	else 
	{ 
	    if (line_info->filename != NULL) kfree (line_info->filename);
	    line_info->filename = kstring_copy(tmp_file, NULL);
	}

	line_info->typeflag = KUIS_INCLUDEPANE;

	return(TRUE);
}



/************************************************************
*
*      Routine: kvf_oldparse_includesubform_line(line, &line_info);
*
*      Purpose: Parses an IncludeSubForm line  (-k:  typeflag = IncludeSubForm)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro 
*
*************************************************************/

int kvf_oldparse_includesubform_line(
   char      *line,
   Line_Info *line_info)
{
	char tmp_file[KLENGTH], flag, *mesg;
	int status;

        status = sscanf(line, includesubform_oldscan, &flag, tmp_file);
	if (status < 2) 
	{
	    mesg = kvf_create_readerror_mesg("kvf_oldparse_includesubform_line",
					 line, status, 2);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}
	
	if ((kstrcmp(tmp_file," ")) == 0) 
	{
	    line_info->filename = NULL;
	    mesg = kvf_create_mesg("kvf_oldparse_includesubform_line", line,
                                   "-k MUST be followed by filename", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}
	else 
	{ 
	    if (line_info->filename != NULL) kfree (line_info->filename);
	    line_info->filename = kstring_copy(tmp_file, NULL);
	}

	line_info->typeflag = KUIS_INCLUDESUBFORM;

	return(TRUE);
}


/************************************************************
*
*      Routine: kvf_oldparse_mutexcl_line(line, &line_info);
*
*      Purpose: Parses a Mutually Exclusive line  (-C:  typeflag = MutExcl)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro 
*
*************************************************************/

int kvf_oldparse_mutexcl_line(
   char      *line,
   Line_Info *line_info)
{
	char flag, *mesg;
	int status;

        status = sscanf(line, "-%c %d", &flag, &line_info->logical_val);
	if (flag != 'C') return(FALSE);
	if (status < 2) 
	{
	    mesg = kvf_create_readerror_mesg("kvf_oldparse_mutexcl_line",
					 line, status, 2);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}
	
	line_info->typeflag = KUIS_MUTEXCL;

	return(TRUE);
}


/************************************************************
*
*      Routine: kvf_oldparse_workspace_line(line, &line_info);
*
*      Purpose: Parses a Workspace line  (-W:  typeflag = WorkWidget)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro 
*
*************************************************************/


int kvf_oldparse_workspace_line(
   char      *line,
   Line_Info *line_info)
{
	char flag, *mesg;
	int  status;
	char tmp_desc[KLENGTH], tmp_title[KLENGTH], tmp_var[KLENGTH]; 
	long tmp_wksp_address;

        status = sscanf(line, workspace_oldscan, &flag,
			&line_info->width, &line_info->height,
                        &line_info->x, &line_info->y,
                        &line_info->xpos, &line_info->ypos,
			tmp_title, tmp_desc, tmp_var, &tmp_wksp_address);
	if (flag != 'w') return(FALSE);

        if (status == 11)
	{
	    line_info->workspace = (xvobject) tmp_wksp_address;
	}
	else if (status < 10) 
	{
	    mesg = kvf_create_readerror_mesg("kvf_oldparse_workspace_line",
					 line, status, 10);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if ((kstrcmp(tmp_title," ")) == 0) line_info->title = NULL;
	else 
	{ 
	    if (line_info->title != NULL) kfree (line_info->title);
	    line_info->title = kstring_copy(tmp_title, NULL);
	}
	if ((kstrcmp(tmp_desc," ")) == 0) line_info->description = NULL;
	else 
	{ 
	    if (line_info->description != NULL) kfree (line_info->description);
	    line_info->description = kstring_copy(tmp_desc, NULL);
	}
	if ((kstrcmp(tmp_var,"")) == 0) 
        {
	    mesg = kvf_create_mesg("kvf_oldparse_workspace_line", line,
		         	"'variable' field MUST be specified", 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
        }
	else 
	{ 
	    if (line_info->variable != NULL) kfree (line_info->variable);
	    line_info->variable = kstring_copy(tmp_var, NULL);
	}

	if (!(kvf_check_pos(line_info->xpos, line_info->width)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_workspace_line", line, 
		  		"X position is greater than width", 2);
	    status = kprompt(KSTANDARD, "Cont", "Stop", 0, mesg); kfree(mesg);
            if (status == 0) return(FALSE);
        }

	if (!(kvf_check_pos(line_info->ypos, line_info->height)))
	{
	    mesg = kvf_create_mesg("kvf_oldparse_workspace_line", line, 
		  		"Y position is greater than height", 2);
	    status = kprompt(KSTANDARD, "Cont", "Stop", 0, mesg); kfree(mesg);
            if (status == 0) return(FALSE);
        }

	line_info->typeflag = KUIS_WORKSPACE;
	return(TRUE);
}

/************************************************************
*
*      Routine: kvf_oldparse_end_line(line, &line_info);
*
*      Purpose: Parses an End line  (-E:  typeflag = End)
*
*        Input: line - the line from the database description
*
*       Output: the appropriate line_info fields filled out accordingly
*
*   Written By: Danielle Argiro 
*
*
*************************************************************/

int kvf_oldparse_end_line(
   char      *line,
   Line_Info *line_info)
{
	char flag, *mesg;
	int status;

        status = sscanf(line, "-%c", &flag);
	if (status < 1) 
	{
	    mesg = kvf_create_readerror_mesg("kvf_oldparse_end_line",
					 line, status, 1);
	    kerror("kforms", NULL, mesg); kfree(mesg);
	    return(FALSE);
	}

	if (flag != 'E') return(FALSE);
	
	line_info->typeflag = KUIS_END;

	return(TRUE);
}


/************************************************************
*
*  Routine Name: kvf_gen_oldparse
*
*      Purpose:  parses an unknown type of line -
*                returns the Line_Info structure and the type
*                of line in question.
*
*        Input:  line - the line from the database
*
*       Output:  line_info structure and type flag
*
*    Called By:  misc. routines
*
*   Written By:  Danielle Argiro & Stephanie Hallett
*
*
*************************************************************/

int kvf_gen_oldparse(
   char      *line,
   Line_Info *line_info)
{
        int     typeflag, status;

        typeflag = kvf_get_line_type(line);
        kvf_clear_line_info(line_info);

        switch (typeflag) {
                case KUIS_STARTFORM:
                        status = kvf_oldparse_startform_line(line, line_info);
                        break;

                case KUIS_STARTMASTER:
                        status = kvf_oldparse_startmaster_line(line, line_info);
                        break;


                case KUIS_STARTSUBMENU:
                        status = kvf_oldparse_startsubmenu_line(line, line_info);
                        break;

                case KUIS_PSEUDOSUBFORM:
                        status = kvf_oldparse_psuedosubform_line(line, line_info);
                        break;

                case KUIS_STARTSUBFORM:
                        status = kvf_oldparse_startsubform_line(line, line_info);
                        break;

                case KUIS_STARTPANE:
                        status = kvf_oldparse_startpane_line(line, line_info);
                        break;

                case KUIS_STARTGUIDE:
                        status = kvf_oldparse_startguide_line(line, line_info);
                        break;

                case KUIS_GUIDEBUTTON:
                        status = kvf_oldparse_guide_line(line, line_info);
                        break;

                case KUIS_MASTERACTION:
                        status = kvf_oldparse_master_action_line(line, line_info);
                        break;

                case KUIS_SUBFORMBUTTON:
                        status = kvf_oldparse_subformbutton_line(line, line_info);
                        break;

                case KUIS_QUIT:
                        status = kvf_oldparse_quit_line(line, line_info);
                        break;

                case KUIS_SUBFORMACTION:
                        status = kvf_oldparse_subform_action_line(line, line_info);
                        break;

                case KUIS_INPUTFILE:
                        status = kvf_oldparse_input_line(line, line_info);
                        break;

                case KUIS_OUTPUTFILE:
                        status = kvf_oldparse_output_line(line, line_info);
                        break;

                case KUIS_INTEGER:
                        status = kvf_oldparse_int_line(line, line_info);
                        break;

                case KUIS_FLOAT:
                        status = kvf_oldparse_float_line(line, line_info);
                        break;

                case KUIS_STRING:
                        status = kvf_oldparse_string_line(line, line_info);
                        break;

                case KUIS_LOGICAL:
                        status = kvf_oldparse_logic_line(line, line_info);
                        break;

                case KUIS_TOGGLE:
                        status = kvf_oldparse_toggle_line(line, line_info);
                        break;

                case KUIS_ROUTINE:
                        status = kvf_oldparse_routine_line(line, line_info);
                        break;

                case KUIS_HELP:
                        status = kvf_oldparse_help_line(line, line_info);
                        break;

                case KUIS_BLANK:
                        status = kvf_oldparse_blank_line(line, line_info);
                        break;

                case KUIS_PANEACTION:
                        status = kvf_oldparse_pane_action_line(line, line_info);
                        break;

                case KUIS_INCLUDEPANE:
                        status = kvf_oldparse_includepane_line(line, line_info);
                        break;

                case KUIS_INCLUDESUBFORM:
                        status = kvf_oldparse_includesubform_line(line, line_info);
                        break;

                case KUIS_WORKSPACE:
                        status = kvf_oldparse_workspace_line(line, line_info);
                        break;

                case KUIS_MUTEXCL:
                        status = kvf_oldparse_mutexcl_line(line, line_info);
                        break;

                case KUIS_CYCLE:
                        status = kvf_oldparse_cycle_line(line, line_info);
                        break;

                case KUIS_LIST:
                        status = kvf_oldparse_list_line(line, line_info);
                        break;

                case KUIS_END:
                        status = kvf_oldparse_end_line(line, line_info);
                        break;

		case KUIS_STRINGLIST:
                        status = kvf_oldparse_stringlist_line(line, line_info);
			break;

		case KUIS_FLAG:
                        status = kvf_oldparse_flag_line(line, line_info);
			break;
                default:
                        line_info->typeflag = -1;
                        return(FALSE);

                }  /* end switch */

        return(status);
}


/************************************************************
*
*  Routine Name: kvf_create_readerror_mesg & kvf_create_mesg
*
*      Purpose: Creates an appropriate error message for an incorrect
*		database line or warning for suspected problem
*		in the database line
*
*        Input: routine_name - name of the routine that called it
*		line - the database line
*		mesg - the error message
*
*   Written By: Danielle Argiro & Stephanie Hallett
*
*
*************************************************************/


static char *kvf_create_readerror_mesg(
   char *routine_name,
   char *line,
   int  status,
   int  expected)
{
	char *mesg_return; 
	int  length; 
	char errline[KLENGTH], mesg[KLENGTH];

	ksprintf(errline, "     Error in line '%s'", line);
	ksprintf(mesg, "     Only able to read %d out of %d required fields.",
                            status, expected);
	length = kstrlen(errline) + kstrlen(mesg) + 
		 kstrlen(routine_name) + 5;

	mesg_return = (char *) kcalloc (1,length);
	ksprintf(mesg_return,  "%s:\n%s\n%s",routine_name, errline, mesg);
	return (mesg_return);
}


static char *kvf_create_mesg(
   char *routine_name,
   char *line,
   char *mesg,
   int  flag) /* 1 for error, 2 for warning */
{
	char *mesg_return;
        char warnline[KLENGTH];
        int  length;

	if (flag == 1)
	    ksprintf(warnline, "    Error: in line '%s'", line);
        else if (flag == 2)
	    ksprintf(warnline, "    Warning: in line '%s'", line);
	else 
        {
	    kfprintf(kstderr, "Unknown flag passed to kvf_create_mesg\n");
	    return(NULL);
        }
	

	length = kstrlen(warnline) + kstrlen(mesg) + 
		 kstrlen(routine_name) + 5;
	mesg_return = (char *) kcalloc (1,length);
	ksprintf(mesg_return, "%s:\n%s\n%s\n", routine_name, warnline, mesg);
	return(mesg_return);
	
}
