 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for mkproto
   >>>> 
   >>>>    Written By: 
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _mkproto_h_
#define _mkproto_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <migration.h>

/* -include_includes */
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
#define DEBUG(s)  /* */ /*kfprintf(kstderr, s) */

#define ISCSYM(x) ((x) > 0 && (isalnum(x) || (x) == '_'))
#define ABORTED ( (Word *) -1 )
#define MAXPARAM 20             /* max. number of parameters to a function */
#define NEWBUFSIZ (20480*sizeof(char)) /* new buffer size */
/* -include_defines_end */

#define PANEPATH "$MIGRATION/objects/kroutine/mkproto/uis/mkproto.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  put line numbers of declarations as comments (optional logical)
 */
int	 n_logic;	/* put line numbers of declarations as comments LOGIC */
int	 n_flag;  	/* put line numbers of declarations as comments FLAG */

/*
 *  include declarations for static functions (optional logical)
 */
int	 s_logic;	/* include declarations for static functions LOGIC */
int	 s_flag;  	/* include declarations for static functions FLAG */

/*
 *  include variable name in declaration (optional logical)
 */
int	 v_logic;	/* include variable name in declaration LOGIC */
int	 v_flag;  	/* include variable name in declaration FLAG */

/*
 *  include declaration for the PROTO() definition (optional logical)
 */
int	 d_logic;	/* include declaration for the PROTO() definition LOGIC */
int	 d_flag;  	/* include declaration for the PROTO() definition FLAG */

/*
 *  do not make header files readable by non-ANSI compiler (optional logical)
 */
int	 p_logic;	/* do not make header files readable by non-ANSI compiler LOGIC */
int	 p_flag;  	/* do not make header files readable by non-ANSI compiler FLAG */

/*
 *  do file headers (optional logical)
 */
int	 h_logic;	/* do file headers LOGIC */
int	 h_flag;  	/* do file headers FLAG */

} clui_info_struct;

/* -include_typedefs */
typedef struct word {
        struct word *next;
        char   string[1];
} Word;
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
extern int newline_seen;	/* are we at the start of a line */
extern long linenum;		/* line number in current file */
extern int glastc;		/* last char. seen by getsym() */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void mkproto_get_args PROTO((kform *));
void mkproto_usage_additions PROTO((void));
void mkproto_free_args PROTO((int, kaddr));

/* -include_routines */
int	List_len	PROTO((Word *w ));
int	fnextch		PROTO((kfile *f ));
int	foundin		PROTO((Word *w1 , Word *w2 ));
int	nextch		PROTO((kfile *f ));
int	ngetc		PROTO((kfile *f ));
int	getsym		PROTO((char *buf , kfile *f ));
int	skipit		PROTO((char *buf , kfile *f ));
void	addword		PROTO((Word *w , char *s ));
void	emit		PROTO((Word *wlist , Word *plist , long startline ));
void	getdecl		PROTO((kfile *f ));
void	typefixhack	PROTO((Word *w ));
void	word_free	PROTO((Word *w ));
void	Usage		PROTO((void ));
Word	*getparamlist	PROTO((kfile *f ));
Word	*word_alloc	PROTO((char *s ));
Word	*word_append	PROTO((Word *w1 , Word *w2 ));
Word	*typelist	PROTO((Word *p ));
/* -include_routines_end */

#endif
