 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            File Title
   >>>>
   >>>>  Static:
   >>>>             _static_routines()
   >>>>  Private:
   >>>>             private_routines()
   >>>>  Public:
   >>>>             public_routines()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "kdarwin.h"

/*-----------------------------------------------------------
|
|  Routine Name: uis_replace_update - replace a kobject's *.pane file and
|				      run uisupdate on it.
|
|       Purpose: This is a helper routine for kdarwin to update the
|		 kobject's *.pane file with a K1 pane file.  The K1
|		 pane file is then updated with the uisupdate.
|
|         Input: object - program object to update
|		 pane_path - string containing path to K1 pane
|        Output:
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Steven Jorgensen
|          Date: Feb 24, 1994
| Modifications:
|
------------------------------------------------------------*/
int uis_replace_update(
	kobject	object,
	char *pane_path)
{
	char temp[KLENGTH], *obj_pane_path, *obj_name, *tmpname;
	char command[KLENGTH];
	kobject file_object;

	if (kcms_get_attribute(object, KCMS_CMOBJ_ONAME, &obj_name) == FALSE)
	{
		kerror(NULL, "uis_replace_update", "Cannot get object name");
		return(FALSE);
	}
/*
	if (kcms_get_attribute(object, KCMS_CMOBJ_UIS_PANE_PATH, &obj_pane_path)
	    == FALSE)
*/
	if (!kcms_get_attribute(object, KCMS_CMOBJ_UIS_PANE, &file_object) ||
	    file_object == NULL ||
	    !kcms_get_attribute(file_object,KCMS_FOBJ_FULLNAME,&obj_pane_path))
	{
		kerror(NULL, "uis_replace_update",
			"Cannot get path to pane file for object '%s'",
			obj_name);
		return(FALSE);
	}
	if ((tmpname = ktempnam(NULL, "uisupdateXXXX")) == NULL)
        {
                kerror(NULL,"uis_replace_update","Cannot get a temporary name");
		return(FALSE);
        }
	if (kcopyfile(pane_path, obj_pane_path) == -1)
	{
		kerror(NULL, "uis_replace_update",
			"Copy of '%s' to '%s' for object '%s' failed",
			pane_path, obj_pane_path, obj_name);
		kunlink(tmpname);
		kfree(tmpname);
		return(FALSE);
	}
	(void) kfullpath(obj_pane_path, NULL, temp);
	ksprintf(command, "uisupdate -i %s -force > %s 2>&1", temp, tmpname);
	kinfo(KVERBOSE, "Running the command\n'%s'", command);
	if (ksystem(command) != 0)
	{
		kerror(NULL, "uis_replace_update",
			"Call to uisupdate for '%s' failed", obj_pane_path);
		kunlink(tmpname);
		kfree(tmpname);
		return(FALSE);
	}
	kunlink(tmpname);
	kfree(tmpname);
	ksprintf(temp, "%s.old", obj_pane_path);
	kunlink(temp);
	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: uis_cantata_update - update a uis file to fit cantata standards
|
|       Purpose: This routine updates the uis file of an object to
|		 comply with standard format used in all cantata panes.
|
|         Input: object - program object that needs it's *.pane updated
|		 sdesc - short description to put in the pane
|        Output:
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|    Written By: Steven Jorgensen
|          Date: Feb 24, 1994
| Modifications:
|
------------------------------------------------------------*/
int uis_cantata_update(
	kobject object,
	char *sdesc)
{
	kobject toolbox, file_object;
	char *oname, *tbname, *tmpname, *obj_pane_path;
	char tb_lower[KLENGTH], tb_upper[KLENGTH], bin_path[KLENGTH];
	char help_path[KLENGTH], command[KLENGTH];
	char temp[KLENGTH], temp1[KLENGTH];

	if ((tmpname = ktempnam(NULL, "kfixpaneXXXX")) == NULL)
        {
                kerror(NULL,"uis_cantata_update","Cannot get a temporary name");
		return(FALSE);
        }
	if (kcms_get_attribute(object, KCMS_CMOBJ_ONAME, &oname) == FALSE)
	{
		kerror(NULL,"uis_cantata_update", "Cannot get object oname");
		kunlink(tmpname);
		kfree(tmpname);
		return(FALSE);
	}
	if (kcms_get_attribute(object, KCMS_CMOBJ_PARENTOBJ, &toolbox) == FALSE)
	{
		kerror(NULL,"uis_cantata_update",
			"Cannot get toolbox object for program '%s'", oname);
		kunlink(tmpname);
		kfree(tmpname);
		return(FALSE);
	}
/*
	if (kcms_get_attribute(object, KCMS_CMOBJ_UIS_PANE_PATH, &obj_pane_path)
	    == FALSE)
*/
	if (!kcms_get_attribute(object, KCMS_CMOBJ_UIS_PANE, &file_object) ||
	    file_object == NULL ||
	    !kcms_get_attribute(file_object,KCMS_FOBJ_FULLNAME,&obj_pane_path))
	{
		kerror(NULL, "uis_cantata_update",
			"Cannot get path to pane file for object '%s'",
			oname);
		kunlink(tmpname);
		kfree(tmpname);
		return(FALSE);
	}
	if (kcms_get_attribute(toolbox, KCMS_TB_NAME, &tbname) == FALSE)
	{
		kerror(NULL,"uis_cantata_update",
			"Cannot get toolbox name for program '%s'", oname);
		kunlink(tmpname);
		kfree(tmpname);
		return(FALSE);
	}
	kstring_upper(tbname, tb_upper);
	kstring_lower(tbname, tb_lower);
	ksprintf(bin_path, "\\$%sBIN/%s", tb_upper, oname);
	ksprintf(help_path, "\\$%s/objects/kroutine/%s/help", tb_upper, oname);
	kstring_cleanup(sdesc, temp);
	kchar_replace(temp, '\n', ' ', temp1);
	ksprintf(command, "kfixpane -tb %s -oname %s -type kroutine -short-desc \"%s\" -rpath %s %s -help %s", tb_lower, oname, temp1, bin_path, obj_pane_path, help_path);
	kinfo(KVERBOSE, "Running the command\n'%s'", command);
	if (ksystem(command) != 0)
	{
		kerror(NULL, "uis_cantata_update",
			"Call to kfixpane for '%s' failed", obj_pane_path);
		kunlink(tmpname);
		kfree(tmpname);
		return(FALSE);
	}
	kunlink(tmpname);
	kfree(tmpname);
	ksprintf(temp, "%s.bak", obj_pane_path);
	kunlink(temp);
	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: ghost_it - run ghostwriter on the program object
|
|       Purpose: This routine takes a kobject, and closes it, runs
|		 ghostwriter, reopens the ghosted object, and returns
|		 that object to the user.
|
|         Input: object - object to run ghostwriter on
|        Output: 
|       Returns: The open kobject on success, NULL of failure.
|    Written By: Steven Jorgensen
|          Date: Feb 24, 1994
| Modifications:
|
------------------------------------------------------------*/
kobject ghost_it(
	kobject object)
{
	kobject toolbox;
	char oname[KLENGTH], *tbname, *tmpname, *tmp;

	if ((tmpname = ktempnam(NULL, "ghostXXXX")) == NULL)
        {
                kerror(NULL,"ghost_it", "Cannot get a temporary name");
		kcms_close(object);
		return(NULL);
        }
	if (!kcms_get_attribute(object, KCMS_CMOBJ_ONAME, &tmp))
	{
		kerror(NULL,"ghost_it", "Cannot get object oname");
		kunlink(tmpname);
		kfree(tmpname);
		kcms_close(object);
		return(NULL);
	}
	kstring_copy(tmp, oname);
	if (!kcms_get_attribute(object, KCMS_CMOBJ_PARENTOBJ, &toolbox))
	{
		kerror(NULL,"ghost_it",
			"Cannot get toolbox object for program '%s'", oname);
		kunlink(tmpname);
		kfree(tmpname);
		kcms_close(object);
		return(NULL);
	}
	if (!kcms_get_attribute(toolbox, KCMS_TB_NAME, &tbname))
	{
		kerror(NULL,"ghost_it",
			"Cannot get toolbox name for program '%s'", oname);
		kunlink(tmpname);
		kfree(tmpname);
		kcms_close(object);
		return(NULL);
	}

	kcms_set_bit(object, KCMS_CMOBJ_FLAGS, KCMS_BIT_CMOBJ_FORCE);

	/*-- ghostwriter is now a library call --*/
	kinfo(KVERBOSE, "Regenerating command-line code\n");
	kgen_generate_clui(object);

	kunlink(tmpname);
	kfree(tmpname);
	return object;
}

/*-----------------------------------------------------------
|
|  Routine Name: fix_it - run kfix on a file
|
|       Purpose: This routine takes a kobject, and closes it, runs
|		 ghostwriter, reopens the ghosted object, and returns
|		 that object to the user.
|
|         Input: object - object to run ghostwriter on
|        Output: 
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|    Written By: Steven Jorgensen
|          Date: Feb 24, 1994
| Modifications:
|
------------------------------------------------------------*/

int kfix_it(
	char *path)
{
	char fpath[KLENGTH], command[KLENGTH], *tmpname, temp[KLENGTH];

	if (path == NULL)
	{
                kerror(NULL,"kfix_it", "Path passed in is NULL");
		return(FALSE);
	}
	if ((tmpname = ktempnam(NULL, "kfixXXXX")) == NULL)
        {
                kerror(NULL,"kfix_it", "Cannot get a temporary name");
		return(FALSE);
        }
	kfullpath(path, NULL, fpath);
	ksprintf(command, "kfix %s > %s 2>&1", fpath, tmpname);
	kinfo(KVERBOSE, "Running the command\n'%s'", command);
	if (ksystem(command) != 0)
	{
		kerror(NULL, "kfix_it",
			"Call to kfix for '%s' failed", path);
		kunlink(tmpname);
		kfree(tmpname);
		return(FALSE);
	}
	kunlink(tmpname);
	kfree(tmpname);
	ksprintf(temp, "%s.old", fpath);
	kunlink(temp);
	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: protoize_it - run protoize on a file
|
|       Purpose: This routine takes a kobject, and closes it, and runs
|		 protoize. 
|
|         Input: path
|        Output: 
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|    Written By: Steven Jorgensen
|          Date: Feb 24, 1994
| Modifications:
|
------------------------------------------------------------*/

int protoize_it(
	kobject routine,
	kobject library)
{
	kobject toolbox, file_object;
	kfile *file;
	char temp[KLENGTH], temp1[KLENGTH], temp2[KLENGTH];
	char command[KLENGTH], hpath[KLENGTH], protocmd[KLENGTH],proto[KLENGTH];
	char *tmpname, *loname, *roname, *tpath, *tmp, *info, *lpath;
	char *start, *end;
	int status, prototype = TRUE;

	if ((tmpname = ktempnam(NULL, "protoizeXXXX")) == NULL)
        {
                kerror(NULL,"protoize_it", "Cannot get a temporary name");
		return(FALSE);
        }
	if (kcms_get_attribute(routine, KCMS_CMOBJ_ONAME, &roname) == FALSE)
	{
		kerror(NULL,"protoize_it", "Cannot get routine oname");
		kunlink(tmpname);
		kfree(tmpname);
		return(FALSE);
	}
	if (kcms_get_attribute(library, KCMS_CMOBJ_ONAME, &loname) == FALSE)
	{
		kerror(NULL,"protoize_it", "Cannot get library oname");
		kunlink(tmpname);
		kfree(tmpname);
		return(FALSE);
	}
	if (kcms_get_attribute(library, KCMS_CMOBJ_PARENTOBJ,&toolbox) == FALSE)
	{
		kerror(NULL,"protoize_it",
			"Cannot get toolbox object for program '%s'", loname);
		kunlink(tmpname);
		kfree(tmpname);
		return(FALSE);
	}
	if (kcms_get_attribute(toolbox, KCMS_TB_PATH, &tpath) == FALSE)
	{
		kerror(NULL,"protoize_it",
			"Cannot get toolbox path for program '%s'", loname);
		kunlink(tmpname);
		kfree(tmpname);
		return(FALSE);
	}
/*
	if (kcms_get_attribute(routine, KCMS_CMOBJ_GEN_LFILE_PATH, &lpath) ==
		FALSE)
*/
	if (!kcms_get_attribute(routine, KCMS_CMOBJ_GEN_LFILE, &file_object) ||
	    file_object == NULL ||
	    !kcms_get_attribute(file_object,KCMS_FOBJ_FULLNAME,&lpath))
	{
		kerror(NULL,"protoize_it",
			"Cannot get path for 'l%s.c'", loname);
		kunlink(tmpname);
		kfree(tmpname);
		return(FALSE);
	}
	kdirname(lpath, temp1);
	kfullpath(temp1, NULL, temp);
	kgetcwd(temp2, KLENGTH);
	ksprintf(command, "cd %s; mkproto < l%s.c > %s 2>&1; cd %s",
		 temp, roname, tmpname, temp2);
	kinfo(KVERBOSE, "Running the command\n'%s'", command);
	ksystem(command);
/*
 * Get Prototype from the file created by mkproto.
 */
	info = NULL;
	if ((info = kreadfile(tmpname, NULL)) == NULL)
	{
		kunlink(tmpname);
		kwarn(NULL,"protoize_it", "Cannot read prototypes file");
		prototype = FALSE;
	}
	kunlink(tmpname);
	ksprintf(temp, "^.* l%s\\s*PROTO\\(\\(.*$", roname);
	status = KPARSE_OK;
	tmp = NULL;
	if (prototype)
		kparse_string_search(info, temp, KLITERAL, &tmp, &status);
	if (status != KPARSE_OK)
	{
		kwarn(NULL,"protoize_it", "Cannot find prototype for 'l%s.c'",
		      roname);
		prototype = FALSE;
	}
	if (prototype)
		ksprintf(proto, "%s\n", tmp);
	else
		ksprintf(proto, "\0");
	kfree(info);
	kfree(tmp);

/*
 * Update the prototype in the library include file.
 */
	ksprintf(hpath, "%s/include/%s/%s.h", tpath, loname, loname);
	ksprintf(temp,"^int\\s*l%s\\s*PROTO\\(\\(.*$", roname);
	if ((info = kreadfile(hpath, NULL)) == NULL)
	{
		kerror(NULL,"protoize_it", "Cannot read file '%s'", hpath);
		kfree(tmpname);
		return(FALSE);
	}
	start = kparse_string_scan(info, "^", temp, KIGNORE_CASE, NULL, NULL,
				   &status);
	if (status != KPARSE_OK)
	{
		kerror(NULL, "protoize_it",
			"Cannot find prototype for 'l%s.c' #2", loname);
		kfree(info);
		kfree(tmpname);
		return(FALSE);
	}
	tmp = kparse_string_search(info, temp, KIGNORE_CASE, NULL, &status);
	if (status != KPARSE_OK)
	{
		kerror(NULL, "protoize_it", "Cannot find prototype for 'l%s.c'",
			loname);
		kfree(info);
		kfree(start);
		kfree(tmpname);
		return(FALSE);
	}
	end = kstrdup(tmp);
	if ((file = kfoutput(hpath)) == NULL)
	{
		kerror(NULL, "protoize_it", "Cannot open library include file");
		kfree(info);
		kfree(start);
		kfree(end);
		kfree(tmpname);
		return(FALSE);
	}
/*
 * Temporarily remove the prototype from the include file so
 * protoize will work.  protoize fails with a syntax error due to mismatched
 * prototypes.
 */
	kfputs(start, file);
	kfprintf(file, "\n");
	kfputs(end, file);
	kfclose(file);
	kfree(info);
/*
 * See if the protoize command exist on this system.
 */
	kdirname(lpath, temp1);
	kfullpath(temp1, NULL, temp);
	kgetcwd(temp2, KLENGTH);
	ksprintf(command, "cd %s; make -n protoize > %s 2>&1; cd %s",
		 temp, tmpname, temp2);
	kinfo(KVERBOSE, "Running the command\n'%s'", command);
	ksystem(command);
	info = kreadfile(tmpname, NULL);
	kunlink(tmpname);
	kparse_string_search(info, "protoize.*$", KLITERAL, &tmp, &status);
	kfree(info);
	protocmd[0] = '\0';
/*
 * If there if the command protoize exists on the system then preform the
 * protoize on the library file.
 */
	if (status == KPARSE_OK)
	{
		tmp[kstrlen(tmp)-2] = '\0';
		ksprintf(protocmd, "cd %s; %s l%s.c > %s 2>&1; cd %s",
			 temp, tmp, roname, tmpname, temp2);
		kfree(tmp);
		kinfo(KVERBOSE, "Running the command\n'%s'", protocmd);
		ksystem(protocmd);
		kunlink(tmpname);
	}
	else
		kerror(NULL,"protoize_it", "Cannot find protoize command");
	
	file = kfoutput(hpath);
	kfputs(start, file);
	kfprintf(file, "%s", proto);
	kfputs(end, file);
	kfclose(file);
	kfree(start);
	kfree(end);

	ksprintf(temp, "%s.save", lpath);
	if (kaccess(temp, F_OK) != 0)
	{
		tmp = kstrrchr(protocmd, '>');
		if (tmp)
		{
			*tmp = '\0';
			tmp = kstrrchr(protocmd, '>');
			if (tmp)
				*tmp = '\0';
		}
        	kwarn(NULL, NULL, "Protoize of 'l%s.c' failed.  This implies \
that the code still will not compile because of some cases that the automatic \
update routines cannot handle.  You must fix these problems, and re-run \
protoize by hand.  This can be accomplished by cd'ing to the src directory \
for the library that contains 'l%s.c', and typing:\n\n%s\n\nKeep fixing \
problems and reprotoizing until it produces a l%s.c.save file.",
		      roname, roname, protocmd, roname);
		kfree(tmpname);
		return(FALSE);
	}
	kunlink(temp);
	kfree(tmpname);
	return(TRUE);
}
