#! /bin/sh 

echo "running test1.sh for msvd ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb MATRIX -echo path`
dpath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1: diagonal matrix, U part
# ------------------------------------------------------------------------
test_num=1
descr="diagonal matrix, U part"
cat <<EOF > $tmpdir/ascii1.$$
1 0 0 0
0 2 0 0
0 0 4 0
EOF
msvd -i $tmpdir/ascii1.$$ -o1 $tmpdir/outu.$$ -o2 $tmpdir/outs.$$ -o3 $tmpdir/outv.$$
cat <<EOF > $tmpdir/asciiu.$$
     0     0     1
     0     1     0
     1     0     0
EOF
report $test_num "$tmpdir/outu.$$" "$tmpdir/asciiu.$$" "$descr"
/bin/rm $tmpdir/asciiu.$$ $tmpdir/outu.$$
/bin/rm $tmpdir/ascii1.$$

# ------------------------------------------------------------------------
# Test  2: diagonal matrix, S part
# ------------------------------------------------------------------------
test_num=2
descr="diagonal matrix, S part"
cat <<EOF > $tmpdir/asciis.$$
     4     0     0     0
     0     2     0     0
     0     0     1     0
EOF
report $test_num "$tmpdir/outs.$$" "$tmpdir/asciis.$$" "$descr"
/bin/rm $tmpdir/asciis.$$ $tmpdir/outs.$$

# ------------------------------------------------------------------------
# Test  3: diagonal matrix, V part
# ------------------------------------------------------------------------
test_num=3
descr="diagonal matrix, V part"
cat <<EOF > $tmpdir/asciiv.$$
     0     0     1     0
     0     1     0     0
     1     0     0     0
     0     0     0     1
EOF
report $test_num "$tmpdir/outv.$$" "$tmpdir/asciiv.$$" "$descr"
/bin/rm $tmpdir/asciiv.$$ $tmpdir/outv.$$

# ------------------------------------------------------------------------
# Test  4: general non-square matrix, U part
# ------------------------------------------------------------------------
test_num=4
descr="general non-square matrix, U part"
cat <<EOF > $tmpdir/ascii1.$$
1 2 3 4
1 3 6 9
2 2 2 2
EOF
msvd -i $tmpdir/ascii1.$$ -o1 $tmpdir/outu.$$ -o2 $tmpdir/outs.$$ -o3 $tmpdir/outv.$$
cat <<EOF > $tmpdir/asciiu.$$
-0.4204728534  0.2026572954  -0.8843826096  
-0.8659193546  -0.3806656708  0.3244646643  
-0.270898968  0.9022326018  0.3355444552  
EOF
report $test_num "$tmpdir/outu.$$" "$tmpdir/asciiu.$$" "$descr"
/bin/rm $tmpdir/asciiu.$$

# ------------------------------------------------------------------------
# Test  5: general non-square matrix, S part
# ------------------------------------------------------------------------
test_num=5
descr="general non-square matrix, S part"
cat <<EOF > $tmpdir/asciis.$$
 12.981082  0  0  0  
 0  2.111770083  0  0  
 0  0  0.1787096871  0  
EOF
report $test_num "$tmpdir/outs.$$" "$tmpdir/asciis.$$" "$descr"
/bin/rm $tmpdir/asciis.$$

# ------------------------------------------------------------------------
# Test  6: general non-square matrix, V part
# ------------------------------------------------------------------------
test_num=6
descr="general non-square matrix, V part"
cat <<EOF > $tmpdir/asciiv.$$
-0.1408349584  0.770186509  0.6220757638  5.251684358e-16  
-0.3066386689  0.5056340131  -0.6954425245  0.4082482905  
-0.5391486336  0.06082246644  -0.1973644138  -0.8164965809  
-0.7716585982  -0.3839890802  0.3007136968  0.4082482905  
EOF
report $test_num "$tmpdir/outv.$$" "$tmpdir/asciiv.$$" "$descr"
/bin/rm -f $tmpdir/asciiv.$$

# ------------------------------------------------------------------------
# Test  7: general non-square matrix, check for  A = U*S*Vt
# ------------------------------------------------------------------------
test_num=7
descr="general non-square matrix, check for  A = U*S*Vt"
mtranspose -i $tmpdir/outv.$$ -o $tmpdir/outv.$$
mmul -i1 $tmpdir/outs.$$ -i2 $tmpdir/outv.$$ -o $tmpdir/acc.$$
mmul -i1 $tmpdir/outu.$$ -i2 $tmpdir/acc.$$ -o $tmpdir/a.$$
report $test_num "$tmpdir/a.$$" "$tmpdir/ascii1.$$" "$descr"
/bin/rm $tmpdir/outu.$$ $tmpdir/outs.$$ $tmpdir/outv.$$
/bin/rm $tmpdir/acc.$$ $tmpdir/a.$$ $tmpdir/ascii1.$$

# ------------------------------------------------------------------------
# Test  8: general complex matrix, U part
# ------------------------------------------------------------------------
test_num=8
descr="general complex matrix, U part"
cat <<EOF > $tmpdir/ascii1.$$
(1,0) (2,0) (3,-2)
(1,0) (3,1) (5,0)
(2,0) (2,1) (4,5)
EOF
msvd -i $tmpdir/ascii1.$$ -o1 $tmpdir/outu.$$ -o2 $tmpdir/outs.$$ -o3 $tmpdir/outv.$$
cat <<EOF > $tmpdir/asciiu.$$
(-0.2647015779,  0.3119752152)  ( 0.1376259505,  0.5000406139)  ( 0.7321662349,  0.1659988747)  
(-0.5564387686,  0.2055177633)  ( 0.02738388832,  0.4784538326)  (-0.5398440736, -0.3564249918)  
(-0.6432675492, -0.2587464892)  ( 0.5118473302, -0.4892472233)  ( 0.09402687403,  0.09521305855)  
EOF
report $test_num "$tmpdir/outu.$$" "$tmpdir/asciiu.$$" "$descr"
/bin/rm $tmpdir/asciiu.$$

# ------------------------------------------------------------------------
# Test  9: general complex matrix, S part
# ------------------------------------------------------------------------
test_num=9
descr="general complex matrix, S part"
cat <<EOF > $tmpdir/asciis.$$
( 9.940266413,          0)  (         0,          0)  (         0,          0)  
(         0,          0)  ( 2.230580908,          0)  (         0,          0)  
(         0,          0)  (         0,          0) ( 0.4643408882,          0)
EOF
report $test_num "$tmpdir/outs.$$" "$tmpdir/asciis.$$" "$descr"
/bin/rm $tmpdir/asciis.$$

# ------------------------------------------------------------------------
# Test  10: general complex matrix, V part
# ------------------------------------------------------------------------
test_num=10
descr="general complex matrix, V part"
cat <<EOF > $tmpdir/asciiv.$$
(-0.2120341002,          0)  ( 0.532912523,          0)  ( 0.8191738418,          0)  
(-0.3559746931, -0.1934271155)  ( 0.6143264434, -0.4114251393)  (-0.4917894202,  0.21758564)  
(-0.8115528614, -0.3637189332)  (-0.3806769471,  0.1562743754)  ( 0.03758742041, -0.1958087285)  
EOF
report $test_num "$tmpdir/outv.$$" "$tmpdir/asciiv.$$" "$descr"
/bin/rm $tmpdir/asciiv.$$

# ------------------------------------------------------------------------
# Test  11: general complex matrix, check for  A = U*S*Vt
# ------------------------------------------------------------------------
test_num=11
descr="general complex matrix, check for  A = U*S*Vt"
mtranspose -i $tmpdir/outv.$$ -o $tmpdir/outv.$$
mmul -i1 $tmpdir/outs.$$ -i2 $tmpdir/outv.$$ -o $tmpdir/acc.$$
mmul -i1 $tmpdir/outu.$$ -i2 $tmpdir/acc.$$ -o $tmpdir/a.$$
report $test_num "$tmpdir/a.$$" "$tmpdir/ascii1.$$" "$descr"
/bin/rm $tmpdir/outu.$$ $tmpdir/outs.$$ $tmpdir/outv.$$
/bin/rm $tmpdir/acc.$$ $tmpdir/a.$$ $tmpdir/ascii1.$$

exit $status

