#! /bin/sh -x

echo "running test1.sh for mlse ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb MATRIX -echo path`
dpath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1: real matrix, overdetermined, single RHS
# ------------------------------------------------------------------------
test_num=1
descr="real matrix, overdetermined, single RHS"
cat <<EOF > $tmpdir/a.$$
1 0 0
1 1 1
1 2 4
1 3 9
1 4 16
EOF
cat <<EOF > $tmpdir/b.$$
0
1
2
3
2
EOF
mlse -i1 $tmpdir/a.$$ -i2 $tmpdir/b.$$ -o $tmpdir/x.$$
cat <<EOF > $tmpdir/xres.$$
-0.1714285714
 1.742857143
-0.2857142857
EOF
report $test_num "$tmpdir/xres.$$" "$tmpdir/x.$$" "$descr"
/bin/rm $tmpdir/a.$$ $tmpdir/b.$$ $tmpdir/x.$$ $tmpdir/xres.$$

# ------------------------------------------------------------------------
# Test  2: real matrix, overdetermined, multiple RHS
# ------------------------------------------------------------------------
test_num=2
descr="real matrix, overdetermined, multiple RHS"
cat <<EOF > $tmpdir/a.$$
1 0 0
1 1 1
1 2 4
1 3 9
1 4 16
EOF
cat <<EOF > $tmpdir/b.$$
0 0 0 
1 1 2 
2 2 4
3 3 6
2 2 4
EOF
mlse -i1 $tmpdir/a.$$ -i2 $tmpdir/b.$$ -o $tmpdir/x.$$
cat <<EOF > $tmpdir/xres.$$
-0.1714285714  -0.1714285714  -0.3428571429  
 1.742857143  1.742857143  3.485714286  
-0.2857142857  -0.2857142857  -0.5714285714  
EOF
report $test_num "$tmpdir/xres.$$" "$tmpdir/x.$$" "$descr"
/bin/rm $tmpdir/a.$$ $tmpdir/b.$$ $tmpdir/x.$$ $tmpdir/xres.$$

# ------------------------------------------------------------------------
# Test  3: real matrix, underdetermined, multiple RHS
# ------------------------------------------------------------------------
test_num=3
descr="real matrix, underdetermined, multiple RHS"
cat <<EOF > $tmpdir/a.$$
1 1 1 1
1 2 4 8
EOF
cat <<EOF > $tmpdir/b.$$
1 1 2 
2 2 4
EOF
mlse -i1 $tmpdir/a.$$ -i2 $tmpdir/b.$$ -o $tmpdir/x.$$
cat <<EOF > $tmpdir/xres.$$
 0.4173913043  0.4173913043  0.8347826087  
 0.3565217391  0.3565217391  0.7130434783  
 0.2347826087  0.2347826087  0.4695652174  
-0.008695652174  -0.008695652174  -0.01739130435  
EOF
report $test_num "$tmpdir/xres.$$" "$tmpdir/x.$$" "$descr"
/bin/rm $tmpdir/a.$$ $tmpdir/b.$$ $tmpdir/x.$$ $tmpdir/xres.$$

exit $status

