#! /bin/sh

echo "running test1.sh for mgdiag ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb MATRIX -echo path`
dpath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1: diagonal matrix, single precision real, non-square, constant
# ------------------------------------------------------------------------
test_num=1
descr="diagonal matrix, single precision real, non-square, constant"
mgdiag -r 3 -c 5 -cr 5 -o $tmpdir/out.$$ -type 1
cat <<EOF > $tmpdir/ascii.$$
5 0 0 0 0 
0 5 0 0 0
0 0 5 0 0
EOF
kconvert -i $tmpdir/ascii.$$ -o $tmpdir/ascii.$$ -type 10 -val
report $test_num "$tmpdir/out.$$" "$tmpdir/ascii.$$" "$descr"
/bin/rm $tmpdir/ascii.$$ $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  2: diagonal matrix, double complex, non-square, constant
# ------------------------------------------------------------------------
test_num=2
descr="diagonal matrix, double complex, non-square, constant"
mgdiag -r 5 -c 3 -cr 5.1 -ci 1.5 -o $tmpdir/out.$$ -type 4
cat <<EOF > $tmpdir/ascii.$$
(5.1,1.5) (0,0) (0,0)
(0,0) (5.1,1.5) (0,0)
(0,0) (0,0) (5.1,1.5)
(0,0) (0,0) (0,0)
(0,0) (0,0) (0,0)
EOF
report $test_num "$tmpdir/out.$$" "$tmpdir/ascii.$$" "$descr"
/bin/rm $tmpdir/ascii.$$ $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  3: diagonal matrix, double complex, square, non-constant
# ------------------------------------------------------------------------
test_num=3
descr="diagonal matrix, double complex, square, non-constant"
cat << EOF > $tmpdir/ascii.$$
(1.1,2.2) (3.3,4.4) (5.5,6.6)
EOF
mgdiag -r 3 -c 3 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -type 4
cat <<EOF > $tmpdir/ascii.$$
(1.1,2.2) (0,0) (0,0)
(0,0) (3.3,4.4) (0,0)
(0,0) (0,0) (5.5,6.6)
EOF
report $test_num "$tmpdir/out.$$" "$tmpdir/ascii.$$" "$descr"
/bin/rm $tmpdir/ascii.$$ $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  4: diagonal matrix, single precision real, non-square, constant (mgident)
# ------------------------------------------------------------------------
test_num=4
descr="diagonal matrix, single precision real, non-square, constant (mgident)"
mgident -r 3 -c 5 -o $tmpdir/out.$$
cat <<EOF > $tmpdir/ascii.$$
1 0 0 0 0
0 1 0 0 0
0 0 1 0 0
EOF
kconvert -i $tmpdir/ascii.$$ -o $tmpdir/ascii.$$ -type 11 -val
report $test_num "$tmpdir/out.$$" "$tmpdir/ascii.$$" "$descr"
/bin/rm $tmpdir/ascii.$$ $tmpdir/out.$$

exit $status

