 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for mlse
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "mlse.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Least Squares Solution to System of Linear Equations
|
|       Purpose: main program for mlse
|
|         Input:
|		char *clui_info->i1_file; {A matrix}
|		int   clui_info->i1_flag; {TRUE if -i1 specified}
|
|		char *clui_info->i2_file; {b vector (or B matrix)}
|		int   clui_info->i2_flag; {TRUE if -i2 specified}
|
|		char *clui_info->o_file; {solution vector (or matrix)}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|        Output:
|       Returns:
|
|    Written By: Scott Wilson
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
kobject sys_obj = NULL;
kobject b_obj = NULL;
kobject sol_obj = NULL;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "MATRIX");
	kexit_handler(mlse_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "MATRIX", "mlse",
		mlse_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	mlse_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        if ((sys_obj = kpds_open_input_object(clui_info->i1_file))
                == KOBJECT_INVALID)
        {
           kerror("mlse","main", "Cannot open input object.");
           kexit(KEXIT_FAILURE);
        }
        if ((b_obj = kpds_open_input_object(clui_info->i2_file))
                == KOBJECT_INVALID)
        {
           kerror("mlse","main", "Cannot open input object.");
           kexit(KEXIT_FAILURE);
        }

        if ((sol_obj = kpds_open_output_object(clui_info->o_file))
                == KOBJECT_INVALID)
          {
            kerror("mlse","main", "Cannot open output object.");
            kexit(KEXIT_FAILURE);
          }
        if (!kpds_copy_object_attr(sys_obj, sol_obj))
          {
            kerror("mlse","main",
              "Unable to copy attributes from input to output object.");
            kexit(KEXIT_FAILURE);
          }
/* -main_before_lib_call_end */

/* -main_library_call */
        if (!lmlse(sys_obj,b_obj,sol_obj)) kexit(KEXIT_FAILURE);
/* -main_library_call_end */

/* -main_after_lib_call */
        /* add history to the output objects and write */
        if (!kpds_set_attribute(sol_obj,KPDS_HISTORY,kpds_history_string()))
          {
            kerror("mlse", "main","Unable to set history on output object");
            kexit(KEXIT_FAILURE);
          }
        kpds_close_object(sol_obj);
        kpds_close_object(sys_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: mlse_usage_additions
| 
|       Purpose: Prints usage additions in mlse_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname mlse
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void mlse_usage_additions(void)
{
	kfprintf(kstderr, "\tLeast Squares Solution to System of Linear Equations\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: mlse_free_args
| 
|       Purpose: Frees CLUI struct allocated in mlse_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname mlse
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
mlse_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i1_file);
	kfree(clui_info->i2_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
