 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for mgdiag
   >>>> 
   >>>>    Written By: Scott Wilson
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _mgdiag_h_
#define _mgdiag_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <matrix.h>

/* -include_includes */
#include <kmatrix/kmatrix.h>
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$MATRIX/objects/kroutine/mgdiag/uis/mgdiag.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Output data type (Required cycle)
 */
int	 type_cycle;	/* Output data type CYCLE INDEX */
char	 *type_label;	/* Output data type CYCLE LABEL */
int	 type_flag;	/* Output data type FLAG */

/*
 *  Resulting output data object (required outfile)
 */
char	*o_file;	/* Resulting output data object FILENAME */
int	 o_flag;	/* Resulting output data object FLAG */

/*
 *  Real part of constant diagonal value (optional double)
 */
double	 cr_double;	/* Real part of constant diagonal value DOUBLE */
int	 cr_flag;   	/* Real part of constant diagonal value FLAG */

/*
 *  Imaginary part of constant diagonal value (optional double)
 */
double	 ci_double;	/* Imaginary part of constant diagonal value DOUBLE */
int	 ci_flag;   	/* Imaginary part of constant diagonal value FLAG */

/*
 *  Vector of diagonal elements (optional infile)
 */
char	*i_file;	/* Vector of diagonal elements FILENAME */
int	 i_flag;	/* Vector of diagonal elements FLAG */

/*----- optional MI group ----*/
/*
 *  Number of rows (optional integer)
 */
int	 r_int; 	/* Number of rows INT */
int	 r_flag;	/* Number of rows FLAG */

/*
 *  Number of columns (optional integer)
 */
int	 c_int; 	/* Number of columns INT */
int	 c_flag;	/* Number of columns FLAG */

/*-- optional MI group end ---*/

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void mgdiag_get_args PROTO((kform *));
void mgdiag_usage_additions PROTO((void));
void mgdiag_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
