 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Library Routine for itexture
   >>>> 
   >>>>  Private: 
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 	litexture
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"

/* -library_includes */
/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                           <<<<
   >>>>                                                           <<<<
   >>>>      contains: This include file specifies all of the LAW <<<<
   >>>>                microtexture masks.  The masks are derived <<<<
   >>>>                from the 5 center-weighted vectors spec-   <<<<
   >>>>                ified by K. I. Laws (Proc. SPIE vol. 238,  <<<<
   >>>>                1980).  The 5 center-weighted vectors are: <<<<
   >>>>                                                           <<<<
   >>>>                 L5 = [ 1  4  6  4  1]                     <<<<
   >>>>                 E5 = [-1 -2  0  2  1]                     <<<<
   >>>>                 S5 = [-1  0  2  0 -1]                     <<<<
   >>>>                 W5 = [-1  2  0 -2  1]                     <<<<
   >>>>                 R5 = [ 1 -4  6 -4  1]                     <<<<
   >>>>                                                           <<<<
   >>>>      written by:  Charlie Gage, Tom Sauer                 <<<<
   >>>>                                                           <<<<
   >>>>      date: 5/22/90                                        <<<<
   >>>>                                                           <<<<
   >>>>      modifications:                                       <<<<
   >>>>                                                           <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

typedef int texture_mask[25];
 
texture_mask L5L5_m = { 1,   4,   6,   4,   1,
                        4,  16,  24,  16,   4,
                        6,  24,  36,  24,   6,
                        4,  16,  24,  16,   4,
                        1,   4,   6,   4,   1 };
 
texture_mask L5E5_m = {-1,  -2,   0,   2,   1,
                       -4,  -8,   0,   8,   4,
                       -6, -12,   0,  12,   6,
                       -4,  -8,   0,   8,   4,
                       -1,  -2,   0,   2,   1 };
 
texture_mask L5S5_m = {-1,   0,   2,   0,  -1,
                       -4,   0,   8,   0,  -4,
                       -6,   0,  12,   0,  -6,
                       -4,   0,   8,   0,  -4,
                       -1,   0,   2,   0,  -1 };
 
texture_mask L5W5_m = {-1,   2,   0,  -2,   1,
                       -4,   8,   0,  -8,   4,
                       -6,  12,   0, -12,   6,
                       -4,   8,   0,  -8,   4,
                       -1,   2,   0,  -2,   1 };
 
texture_mask L5R5_m = { 1,  -4,   6,  -4,   1,
                        4, -16,  24, -16,   4,
                        6, -24,  36, -24,   6,
                        4, -16,  24, -16,   4,
                        1,  -4,   6,  -4,   1 };
 
texture_mask E5L5_m = {-1,  -4,  -6,  -4,  -1,
                       -2,  -8, -12,  -8,  -2,
                        0,   0,   0,   0,   0,
                        2,   8,  12,   8,   2,
                        1,   4,   6,   4,   1 };
 
texture_mask E5E5_m = { 1,   2,   0,  -2,  -1,
                        2,   4,   0,  -4,  -2,
                        0,   0,   0,   0,   0,
                       -2,  -4,   0,   4,   2,
                       -1,  -2,   0,   2,   1 };
 
texture_mask E5S5_m = { 1,   0,  -2,   0,   1,
                        2,   0,  -4,   0,   2,
                        0,   0,   0,   0,   0,
                       -2,   0,   4,   0,  -2,
                       -1,   0,   2,   0,  -1 };
 
texture_mask E5W5_m = { 1,  -2,   0,   2,  -1,
                        2,  -4,   0,   4,  -2,
                        0,   0,   0,   0,   0,
                       -2,   4,   0,  -4,   2,
                       -1,   2,   0,  -2,   1 };
 
texture_mask E5R5_m = {-1,   4,  -6,   4,  -1,
                       -2,   8, -12,   8,  -2,
                        0,   0,   0,   0,   0,
                        2,  -8,  12,  -8,   2,
                        1,  -4,   6,  -4,   1 };
 
texture_mask S5L5_m = {-1,  -4,  -6,  -4,  -1,
                        0,   0,   0,   0,   0,
                        2,   8,  12,   8,   2,
                        0,   0,   0,   0,   0,
                       -1,  -4,  -6,  -4,  -1 };
 
texture_mask S5E5_m = { 1,   2,   0,  -2,  -1,
                        0,   0,   0,   0,   0,
                       -2,  -4,   0,   4,   2,
                        0,   0,   0,   0,   0,
                        1,   2,   0,  -2,  -1 };
 
texture_mask S5S5_m = { 1,   0,  -2,   0,   1,
                        0,   0,   0,   0,   0,
                       -2,   0,   4,   0,  -2,
                        0,   0,   0,   0,   0,
                        1,   0,  -2,   0,   1 };
 
texture_mask S5W5_m = { 1,  -2,   0,   2,  -1,
                        0,   0,   0,   0,   0,
                       -2,   4,   0,  -4,   2,
                        0,   0,   0,   0,   0,
                        1,  -2,   0,   2,  -1 };
 
texture_mask S5R5_m = {-1,   4,  -6,   4,  -1,
                        0,   0,   0,   0,   0,
                        2,  -8,  12,  -8,   2,
                        0,   0,   0,   0,   0,
                       -1,   4,  -6,   4,  -1 };
 
texture_mask W5L5_m = {-1,  -4,  -6,  -4,  -1,
                        2,   8,  12,   8,   2,
                        0,   0,   0,   0,   0,
                       -2,  -8, -12,  -8,  -2,
                        1,   4,   6,   4,   1 };
 
texture_mask W5E5_m = { 1,   2,   0,  -2,  -1,
                       -2,  -4,   0,   4,   2,
                        0,   0,   0,   0,   0,
                        2,   4,   0,  -4,  -2,
                       -1,  -2,   0,   2,   1 };
 
texture_mask W5S5_m = { 1,   0,  -2,   0,   1,
                       -2,   0,   4,   0,  -2,
                        0,   0,   0,   0,   0,
                        2,   0,  -4,   0,   2,
                       -1,   0,   2,   0,  -1 };
 
texture_mask W5W5_m = { 1,  -2,   0,   2,  -1,
                       -2,   4,   0,  -4,   2,
                        0,   0,   0,   0,   0,
                        2,  -4,   0,   4,  -2,
                       -1,   2,   0,  -2,   1 };
 
texture_mask W5R5_m = {-1,   4,  -6,   4,  -1,
                        2,  -8,  12,  -8,   2,
                        0,   0,   0,   0,   0,
                       -2,   8, -12,   8,  -2,
                        1,  -4,   6,  -4,   1 };
 
texture_mask R5L5_m = { 1,   4,   6,   4,   1,
                       -4, -16, -24, -16,  -4,
                        6,  24,  36,  24,   6,
                       -4, -16, -24, -16,  -4,
                        1,   4,   6,   4,   1 };
 
texture_mask R5E5_m = {-1,  -2,   0,   2,   1,
                        4,   8,   0,  -8,  -4,
                       -6, -12,   0,  12,   6,
                        4,   8,   0,  -8,  -4,
                       -1,  -2,   0,   2,   1 };
 
texture_mask R5S5_m = {-1,   0,   2,   0,  -1,
                        4,   0,  -8,   0,   4,
                       -6,   0,  12,   0,  -6,
                        4,   0,  -8,   0,   4,
                       -1,   0,   2,   0,  -1 };
 
texture_mask R5W5_m = {-1,   2,   0,  -2,   1,
                        4,  -8,   0,   8,  -4,
                       -6,  12,   0, -12,   6,
                        4,  -8,   0,   8,  -4,
                       -1,   2,   0,  -2,   1 };
 
texture_mask R5R5_m = { 1,  -4,   6,  -4,   1,
                       -4,  16, -24,  16,  -4,
                        6, -24,  36, -24,   6,
                       -4,  16, -24,  16,  -4,
                        1,  -4,   6,  -4,   1 };
/* -library_includes_end */


/****************************************************************
* 
*  Routine Name: litexture - texture feature extraction using LAW metrics
* 
*       Purpose: lktexture will extract texture features from an image by
*                convolving the original image with a spatial filter.  The
*                spatial filters are comprised of 5 x 5 kernals derived from
*                center-weighted vectors defined by the LAWS texture measure.
*
*                The five center-weighted vectors are:
*
*                !         L5 = [ 1  4  6  4  1]
*                !         E5 = [-1 -2  0  2  1]
*                !         S5 = [-1  0  2  0 -1]
*                !         W5 = [-1  2  0 -2  1]
*                !         R5 = [ 1 -4  6 -4  1]
*
*               Each 5 x 5 kernal is derived from multiplying a particular
*               combination of two of the above vectors.  This results in 25
*               possible 5 x 5 kernals.
*
*               If the input object elements dimension is greater than 1 then 
*               the results obtained by applying all texture kernels to the 
*               first band are stored by planes in the output object, followed 
*               by the results obtained by applying all texture kernels to the 
*               second band, etc.
*
*               lklinearop() is called to convolve the input image with the 
*		selected kernels.  The result are stored as a WxH planes along
*		the E direction in the output object.
*
*         Input: image - input object
*        Output: image - the output object.
*       Returns: TRUE (1) on success, FALSE (0) on failure
*  Restrictions: lktexture will operate on input objects of any data storage 
*		 type.
*
*                The output object will be of type KLONG, KDOUBLE, or
*                KDCOMPLEX, determined by the data type of the input object.
*                If the input object is of data type KBYTE, KUBYTE, KSHORT, or 
*                KUSHORT, then it is converted up to an KLONG image. If the 
*                input is of type KFLOAT or KDOUBLE, then the result will be 
*                KDOUBLE.
*                Any complex input type is converted to type KDCOMPLEX.
*    Written By: Scott Wilson (stolen from K2.0.1 RETRO toolbox)
*          Date: Apr 11, 1995
*      Verified: 
*  Side Effects: 
* Modifications: 
****************************************************************/
/* -library_def */
int litexture(
        kobject in_obj,
        int L5L5,
        int L5E5,
        int L5S5,
        int L5W5,
        int L5R5,
        int E5L5,
        int E5E5,
        int E5S5,
        int E5W5,
        int E5R5,
        int S5L5,
        int S5E5,
        int S5S5,
        int S5W5,
        int S5R5,
        int W5L5,
        int W5E5,
        int W5S5,
        int W5W5,
        int W5R5,
        int R5L5,
        int R5E5,
        int R5S5,
        int R5W5,
        int R5R5,
        kobject out_obj)
/* -library_def_end */

/* -library_code */
{
        char *lib = "kdatamanip", *rtn = "lktexture";
        klist *objlist=NULL;
        int itype,otype;
        int map_exists,mask_exists;
        unsigned int w,h,d,t,e; /* Dimensions of input data set */
	unsigned int flag[25];
        int nb,i;
        kobject kernel,result,temp;
        long dim_list[2];
        int sub_pos[5], sub_size[5];
        kobject obar[2];

	/* Make sure we have valid objects */
        if (in_obj == KOBJECT_INVALID || out_obj == KOBJECT_INVALID)
          {
            kerror(lib, rtn, "Bogus input or output object");
            return(FALSE);
          }

        /* See if the data type of the input object is real or complex */
        KCALL(kpds_get_attribute(in_obj,KPDS_VALUE_DATA_TYPE,&itype));
        if (itype == KCOMPLEX || itype == KDCOMPLEX)
          {
            kerror(lib,rtn, "Can't handle complex data types (yet).");
            return(FALSE);
          }

        /* Reference the input object to avoid side effects, then add the
           reference to the list of goodies to be autmatically free'd on
           error. */
        KCALL((in_obj = kpds_reference_object(in_obj)));
        objlist = klist_add(objlist,in_obj,"KOBJECT");
 
        mask_exists=kpds_query_mask(in_obj);
        map_exists=kpds_query_map(in_obj);
 
        /* If map exists, push all the data thru the map */
        if (map_exists)
          {
            KCALL(kpds_set_attribute(in_obj,KPDS_MAPPING_MODE,KMAPPED));
          }

        /* Create the output value segment if it's not there already and
           copy it's size and data type attributes from the input obj.  */
        KCALL(kpds_copy_object_attr(in_obj,out_obj));

        /* Fix up the data type for presentation */
        if ( itype == KBYTE || itype == KUBYTE ||
             itype == KSHORT || itype == KUSHORT ||
             itype == KINT || itype == KUINT ||
             itype == KLONG || itype == KULONG)
             otype = KLONG;
        else if (itype == KFLOAT || itype == KDOUBLE) otype = KDOUBLE;
        else otype = KDCOMPLEX;
        KCALL(kpds_set_attribute(in_obj,KPDS_VALUE_DATA_TYPE,otype));
        KCALL(kpds_set_attribute(out_obj,KPDS_VALUE_DATA_TYPE,otype));
 
        /* See how big the data is */
        KCALL(kpds_get_attribute(in_obj,KPDS_VALUE_SIZE,&w,&h,&d,&t,&e));

	/* zero out flags */
	(void) kmemset((kaddr) flag, 0, (unsigned) 25 * sizeof(unsigned int));
	nb = 0;

        /* Determine number of output bands and which bands are requested */
        if (L5L5 == 1) { nb++; flag[0] = 1; }   /* set flag for mask L5L5 */
        if (L5E5 == 1) { nb++; flag[1] = 1; }   /* set flag for mask L5E5 */
        if (L5S5 == 1) { nb++; flag[2] = 1; }   /* set flag for mask L5S5 */
        if (L5W5 == 1) { nb++; flag[3] = 1; }   /* set flag for mask L5W5 */
        if (L5R5 == 1) { nb++; flag[4] = 1; }   /* set flag for mask L5R5 */
        if (E5L5 == 1) { nb++; flag[5] = 1; }   /* set flag for mask E5L5 */
        if (E5E5 == 1) { nb++; flag[6] = 1; }   /* set flag for mask E5E5 */
        if (E5S5 == 1) { nb++; flag[7] = 1; }   /* set flag for mask E5S5 */
        if (E5W5 == 1) { nb++; flag[8] = 1; }   /* set flag for mask E5W5 */
        if (E5R5 == 1) { nb++; flag[9] = 1; }   /* set flag for mask E5R5 */
        if (S5L5 == 1) { nb++; flag[10] = 1; }  /* set flag for mask S5L5 */
        if (S5E5 == 1) { nb++; flag[11] = 1; }  /* set flag for mask S5E5 */
        if (S5S5 == 1) { nb++; flag[12] = 1; }  /* set flag for mask S5S5 */
        if (S5W5 == 1) { nb++; flag[13] = 1; }  /* set flag for mask S5W5 */
        if (S5R5 == 1) { nb++; flag[14] = 1; }  /* set flag for mask S5R5 */
        if (W5L5 == 1) { nb++; flag[15] = 1; }  /* set flag for mask W5L5 */
        if (W5E5 == 1) { nb++; flag[16] = 1; }  /* set flag for mask W5E5 */
        if (W5S5 == 1) { nb++; flag[17] = 1; }  /* set flag for mask W5S5 */
        if (W5W5 == 1) { nb++; flag[18] = 1; }  /* set flag for mask W5W5 */
        if (W5R5 == 1) { nb++; flag[19] = 1; }  /* set flag for mask W5R5 */
        if (R5L5 == 1) { nb++; flag[20] = 1; }  /* set flag for mask R5L5 */
        if (R5E5 == 1) { nb++; flag[21] = 1; }  /* set flag for mask R5E5 */
        if (R5S5 == 1) { nb++; flag[22] = 1; }  /* set flag for mask R5S5 */
        if (R5W5 == 1) { nb++; flag[23] = 1; }  /* set flag for mask R5W5 */
        if (R5R5 == 1) { nb++; flag[24] = 1; }  /* set flag for mask R5R5 */

        /* Set up the kernel object */
	KCALL(kernel = kpds_create_object());
        objlist = klist_add(objlist,kernel,"KOBJECT");
	KCALL(kpds_create_value(kernel));
        KCALL(kpds_set_attribute(kernel,KPDS_VALUE_SIZE,5,5,1,1,1));
        KCALL(kpds_set_attribute(kernel,KPDS_VALUE_DATA_TYPE,KINT));

        /* Set up the result object */
	KCALL(result = kpds_create_object());
        objlist = klist_add(objlist,result,"KOBJECT");
        KCALL(kpds_copy_object_attr(out_obj,result));

        /* Set up the temp object */
	KCALL(temp = kpds_create_object());
        objlist = klist_add(objlist,temp,"KOBJECT");
        KCALL(kpds_copy_object_attr(out_obj,temp));

        /* Get rid of any value segement hanging on the output object, so
           that we start with a clean slate there */
        KCALL(kpds_destroy_value(out_obj));

        /* Step thru each of the kernels, convolving it with the input
           data and storing the result in the output object */
	for (i = 0; i < 25; i++)
	  {
            /* load the kernel with data from the appropriate texture mask */
            if (flag[i])
              {
                kinfo(KVERBOSE,"Found a kernel for flag %d\n...",i);
                switch(i)
                  {
                    case 0:
                      KCALL(kpds_put_data(kernel,KPDS_VALUE_PLANE,(kaddr)L5L5_m));
                      break;
                    case 1:
                      KCALL(kpds_put_data(kernel,KPDS_VALUE_PLANE,(kaddr)L5E5_m));
                      break;
                    case 2:
                      KCALL(kpds_put_data(kernel,KPDS_VALUE_PLANE,(kaddr)L5S5_m));
                      break;
                    case 3:
                      KCALL(kpds_put_data(kernel,KPDS_VALUE_PLANE,(kaddr)L5W5_m));
                      break;
                    case 4:
                      KCALL(kpds_put_data(kernel,KPDS_VALUE_PLANE,(kaddr)L5R5_m));
                      break;
                    case 5:
                      KCALL(kpds_put_data(kernel,KPDS_VALUE_PLANE,(kaddr)E5L5_m));
                      break;
                    case 6:
                      KCALL(kpds_put_data(kernel,KPDS_VALUE_PLANE,(kaddr)E5E5_m));
                      break;
                    case 7:
                      KCALL(kpds_put_data(kernel,KPDS_VALUE_PLANE,(kaddr)E5S5_m));
                      break;
                    case 8:
                      KCALL(kpds_put_data(kernel,KPDS_VALUE_PLANE,(kaddr)E5W5_m));
                      break;
                    case 9:
                      KCALL(kpds_put_data(kernel,KPDS_VALUE_PLANE,(kaddr)E5R5_m));
                      break;
                    case 10:
                      KCALL(kpds_put_data(kernel,KPDS_VALUE_PLANE,(kaddr)S5L5_m));
                      break;
                    case 11:
                      KCALL(kpds_put_data(kernel,KPDS_VALUE_PLANE,(kaddr)S5E5_m));
                      break;
                    case 12:
                      KCALL(kpds_put_data(kernel,KPDS_VALUE_PLANE,(kaddr)S5S5_m));
                      break;
                    case 13:
                      KCALL(kpds_put_data(kernel,KPDS_VALUE_PLANE,(kaddr)S5W5_m));
                      break;
                    case 14:
                      KCALL(kpds_put_data(kernel,KPDS_VALUE_PLANE,(kaddr)S5R5_m));
                      break;
                    case 15:
                      KCALL(kpds_put_data(kernel,KPDS_VALUE_PLANE,(kaddr)W5L5_m));
                      break;
                    case 16:
                      KCALL(kpds_put_data(kernel,KPDS_VALUE_PLANE,(kaddr)W5E5_m));
                      break;
                    case 17:
                      KCALL(kpds_put_data(kernel,KPDS_VALUE_PLANE,(kaddr)W5S5_m));
                      break;
                    case 18:
                      KCALL(kpds_put_data(kernel,KPDS_VALUE_PLANE,(kaddr)W5W5_m));
                      break;
                    case 19:
                      KCALL(kpds_put_data(kernel,KPDS_VALUE_PLANE,(kaddr)W5R5_m));
                      break;
                    case 20:
                      KCALL(kpds_put_data(kernel,KPDS_VALUE_PLANE,(kaddr)R5L5_m));
                      break;
                    case 21:
                      KCALL(kpds_put_data(kernel,KPDS_VALUE_PLANE,(kaddr)R5E5_m));
                      break;
                    case 22:
                      KCALL(kpds_put_data(kernel,KPDS_VALUE_PLANE,(kaddr)R5S5_m));
                      break;
                    case 23:
                      KCALL(kpds_put_data(kernel,KPDS_VALUE_PLANE,(kaddr)R5W5_m));
                      break;
                    case 24:
                      KCALL(kpds_put_data(kernel,KPDS_VALUE_PLANE,(kaddr)R5R5_m));
                      break;
                    default:
                      kerror(lib,rtn, "ERROR, unknown kernal type.\n");
                      (void)klist_free(objlist,(kfunc_void)lkcall_free);
                      return(FALSE);
                  }

              KCALL(kpds_set_attribute(in_obj,KPDS_VALUE_POSITION,0,0,0,0,0));
              KCALL(kpds_set_attribute(result,KPDS_VALUE_POSITION,0,0,0,0,0));
              KCALL(kpds_set_attribute(kernel,KPDS_VALUE_POSITION,0,0,0,0,0));
              sub_pos[0] = 0; sub_pos[1] = 0; sub_pos[2] = 0;
              sub_pos[3] = 0; sub_pos[4] = 0;
              sub_size[0] = w; sub_size[1] = h; sub_size[2] = 1;
              sub_size[3] = 1; sub_size[4] = 1;
              dim_list[0] = KWIDTH; dim_list[1] = KHEIGHT;
              KCALL(kpds_destroy_value(result));
              KCALL(lklinearop(in_obj, kernel,
                               0,
                               0.0,0.0,
                               NULL,
                               0,
                               0,
                               2,
                               dim_list,
                               sub_size,
                               sub_pos,
                               0,
                               result));
              obar[0] = out_obj; obar[1] = result;
              KCALL(kapu_append(obar,
                                2,
                                FALSE,FALSE,FALSE,FALSE,TRUE,
                                KAPU_MAP_ALL_DATA,
                                temp));
              KCALL(kpds_copy_object(temp,out_obj));
            }
        } /* End of Laws kernel loop */       

        (void)klist_free(objlist,(kfunc_void)lkcall_free);
	return TRUE;
}
/* -library_code_end */
