 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for irotate
   >>>> 
   >>>>    Written By: Scott Wilson
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _irotate_h_
#define _irotate_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <image.h>

/* -include_includes */
#include <dataserv.h>
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$IMAGE/objects/kroutine/irotate/uis/irotate.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Input data object (required infile)
 */
char	*i_file;	/* Input data object FILENAME */
int	 i_flag;	/* Input data object FLAG */

/*
 *  Output data object (required outfile)
 */
char	*o_file;	/* Output data object FILENAME */
int	 o_flag;	/* Output data object FLAG */

/*----- required ME group ----*/
/*
 *  W coordinate of center of rotation (optional double)
 */
double	 wc_double;	/* W coordinate of center of rotation DOUBLE */
int	 wc_flag;   	/* W coordinate of center of rotation FLAG */

/*
 *  center of rotation in center of W coordinate span (optional flag)
 */
int	 wctr_flag;  	/* center of rotation in center of W coordinate span FLAG */

/*-- required ME group end ---*/

/*----- required ME group ----*/
/*
 *  H coordinate of center of rotation (optional double)
 */
double	 hc_double;	/* H coordinate of center of rotation DOUBLE */
int	 hc_flag;   	/* H coordinate of center of rotation FLAG */

/*
 *  center of rotation in center of H coordinate span (optional flag)
 */
int	 hctr_flag;  	/* center of rotation in center of H coordinate span FLAG */

/*-- required ME group end ---*/

/*
 *  rotation angle (degrees, positive is CW) (optional double)
 */
double	 angle_double;	/* rotation angle (degrees, positive is CW) DOUBLE */
int	 angle_flag;   	/* rotation angle (degrees, positive is CW) FLAG */

/*
 *  resize to fit rotated image (optional flag)
 */
int	 resize_flag;  	/* resize to fit rotated image FLAG */

/*
 *  Process data by full planes instead of small prisms (optional flag)
 */
int	 planes_flag;  	/* Process data by full planes instead of small prisms FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void irotate_get_args PROTO((kform *));
void irotate_usage_additions PROTO((void));
void irotate_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
