 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for ipostscr
   >>>> 
   >>>>    Written By: Mark Young, Scott Wilson, Jeremy Worley
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _ipostscr_h_
#define _ipostscr_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <image.h>

/* -include_includes */
#include <kimage_proc/kimage_proc.h>
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$IMAGE/objects/kroutine/ipostscr/uis/ipostscr.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Object to be output in postscript form (required infile)
 */
char	*i_file;	/* Object to be output in postscript form FILENAME */
int	 i_flag;	/* Object to be output in postscript form FLAG */

/*
 *  output postscript file (required outfile)
 */
char	*f_file;	/* output postscript file FILENAME */
int	 f_flag;	/* output postscript file FLAG */

/*
 *  Desired width in inches of the printed image (optional double)
 */
double	 width_double;	/* Desired width in inches of the printed image DOUBLE */
int	 width_flag;   	/* Desired width in inches of the printed image FLAG */

/*
 *  Desired height of printed image in inches (optional double)
 */
double	 height_double;	/* Desired height of printed image in inches DOUBLE */
int	 height_flag;   	/* Desired height of printed image in inches FLAG */

/*
 *  Width offset in inches from bottom left corner of printed page (optional double)
 */
double	 xoffset_double;	/* Width offset in inches from bottom left corner of printed page DOUBLE */
int	 xoffset_flag;   	/* Width offset in inches from bottom left corner of printed page FLAG */

/*
 *  Height offset in inches from bottom left corner of printed page  (optional double)
 */
double	 yoffset_double;	/* Height offset in inches from bottom left corner of printed page  DOUBLE */
int	 yoffset_flag;   	/* Height offset in inches from bottom left corner of printed page  FLAG */

/*
 *  Issue showpage at end of output (optional flag)
 */
int	 showpage_flag;  	/* Issue showpage at end of output FLAG */

/*----- optional ME group ----*/
/*
 *  Specify that portrait style output is desired. (optional flag)
 */
int	 portrait_flag;  	/* Specify that portrait style output is desired. FLAG */

/*
 *  specifies that landscape output is desired (optional flag)
 */
int	 landscape_flag;  	/* specifies that landscape output is desired FLAG */

/*-- optional ME group end ---*/

/*----- optional ME group ----*/
/*
 *  Specify that regular Postscript output is desired. (optional flag)
 */
int	 ps_flag;  	/* Specify that regular Postscript output is desired. FLAG */

/*
 *  Specify that Encapsulated Postscript is desired. (optional flag)
 */
int	 eps_flag;  	/* Specify that Encapsulated Postscript is desired. FLAG */

/*-- optional ME group end ---*/

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void ipostscr_get_args PROTO((kform *));
void ipostscr_usage_additions PROTO((void));
void ipostscr_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
