 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "igeowarp.h"
/*-----------------------------------------------------------
| 
|  Routine Name: igeowarp_get_args
| 
|       Purpose: Gets command line args for igeowarp
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname igeowarp
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void igeowarp_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for igeowarp is out of sync with arguments specified in igeowarp's *.pane file; please rerun ghostwriter on igeowarp.";


	/*
	 * allocate the igeowarp structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "igeowarp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "planes",
			  &(clui_info->planes_flag))))
	{
	    kerror(NULL, "igeowarp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "igeowarp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "wcoeffs",
			  &(clui_info->wcoeffs_file),
			  &(clui_info->wcoeffs_flag))))
	{
	    kerror(NULL, "igeowarp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "a00",
			  &(clui_info->a00_double),
			  &(clui_info->a00_flag))))
	{
	    kerror(NULL, "igeowarp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "a01",
			  &(clui_info->a01_double),
			  &(clui_info->a01_flag))))
	{
	    kerror(NULL, "igeowarp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "a10",
			  &(clui_info->a10_double),
			  &(clui_info->a10_flag))))
	{
	    kerror(NULL, "igeowarp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "a11",
			  &(clui_info->a11_double),
			  &(clui_info->a11_flag))))
	{
	    kerror(NULL, "igeowarp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "hcoeffs",
			  &(clui_info->hcoeffs_file),
			  &(clui_info->hcoeffs_flag))))
	{
	    kerror(NULL, "igeowarp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "b00",
			  &(clui_info->b00_double),
			  &(clui_info->b00_flag))))
	{
	    kerror(NULL, "igeowarp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "b01",
			  &(clui_info->b01_double),
			  &(clui_info->b01_flag))))
	{
	    kerror(NULL, "igeowarp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "b10",
			  &(clui_info->b10_double),
			  &(clui_info->b10_flag))))
	{
	    kerror(NULL, "igeowarp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "b11",
			  &(clui_info->b11_double),
			  &(clui_info->b11_flag))))
	{
	    kerror(NULL, "igeowarp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



