 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for igauss_func
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "igauss_func.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Generate Gaussian Function Image
|
|       Purpose: main program for igauss_func
|
|         Input:
|		char *clui_info->o_file; {Output file containing Gaussian data}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		Required M.E. group:
|		    M.I. group:
|			int clui_info->wpeak_int; {Width coordinate for peak of 2D Gaussian function}
|			int clui_info->wpeak_flag; {TRUE if -wpeak specified}
|
|			int clui_info->hpeak_int; {Height coordinate for peak of 2D Gaussian function}
|			int clui_info->hpeak_flag; {TRUE if -hpeak specified}
|
|			double clui_info->wvar_double; {Variance of the 2D Gaussian function along width}
|			int    clui_info->wvar_flag; {TRUE if -wvar specified}
|
|			double clui_info->hvar_double; {Variance of the 2D Gaussian function along height}
|			int    clui_info->hvar_flag; {TRUE if -hvar specified}
|
|			double clui_info->coeff_double; {Correlation coefficient for 2D Gaussian function}
|			int    clui_info->coeff_flag; {TRUE if -coeff specified}
|
|			double clui_info->peakval_double; {Peak value of the 2D Gaussian function}
|			int    clui_info->peakval_flag; {TRUE if -peakval specified}
|
|		    M.I. group:
|			char *clui_info->i_file; {Input file of parameters for multiple Gaussian functions}
|			int   clui_info->i_flag; {TRUE if -i specified}
|
|			int clui_info->norm_logic; {Normalize amplitude of the Gaussian function}
|			int clui_info->norm_flag; {TRUE if -norm specified}
|
|		int clui_info->wsize_int; {Width of output image (number of columns)}
|		int clui_info->wsize_flag; {TRUE if -wsize specified}
|
|		int clui_info->hsize_int; {Height of output image (number of rows)}
|		int clui_info->hsize_flag; {TRUE if -hsize specified}
|
|		int   clui_info->type_list; {Data type of 2D Gaussian function data}
|		char *clui_info->type_label;
|		int   clui_info->type_flag; {TRUE if -type specified}
|
|        Output:
|       Returns:
|
|    Written By: Ashish Malhotra
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        kobject out_obj,param_obj = NULL;
        int     type;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "IMAGE");
	kexit_handler(igauss_func_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "IMAGE", "igauss_func",
		igauss_func_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	igauss_func_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        if ((out_obj = kpds_open_output_object(clui_info ->o_file)) 
		== KOBJECT_INVALID)
        {
            kerror("main","igauss_func","Failed to open output object.");
            kexit(KEXIT_FAILURE);
        }

        if ( clui_info ->i_flag &&
            ((param_obj = kpds_open_input_object(clui_info ->i_file)) 
		== KOBJECT_INVALID))
        {
           kerror("main","igauss_func","Failed to open parameter object.");
           kpds_close_object(out_obj);
           kexit(KEXIT_FAILURE);
        }  

        type = kdatatype_to_define(clui_info->type_label); 
/* -main_before_lib_call_end */

/* -main_library_call */
	if (!ligauss_func(param_obj, clui_info->hsize_int, clui_info->wsize_int,
                          clui_info->wpeak_int,clui_info->hpeak_int,
                          clui_info->wvar_double,clui_info->hvar_double,
                          clui_info->coeff_double,clui_info->peakval_double,
                          clui_info->norm_logic,type,out_obj))
        {
           kexit(KEXIT_FAILURE);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
	/* add history to the output object */
	if (!kpds_set_attribute(out_obj, KPDS_HISTORY, kpds_history_string()))
	{
	   kerror("igauss_func", "main", 
		  "Unable to set history on the destination object");
	   kexit(KEXIT_FAILURE);
	}

        kpds_close_object(out_obj);
        if (param_obj) kpds_close_object(param_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: igauss_func_usage_additions
| 
|       Purpose: Prints usage additions in igauss_func_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname igauss_func
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void igauss_func_usage_additions(void)
{
	kfprintf(kstderr, "\tGenerate Gaussian Function Image\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: igauss_func_free_args
| 
|       Purpose: Frees CLUI struct allocated in igauss_func_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname igauss_func
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
igauss_func_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->o_file);
	kfree(clui_info->type_label);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
