 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for igamut
   >>>> 
   >>>>    Written By: Scott Wilson
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _igamut_h_
#define _igamut_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <image.h>

/* -include_includes */
#include <kimage_proc/kimage_proc.h>
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$IMAGE/objects/kroutine/igamut/uis/igamut.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Multiband input image (elements dimension > 1) (required infile)
 */
char	*i_file;	/* Multiband input image (elements dimension > 1) FILENAME */
int	 i_flag;	/* Multiband input image (elements dimension > 1) FLAG */

/*
 *  output file (required outfile)
 */
char	*o_file;	/* output file FILENAME */
int	 o_flag;	/* output file FLAG */

/*
 *  Number of colors to compress down to (optional integer)
 */
int	 n_int; 	/* Number of colors to compress down to INT */
int	 n_flag;	/* Number of colors to compress down to FLAG */

/*
 *  Number of bits of precision to use during quantization (optional integer)
 */
int	 p_int; 	/* Number of bits of precision to use during quantization INT */
int	 p_flag;	/* Number of bits of precision to use during quantization FLAG */

/*
 *  Fraction of color splits based on subspace 2-norm (optional float)
 */
float	 r_float;	/* Fraction of color splits based on subspace 2-norm FLOAT */
int	 r_flag;   	/* Fraction of color splits based on subspace 2-norm FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void igamut_get_args PROTO((kform *));
void igamut_usage_additions PROTO((void));
void igamut_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
