 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for ifilt_design
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "ifilt_design.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - General 2-Dimensional Image Filter Design
|
|       Purpose: main program for ifilt_design
|
|         Input:
|		char *clui_info->o_file; {Output frequency filter image}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		Required M.E. group:
|		    int clui_info->lp_flag; {TRUE if -lp specified}
|
|		    int clui_info->hp_flag; {TRUE if -hp specified}
|
|		    int clui_info->bp_flag; {TRUE if -bp specified}
|
|		    int clui_info->bs_flag; {TRUE if -bs specified}
|
|		Required M.E. group:
|		    int clui_info->ideal_flag; {TRUE if -ideal specified}
|
|		    int clui_info->but_flag; {TRUE if -but specified}
|
|		    int clui_info->exp_flag; {TRUE if -exp specified}
|
|		    int clui_info->ch1_flag; {TRUE if -ch1 specified}
|
|		    int clui_info->ch2_flag; {TRUE if -ch2 specified}
|
|		int   clui_info->pos_cycle; {Low frequencies located at image center or corners}
|		char *clui_info->pos_label;
|		int   clui_info->pos_flag; {TRUE if -pos specified}
|
|		int   clui_info->type_cycle; {Type of frequency image to output}
|		char *clui_info->type_label;
|		int   clui_info->type_flag; {TRUE if -type specified}
|
|		int clui_info->order_int; {Filter order}
|		int clui_info->order_flag; {TRUE if -order specified}
|
|		double clui_info->lcutoff_double; {Normalized lower cutoff frequency}
|		int    clui_info->lcutoff_flag; {TRUE if -lcutoff specified}
|
|		double clui_info->ucutoff_double; {Normalized upper cutoff frequency}
|		int    clui_info->ucutoff_flag; {TRUE if -ucutoff specified}
|
|		int clui_info->hsize_int; {Image height size}
|		int clui_info->hsize_flag; {TRUE if -hsize specified}
|
|		int clui_info->wsize_int; {Image width size}
|		int clui_info->wsize_flag; {TRUE if -wsize specified}
|
|        Output:
|       Returns:
|
|    Written By: Steven Jorgensen
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	kobject fimage = NULL;
	int type = KFILT_LP;
	int brand = KFILT_IDEAL;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "IMAGE");
	kexit_handler(ifilt_design_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "IMAGE", "ifilt_design",
		ifilt_design_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	ifilt_design_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	if (!(fimage = kpds_open_output_object(clui_info->o_file)))
	{
		kerror(NULL, "ifilt_design",
		       "Cannot open output frequency image.");
		kexit(KEXIT_FAILURE);
	}
	if (!kpds_create_value(fimage))
	{
		kerror(NULL, "ifilt_design", "Cannot create value data for file '%s'", clui_info->o_file);
		kexit(KEXIT_FAILURE);
	}
	if (!kpds_set_attributes(fimage, KPDS_VALUE_DATA_TYPE,
				(clui_info->type_cycle == 10 ?
				 KFLOAT : KDOUBLE),
				 KPDS_VALUE_SIZE, clui_info->wsize_int,
				 clui_info->hsize_int, 1, 1, 1, NULL))
	{
		kerror(NULL,"ifilt_design", "Cannot set datatype and/or image size.");
		kexit(KEXIT_FAILURE);
	}

#ifdef DEBUG
	/*
	 * output xvimage to use under 1.0 if 2.0 is hosed.. 
	 */
	if (!kpds_set_attribute(fimage, KPDS_FORMAT, KXVIMAGE))
	{
		kerror("ifilt_design", "main", 
		       "Unable to set format (xvimage) on destination object");
		kexit(KEXIT_FAILURE);
	}
#endif
				
	if (clui_info->lp_flag)
		type = KFILT_LP;
	else if (clui_info->hp_flag)
		type = KFILT_HP;
	else if (clui_info->bp_flag)
		type = KFILT_BP;
	else if (clui_info->bs_flag)
		type = KFILT_BS;
	if (clui_info->ideal_flag)
		brand = KFILT_IDEAL;
	else if (clui_info->but_flag)
		brand = KFILT_BUTTERWORTH;
	else if (clui_info->exp_flag)
		brand = KFILT_EXPONENTIAL;
	else if (clui_info->ch1_flag)
		brand = KFILT_CHEBYSHEV_I;
	else if (clui_info->ch2_flag)
		brand = KFILT_CHEBYSHEV_II;
/* -main_before_lib_call_end */

/* -main_library_call */
	if (!lifilt_design(type, brand,
			   clui_info->order_int, 1.0, 1.0,
			   clui_info->hsize_int, clui_info->wsize_int,
			   clui_info->lcutoff_double,
			   clui_info->ucutoff_double,
			   clui_info->pos_cycle,
			   fimage))
	{
		kpds_close_object(fimage);
		kexit(KEXIT_FAILURE);
	}
/* -main_library_call_end */

/* -main_after_lib_call */
	/* add history to the output object */
	if (!kpds_set_attribute(fimage, KPDS_HISTORY, kpds_history_string()))
	{
	   kerror("ifilt_design", "main", 
		  "Unable to set history on the destination object");
	   kexit(KEXIT_FAILURE);
	}

	kpds_close_object(fimage);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: ifilt_design_usage_additions
| 
|       Purpose: Prints usage additions in ifilt_design_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname ifilt_design
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void ifilt_design_usage_additions(void)
{
	kfprintf(kstderr, "\tGeneral 2-Dimensional Image Filter Design\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: ifilt_design_free_args
| 
|       Purpose: Frees CLUI struct allocated in ifilt_design_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname ifilt_design
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
ifilt_design_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->o_file);
	kfree(clui_info->pos_label);
	kfree(clui_info->type_label);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
