 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "rmonster.h"
/*-----------------------------------------------------------
| 
|  Routine Name: rmonster_get_args
| 
|       Purpose: Gets command line args for rmonster
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname rmonster
|          Date: Apr 15, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void rmonster_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for rmonster is out of sync with arguments specified in rmonster's *.pane file; please rerun ghostwriter on rmonster.";


	/*
	 * allocate the rmonster structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i1",
			  &(clui_info->i1_file),
			  &(clui_info->i1_flag))))
	{
	    kerror(NULL, "rmonster_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "i2",
			  &(clui_info->i2_file),
			  &(clui_info->i2_flag))))
	{
	    kerror(NULL, "rmonster_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "i3",
			  &(clui_info->i3_file),
			  &(clui_info->i3_flag))))
	{
	    kerror(NULL, "rmonster_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "i4",
			  &(clui_info->i4_file),
			  &(clui_info->i4_flag))))
	{
	    kerror(NULL, "rmonster_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "view", KVF_LIST_LABEL,
			  &(clui_info->view_label),
			  &(clui_info->view_flag)) &&
	      kclui_get_value(pane, "view", KVF_LIST_VAL,
			  &(clui_info->view_list),
			  &(clui_info->view_flag))))
	{
	    kerror(NULL, "rmonster_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "wsize",
			  &(clui_info->wsize_int),
			  &(clui_info->wsize_flag))))
	{
	    kerror(NULL, "rmonster_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "hsize",
			  &(clui_info->hsize_int),
			  &(clui_info->hsize_flag))))
	{
	    kerror(NULL, "rmonster_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_logical(pane, "norm",
			  &(clui_info->norm_logic),
			  &(clui_info->norm_flag))))
	{
	    kerror(NULL, "rmonster_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "proj", KVF_LIST_LABEL,
			  &(clui_info->proj_label),
			  &(clui_info->proj_flag)) &&
	      kclui_get_value(pane, "proj", KVF_LIST_VAL,
			  &(clui_info->proj_list),
			  &(clui_info->proj_flag))))
	{
	    kerror(NULL, "rmonster_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_float(pane, "eye_x",
			  &(clui_info->eye_x_float),
			  &(clui_info->eye_x_flag))))
	{
	    kerror(NULL, "rmonster_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_float(pane, "up_x",
			  &(clui_info->up_x_float),
			  &(clui_info->up_x_flag))))
	{
	    kerror(NULL, "rmonster_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_float(pane, "at_x",
			  &(clui_info->at_x_float),
			  &(clui_info->at_x_flag))))
	{
	    kerror(NULL, "rmonster_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_float(pane, "eye_y",
			  &(clui_info->eye_y_float),
			  &(clui_info->eye_y_flag))))
	{
	    kerror(NULL, "rmonster_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_float(pane, "up_y",
			  &(clui_info->up_y_float),
			  &(clui_info->up_y_flag))))
	{
	    kerror(NULL, "rmonster_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_float(pane, "at_y",
			  &(clui_info->at_y_float),
			  &(clui_info->at_y_flag))))
	{
	    kerror(NULL, "rmonster_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_float(pane, "eye_z",
			  &(clui_info->eye_z_float),
			  &(clui_info->eye_z_flag))))
	{
	    kerror(NULL, "rmonster_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_float(pane, "up_z",
			  &(clui_info->up_z_float),
			  &(clui_info->up_z_flag))))
	{
	    kerror(NULL, "rmonster_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_float(pane, "at_z",
			  &(clui_info->at_z_float),
			  &(clui_info->at_z_flag))))
	{
	    kerror(NULL, "rmonster_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_float(pane, "hither",
			  &(clui_info->hither_float),
			  &(clui_info->hither_flag))))
	{
	    kerror(NULL, "rmonster_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_float(pane, "yon",
			  &(clui_info->yon_float),
			  &(clui_info->yon_flag))))
	{
	    kerror(NULL, "rmonster_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_logical(pane, "bc",
			  &(clui_info->bc_logic),
			  &(clui_info->bc_flag))))
	{
	    kerror(NULL, "rmonster_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "rmonster_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "form",
	                &(clui_info->form_file),
	                &(clui_info->form_flag))))
	{
	    kerror(NULL, "rmonster_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}
	if (!(kclui_get_int(pane, "x",
	                &(clui_info->x_int),
	                &(clui_info->x_flag))))
	{
	    kerror(NULL, "rmonster_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}
	if (!(kclui_get_int(pane, "y",
	                &(clui_info->y_int),
	                &(clui_info->y_flag))))
	{
	    kerror(NULL, "rmonster_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

}



