

/*********************************************************************

Copyright (C) 1993, Lawrence Berkeley Laboratory.  All Rights
Reserved.  Permission to copy and modify this software and its
documentation (if any) is hereby granted, provided that this notice
is retained thereon and on all copies.  

This software is provided as a professional academic contribution
for joint exchange.   Thus is is experimental and scientific
in nature, undergoing development, and is provided "as is" with
no warranties of any kind whatsoever, no support, promise of
updates or printed documentation.

This work is supported by the U. S. Department of Energy under 
contract number DE-AC03-76SF00098 between the U. S. Department 
of Energy and the University of California.


	Author: Wes Bethel
		Lawrence Berkeley Laboratory

  "this software is 100% hand-crafted by a human being in the USA"

*********************************************************************/

#include <design.h>
#include <geometry.h>

#include "sort_trans.h"

static float *abuffer=NULL;
static int xsize=0,ysize=0;

#define AINIT 0

int
abuffer_active()
{
    if (abuffer == NULL)
	return(WHACKED);
    else
	return(CHILL);
}

int
deinit_abuffer()
{
    if (abuffer != NULL)
	kfree(abuffer);
    abuffer = NULL;
    return(CHILL);
}

int
init_abuffer(int x,int y)
{
    register float *f;
    register int i;

    deinit_abuffer();
    
    f = abuffer = (float *)kmalloc(sizeof(float) * x * y);
    if (f == NULL)
    {
	kfprintf(kstderr,"ERROR: can't malloc space for abuffer.\n");
	return(WHACKED);
    }

    xsize = x;
    ysize = y;
    for (i=0;i<x*y;i++)
	*f++ = AINIT;
    return(CHILL);
}

int
reset_abuffer()
{
    register float *z;
    register int i;

    z = abuffer;
    for (i=0;i<xsize*ysize;i++)
	*z++ = AINIT;

    return(CHILL);
}

int
abuf_read(int x, int y,float *val)
{
    /* range check on x/y ? */
    
    *val = *(abuffer+x+y*xsize);
    return(CHILL);
}

int
abuf_write(int x,int y,float val)
{
    *(abuffer+x+y*xsize) = val;
    return(CHILL);
}


int
under_composite(float *ar,float *ag,float *ab,float *aa,
		float br, float bg, float bb,float ba)
{
    /**
      * composite b UNDER a, place result back into a.
      *
      * here, we are going to compute the amount of the new color,
      * (br,bg,bb,ba) that "shows through" the existing color,
      * (ar,ag,ab,aa).
      * according to F&Vd, pp 838 (2nd ed 1990), all of the color
      * from the existing pixel survives, and only a fraction of
      * the new pixel "shows through".
     **/
    float fa = *aa;

    if (fa != 1.)
    {
	*ar = *ar*fa + (1. - fa)*br;
	*ag = *ag*fa + (1. - fa)*bg;
	*ab = *ab*fa + (1. - fa)*bb;
	*aa = fa + (1.-fa)*ba;
    }

    return(CHILL);
}

#if 0
int
over_composite(ar,ag,ab,aa,br,bg,bb,ba)
float ar,ag,ab,aa,*br,*bg,*bb,*ba;
{
    int ir,ig,ib;
    float fr,fg,fb,fa;
    float nr,ng,nb,na;
    
    /**
      * composite b OVER a, place result back into a.
      *
      * here, we are going to compute the amount of the background color,
      * (br,bg,bb,ba) that "shows through" the new foreground color,
      * (ar,ag,ab,aa).
     **/
    float fa = *aa;

    if (fa != 1.)
    {
	*ar = *ar*fa + (1. - fa)*br;
	*ag = *ag*fa + (1. - fa)*bg;
	*ab = *ab*fa + (1. - fa)*bb;
	*aa = fa + (1.-fa)*ba;
    }
}
#endif
#if 0
int
z_composite(x,y,z,r,g,b,a)
int x,y;
float z,r,g,b,a;
{
    int ir,ig,ib;
    float fr,fg,fb,fa;
    float nr,ng,nb,na;
    float oz;

    if (a == 0.)
	return;

    zbuf_read(x,y,&oz);  /* get Z value x,y */
    if (z <= oz) /* if new is closer than old. */
    {
	over_composite(x,y,r,g,b,a);
	zbuf_write(x,y,z);
    }

    else  /* old is closer than new */
    {
	abuf_read(x,y,&fa);
	if (fa < 1.0)
	    under_composite(x,y,r,g,b,a);

	/* else the old z value is totally opaque. can't write
	   anything there. */
    }

}
#endif

#if 0
static char abuf_fname[] = {"abuf.ras"};
int
dump_abuffer()
{
    float zmin,zmax,zscale;
    float *z;
    int i,j;
    FILE *f;
    unsigned char *linebuf;
    
    struct rasterfile head;
    head.ras_magic = RAS_MAGIC;
    head.ras_width = xsize;
    head.ras_height = ysize;
    head.ras_depth = 8;
    head.ras_length = xsize*ysize;
    head.ras_type = RT_STANDARD;
    head.ras_maptype = RMT_NONE;
    head.ras_maplength = 0;
    
    f = fopen(abuf_fname,"w");
    fwrite((char *)&head,sizeof(struct rasterfile),1,f);

    zmin = AINIT;
    zmax = -AINIT;
    
    z = abuffer;
    for (j=0;j<ysize;j++)
    {
	for (i=0;i<xsize;i++,z++)
	{
	    if (*z != AINIT)
	    {
		if (*z < zmin)
		    zmin = *z;
		if (*z > zmax)
		    zmax = *z;
	    }
	}
    }

    z = abuffer;
    zscale = (254.)/(zmax - zmin);
    
    linebuf = (unsigned char *)kmalloc(xsize*sizeof(unsigned char));
    for (j=0;j<ysize;j++)
    {
	for (i=0;i<xsize;i++,z++)
	{
	    if (*z == AINIT)
		linebuf[i] = 0;
	    else
		linebuf[i] = (unsigned char)((*z - zmin) * zscale);
	}
	fwrite((char *)linebuf,sizeof(unsigned char),xsize,f);
    }

    kfree((char *)linebuf);
    fclose(f);
}
#endif
