
/*####################################################################

Copyright (C) 1994, 1995 Lawrence Berkeley Laboratory.  All Rights
Reserved.  Permission to copy and modify this software and its
documentation (if any) is hereby granted, provided that this notice
is retained thereon and on all copies.  

This software is provided as a professional academic contribution
for joint exchange.   Thus is is experimental and scientific
in nature, undergoing development, and is provided "as is" with
no warranties of any kind whatsoever, no support, promise of
updates or printed documentation.

This work is supported by the U. S. Department of Energy under 
contract number DE-AC03-76SF00098 between the U. S. Department 
of Energy and the University of California.


	Author: Wes Bethel
		Lawrence Berkeley Laboratory

  "this software is nearly 100% hand-crafted by a human being in the USA"

####################################################################*/

 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


#include "internals.h"

/****************************************************************
* 
*  Routine Name: lhsv_to_rgb
* 
*       Purpose: Library Routine color space conversion
*         Input:
*                  h,s,v - floats to convert
*        Output:
*                  r,g,b - float *'s for destination
*       Returns: TRUE (1) on success, FALSE (0) on failure
*  Restrictions: 
*    Written By: wes
*          Date: 14 may 1993
*      Verified: 
*  Side Effects: 
* Modifications:
*
*      Comments:
****************************************************************/

int
lhsv_to_rgb(float h, float s, float v, float *r, float *g, float *b)
/**
  * h,s,v in (0..1)
  * r,g,b will be in (0..1)
  *
  * this algorithm taken from Foley&VanDam
**/
{
    float f, p, q, t;
    float tr, tg, tb;
    float ht;
    int i;
 
    ht = h;

    if (v == 0.)
    {
	tr=0.;
	tg=0.;
	tb=0.;
    }
    else
    {
	if (s == 0.)
	{
	    tr = v;
	    tg = v;
	    tb = v;
	}
	else
	{
	    ht = ht * 6.0;
	    if (ht >= 6.0)
		ht = 0.0;
      
	    i = ht;
	    f = ht - i;
	    p = v*(1.0-s);
	    q = v*(1.0-s*f);
	    t = v*(1.0-s*(1.0-f));
      
 	    if (i == 0) 
	    {
		tr = v;
		tg = t;
		tb = p;
	    }
	    else if (i == 1)
	    {
		tr = q;
		tg = v;
		tb = p;
	    }
	    else if (i == 2)
	    {
		tr = p;
		tg = v;
		tb = t;
	    }
	    else if (i == 3)
	    {
		tr = p;
		tg = q;
		tb = v;
	    }
	    else if (i == 4)
	    {
		tr = t;
		tg = p;
		tb = v;
	    }
	    else if (i == 5)
	    {
		tr = v;
		tg = p;
		tb = q;
	    }
	}
    }
    *r = tr;
    *g = tg;
    *b = tb;
    return(TRUE);
}
