 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for goctmesh
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "goctmesh.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Create an Octmesh Geometry Object from 3D Data
|
|       Purpose: main program for goctmesh
|
|         Input:
|		char *clui_info->i_file; {input 3d data for octmesh}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {output geometry octmesh}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		char *clui_info->cmap_file; {input vis colormap}
|		int   clui_info->cmap_flag; {TRUE if -cmap specified}
|
|		char *clui_info->name_string; {object name}
|		int   clui_info->name_flag; {TRUE if -name specified}
|
|        Output:
|       Returns:
|
|    Written By: Yo Momma
|          Date: Apr 13, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	kobject inobj,outobj,cmapobj;
	int have_mapfile;
	char *name;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "GEOMETRY");
	kexit_handler(goctmesh_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "GEOMETRY", "goctmesh",
		goctmesh_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	goctmesh_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	inobj = kpds_open_object(clui_info->i_file,KOBJ_READ);
	outobj = kgeom_open_object(clui_info->o_file,KOBJ_WRITE);
	if (clui_info->cmap_flag)
        {
	    cmapobj = kpds_open_object(clui_info->cmap_file,KOBJ_READ);
	    have_mapfile = TRUE;
	}
	else
	    have_mapfile = FALSE;

	name = clui_info->name_string;
/* -main_before_lib_call_end */

/* -main_library_call */
	lgoctmesh(inobj,have_mapfile,cmapobj,outobj,name);
/* -main_library_call_end */

/* -main_after_lib_call */
	kpds_close_object(inobj);
	kpds_close_object(outobj);
	if (have_mapfile == TRUE)
	    kpds_close_object(cmapobj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: goctmesh_usage_additions
| 
|       Purpose: Prints usage additions in goctmesh_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname goctmesh
|          Date: Apr 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void goctmesh_usage_additions(void)
{
	kfprintf(kstderr, "\tCreate an Octmesh Geometry Object from 3D Data\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: goctmesh_free_args
| 
|       Purpose: Frees CLUI struct allocated in goctmesh_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname goctmesh
|          Date: Apr 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
goctmesh_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
	kfree(clui_info->cmap_file);
	kfree(clui_info->name_string);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
