 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for ggencmap
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "ggencmap.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Create a Visualization Colormap
|
|       Purpose: main program for ggencmap
|
|         Input:
|		char *clui_info->outf_file; {output vis colormap}
|		int   clui_info->outf_flag; {TRUE if -outf specified}
|
|		Required M.E. group:
|		    M.I. group:
|			int clui_info->use_hsv_flag; {TRUE if -use_hsv specified}
|
|			float clui_info->hs_float; {hue start value}
|			int   clui_info->hs_flag; {TRUE if -hs specified}
|
|			float clui_info->he_float; {hue end value}
|			int   clui_info->he_flag; {TRUE if -he specified}
|
|			float clui_info->ss_float; {saturation start value}
|			int   clui_info->ss_flag; {TRUE if -ss specified}
|
|			float clui_info->se_float; {saturation end value}
|			int   clui_info->se_flag; {TRUE if -se specified}
|
|			float clui_info->vs_float; {value start value}
|			int   clui_info->vs_flag; {TRUE if -vs specified}
|
|			float clui_info->ve_float; {value end value}
|			int   clui_info->ve_flag; {TRUE if -ve specified}
|
|		    M.I. group:
|			int clui_info->use_rgb_flag; {TRUE if -use_rgb specified}
|
|			float clui_info->rs_float; {red start value}
|			int   clui_info->rs_flag; {TRUE if -rs specified}
|
|			float clui_info->re_float; {red end value}
|			int   clui_info->re_flag; {TRUE if -re specified}
|
|			float clui_info->gs_float; {green start value}
|			int   clui_info->gs_flag; {TRUE if -gs specified}
|
|			float clui_info->ge_float; {green end value}
|			int   clui_info->ge_flag; {TRUE if -ge specified}
|
|			float clui_info->bs_float; {blue start value}
|			int   clui_info->bs_flag; {TRUE if -bs specified}
|
|			float clui_info->be_float; {blue end value}
|			int   clui_info->be_flag; {TRUE if -be specified}
|
|		int clui_info->n_int; {number of entries in the vis colormap.}
|		int clui_info->n_flag; {TRUE if -n specified}
|
|		float clui_info->minval_float; {value used for minimum bracket value in vis colormap}
|		int   clui_info->minval_flag; {TRUE if -minval specified}
|
|		float clui_info->maxval_float; {value assioated with maximum bracket value in map.}
|		int   clui_info->maxval_flag; {TRUE if -maxval specified}
|
|		M.I. group:
|		    int clui_info->use_alpha_flag; {TRUE if -use_alpha specified}
|
|		    float clui_info->as_float; {alpha start value}
|		    int   clui_info->as_flag; {TRUE if -as specified}
|
|		    float clui_info->ae_float; {alpha end value}
|		    int   clui_info->ae_flag; {TRUE if -ae specified}
|
|        Output:
|       Returns:
|
|    Written By: Wes Bethel
|          Date: Apr 13, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        kobject map;
	float color_parms[6];
	float alpha_parms[2];
	int use_alpha,use_hsv_space;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "GEOMETRY");
	kexit_handler(ggencmap_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "GEOMETRY", "ggencmap",
		ggencmap_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	ggencmap_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        if ( !(map = kpds_open_object(clui_info->outf_file,KOBJ_WRITE)) )
        {
	   errno = KINVALID_FILE;
           kerror(NULL,"ggencmap",
                  "Unable to open output file %s as a data services object", 
                  clui_info->outf_file );
           kexit(1);
        }

	if (clui_info->use_hsv_flag)  
	{
	    use_hsv_space = 1;
	    color_parms[0] = clui_info->hs_float;
	    color_parms[1] = clui_info->he_float;
	    color_parms[2] = clui_info->ss_float;
	    color_parms[3] = clui_info->se_float;
	    color_parms[4] = clui_info->vs_float;
	    color_parms[5] = clui_info->ve_float;
	}
	else
	{
	    use_hsv_space = 0;
	    color_parms[0] = clui_info->rs_float;
	    color_parms[1] = clui_info->re_float;
	    color_parms[2] = clui_info->gs_float;
	    color_parms[3] = clui_info->ge_float;
	    color_parms[4] = clui_info->bs_float;
	    color_parms[5] = clui_info->be_float;
	}

	if (clui_info->use_alpha_flag)
	{
	    use_alpha = 1;
	    alpha_parms[0] = clui_info->as_float;
	    alpha_parms[1] = clui_info->ae_float;
	}
	else
	    use_alpha = 0;
/* -main_before_lib_call_end */

/* -main_library_call */
	lggencmap(use_hsv_space,
		   color_parms,
		   use_alpha,
		   alpha_parms,
		   clui_info->n_int,
		   clui_info->minval_float,
		   clui_info->maxval_float,
		   map);
#if 0		   
	lggencmap( clui_info->hs_float,
                    clui_info->he_float,
                    clui_info->ss_float,
                    clui_info->se_float,
                    clui_info->vs_float,
                    clui_info->ve_float,
                    clui_info->as_float,
                    clui_info->ae_float,
                    clui_info->n_int,
                    clui_info->cspace_cycle,
                    clui_info->minvalue_float,
                    clui_info->maxvalue_float,
                    map, NULL ); 
#endif
/* -main_library_call_end */

/* -main_after_lib_call */
       if (!kpds_close_object(map))
       {
           kerror(NULL,"ggencmap",
                  "Unable to close output file %s", clui_info->outf_file );
       }
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: ggencmap_usage_additions
| 
|       Purpose: Prints usage additions in ggencmap_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname ggencmap
|          Date: Apr 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void ggencmap_usage_additions(void)
{
	kfprintf(kstderr, "\tCreate a Visualization Colormap\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: ggencmap_free_args
| 
|       Purpose: Frees CLUI struct allocated in ggencmap_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname ggencmap
|          Date: Apr 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
ggencmap_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->outf_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
