 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "gcmaplegend.h"
/*-----------------------------------------------------------
| 
|  Routine Name: gcmaplegend_get_args
| 
|       Purpose: Gets command line args for gcmaplegend
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname gcmaplegend
|          Date: Apr 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void gcmaplegend_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for gcmaplegend is out of sync with arguments specified in gcmaplegend's *.pane file; please rerun ghostwriter on gcmaplegend.";

	char  *value_string;


	/*
	 * allocate the gcmaplegend structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "gcmaplegend_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "name",
			  &(clui_info->name_string),
			  &(clui_info->name_flag))))
	{
	    kerror(NULL, "gcmaplegend_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "orient", KVF_TOGGLE_VAL,
			  &value_string,
			  &(clui_info->orient_flag))))
	{
	    kerror(NULL, "gcmaplegend_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}
	else clui_info->orient_toggle = atoi(value_string);

	if (!(kclui_get_logical(pane, "reverse",
			  &(clui_info->reverse_logic),
			  &(clui_info->reverse_flag))))
	{
	    kerror(NULL, "gcmaplegend_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_logical(pane, "outline",
			  &(clui_info->outline_logic),
			  &(clui_info->outline_flag))))
	{
	    kerror(NULL, "gcmaplegend_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_float(pane, "length",
			  &(clui_info->length_float),
			  &(clui_info->length_flag))))
	{
	    kerror(NULL, "gcmaplegend_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_float(pane, "thickness",
			  &(clui_info->thickness_float),
			  &(clui_info->thickness_flag))))
	{
	    kerror(NULL, "gcmaplegend_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_float(pane, "xpos",
			  &(clui_info->xpos_float),
			  &(clui_info->xpos_flag))))
	{
	    kerror(NULL, "gcmaplegend_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_float(pane, "ypos",
			  &(clui_info->ypos_float),
			  &(clui_info->ypos_flag))))
	{
	    kerror(NULL, "gcmaplegend_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "gcmaplegend_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



