 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	FormInfo Initialization Routines
   >>>> 
   >>>>  Private: 
   >>>> 	_xvf_init_xprism
   >>>> 	_xvf_free_xprism
   >>>> 
   >>>>   Static: 
   >>>> 	_xvf_init_xprism_warning
   >>>> 	_xvf_init_xprism_error
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "xprism.h"

static void _xvf_init_xprism_warning PROTO((char *));
static void _xvf_init_xprism_error   PROTO((char *, char *));

/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_init_xprism
| 
|       Purpose: Initializes the GUI Information (gui_info_struct) structure
| 
|         Input: forminfo - ptr to _xvf_init_xprism_gui_struct
|                form     - pointer to the form tree
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 20, 1995
| Modifications:  
| 
------------------------------------------------------------*/
int _xvf_init_xprism(

    kform *form, 
    gui_info_struct *forminfo)
{
	ksubform   *subform;
	kcontrol   *pane;
	kselection *selection;
	kcontrol   *master;
	kcontrol   *guidepane;

	master = form->master;
	/*
	 * initializing 'xprism' Form Info structure
	 */

	forminfo->license_struct =
	    kvf_create_struct_from_selname(master->sel_list, "xprism.license");
	if (forminfo->license_struct == NULL)
		    _xvf_init_xprism_warning("unknown selection 'license' on master form");

	forminfo->help_struct =
	    kvf_create_struct_from_selname(master->sel_list, "xprism.help");
	if (forminfo->help_struct == NULL)
		    _xvf_init_xprism_warning("unknown selection 'help' on master form");

	forminfo->quit_struct =
	    kvf_create_struct_from_selname(master->sel_list, "xprism.quit");
	if (forminfo->quit_struct == NULL)
		    _xvf_init_xprism_warning("quit button 'quit' on master form");
	forminfo->quit = FALSE;

	forminfo->workspace_struct =
	    kvf_create_struct_from_selname(master->sel_list, "xprism.workspace");
	if (forminfo->workspace_struct == NULL)
	    _xvf_init_xprism_warning("workspace 'workspace' on master form");
	else
	{
	    kvf_get_attribute(forminfo->workspace_struct, KVF_WORKSPACE,
	                    &(forminfo->workspace));

	}
	forminfo->reset_wcs_struct =
	    kvf_create_struct_from_selname(master->sel_list, "xprism.reset_wcs");
	if (forminfo->reset_wcs_struct == NULL)
	    _xvf_init_xprism_warning("master action button 'reset_wcs' on master form");
	forminfo->reset_wcs = FALSE;
	selection = forminfo->reset_wcs_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->add_indicator_struct =
	    kvf_create_struct_from_selname(master->sel_list, "xprism.add_indicator");
	if (forminfo->add_indicator_struct == NULL)
	    _xvf_init_xprism_warning("master action button 'add_indicator' on master form");
	forminfo->add_indicator = FALSE;
	selection = forminfo->add_indicator_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->remove_area_struct =
	    kvf_create_struct_from_selname(master->sel_list, "xprism.remove_area");
	if (forminfo->remove_area_struct == NULL)
	    _xvf_init_xprism_warning("master action button 'remove_area' on master form");
	forminfo->remove_area = FALSE;
	selection = forminfo->remove_area_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->refresh_area_struct =
	    kvf_create_struct_from_selname(master->sel_list, "xprism.refresh_area");
	if (forminfo->refresh_area_struct == NULL)
	    _xvf_init_xprism_warning("master action button 'refresh_area' on master form");
	forminfo->refresh_area = FALSE;
	selection = forminfo->refresh_area_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->clear_layout_struct =
	    kvf_create_struct_from_selname(master->sel_list, "xprism.clear_layout");
	if (forminfo->clear_layout_struct == NULL)
	    _xvf_init_xprism_warning("master action button 'clear_layout' on master form");
	forminfo->clear_layout = FALSE;
	selection = forminfo->clear_layout_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->layout_menu_struct =
	    kvf_create_struct_from_selname(master->sel_list, "xprism.layout_menu");
	if (forminfo->layout_menu_struct == NULL)
	    _xvf_init_xprism_warning("master action button 'layout_menu' on master form");
	forminfo->layout_menu = FALSE;
	selection = forminfo->layout_menu_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->b0_struct =
	    kvf_create_struct_from_selname(master->sel_list, "xprism.b0");
	if (forminfo->b0_struct == NULL)
	    _xvf_init_xprism_warning("blank selection 'b0' on master form");
	forminfo->Plot_struct =
	    kvf_create_struct_from_subformname(form, "xprism.Plot");
	if (forminfo->Plot_struct == NULL)
	{
	    _xvf_init_xprism_error("subform 'Plot' on form 'xprism'", 
			    "xprism_Plot");
	    return(FALSE);
	}

	/*
	 * initializing 'xprism->Plot' Subform Info structure
	 */

	forminfo->Plot = (xprism_Plot *)
				kcalloc(1, sizeof(xprism_Plot));
	subform = forminfo->Plot_struct->Subformptr;
	guidepane = subform->guidepane;
	forminfo->Plot->help_struct =
	    kvf_create_struct_from_selname(guidepane->sel_list, "xprism.Plot.help");
	if (forminfo->Plot->help_struct == NULL)
		    _xvf_init_xprism_warning("unknown selection 'help' on subform 'Plot'");

	forminfo->Plot->quit_struct =
	    kvf_create_struct_from_selname(guidepane->sel_list, "xprism.Plot.quit");
	if (forminfo->Plot->quit_struct == NULL)
		    _xvf_init_xprism_warning("quit button 'quit' on subform 'Plot'");
	forminfo->Plot->quit = FALSE;


	/*
	 * initializing 'xprism->Plot->file' Pane Info structure
	 */

	forminfo->Plot->file = (Plot_file *)
				kcalloc(1, sizeof(Plot_file));
	forminfo->Plot->file_struct =
	    kvf_create_struct_from_panename(subform, "xprism.Plot.file");
	if (forminfo->Plot->file_struct == NULL)
	{
	    _xvf_init_xprism_error("pane 'file' on subform 'Plot'", "Plot_file");
	    return(FALSE);
	}
	pane = forminfo->Plot->file_struct->Controlptr;
	forminfo->Plot->file->input_blank_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Plot.file.input_blank");
	if (forminfo->Plot->file->input_blank_struct == NULL)
	    _xvf_init_xprism_warning("blank selection 'input_blank' on pane 'file' of subform 'Plot'");
	forminfo->Plot->file->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Plot.file.help");
	if (forminfo->Plot->file->help_struct == NULL)
		    _xvf_init_xprism_warning("unknown selection 'help' on pane 'file' of subform 'Plot'");

	forminfo->Plot->file->input_file_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Plot.file.input_file");
	if (forminfo->Plot->file->input_file_struct != NULL)
	{
	    selection = forminfo->Plot->file->input_file_struct->Selptr;
	    kvf_get_attribute(forminfo->Plot->file->input_file_struct, KVF_FILE_DEF,
	                    &(forminfo->Plot->file->input_file));
	}
	else
	    _xvf_init_xprism_warning("input selection 'input_file' on pane 'file' of subform 'Plot'");

	forminfo->Plot->file->input_file_selected = FALSE;

	forminfo->Plot->file->plot_where_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Plot.file.plot_where");
	if (forminfo->Plot->file->plot_where_struct != NULL)
	{
	    selection = forminfo->Plot->file->plot_where_struct->Selptr;
	    kvf_get_attribute(forminfo->Plot->file->plot_where_struct, KVF_TOGGLE_NUM,
	                    &(forminfo->Plot->file->plot_where_num));
	    forminfo->Plot->file->plot_where_val = 1;
	}
	else
	    _xvf_init_xprism_warning("toggle selection 'plot_where' on pane 'file' of subform 'Plot'");


	forminfo->Plot->file->object_type_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Plot.file.object_type");
	if (forminfo->Plot->file->object_type_struct != NULL)
	{
	    selection = forminfo->Plot->file->object_type_struct->Selptr;
	    kvf_get_attribute(forminfo->Plot->file->object_type_struct, KVF_TOGGLE_NUM,
	                    &(forminfo->Plot->file->object_type_num));
	    forminfo->Plot->file->object_type_val = 1;
	}
	else
	    _xvf_init_xprism_warning("toggle selection 'object_type' on pane 'file' of subform 'Plot'");



	/*
	 * initializing 'xprism->Plot->function' Pane Info structure
	 */

	forminfo->Plot->function = (Plot_function *)
				kcalloc(1, sizeof(Plot_function));
	forminfo->Plot->function_struct =
	    kvf_create_struct_from_panename(subform, "xprism.Plot.function");
	if (forminfo->Plot->function_struct == NULL)
	{
	    _xvf_init_xprism_error("pane 'function' on subform 'Plot'", "Plot_function");
	    return(FALSE);
	}
	pane = forminfo->Plot->function_struct->Controlptr;
	forminfo->Plot->function->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Plot.function.help");
	if (forminfo->Plot->function->help_struct == NULL)
		    _xvf_init_xprism_warning("unknown selection 'help' on pane 'function' of subform 'Plot'");

	forminfo->Plot->function->plot_dim_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Plot.function.plot_dim");
	if (forminfo->Plot->function->plot_dim_struct != NULL)
	{
	    selection = forminfo->Plot->function->plot_dim_struct->Selptr;
	    kvf_get_attribute(forminfo->Plot->function->plot_dim_struct, KVF_CYCLE_VAL,
	                    &(forminfo->Plot->function->plot_dim));
	    kvf_get_attribute(forminfo->Plot->function->plot_dim_struct, KVF_CYCLE_LABEL,
	                    &(forminfo->Plot->function->plot_dim_label));
	}
	else
	    _xvf_init_xprism_warning("cycle selection 'plot_dim' on pane 'function' of subform 'Plot'");

	forminfo->Plot->function->plot_dim_selected = FALSE;

	forminfo->Plot->function->func_3D_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Plot.function.func_3D");
	if (forminfo->Plot->function->func_3D_struct != NULL)
	{
	    selection = forminfo->Plot->function->func_3D_struct->Selptr;
	    kvf_get_attribute(forminfo->Plot->function->func_3D_struct, KVF_STRING_DEF,
	                    &(forminfo->Plot->function->func_3D));
	}
	else
	    _xvf_init_xprism_warning("string selection 'func_3D' on pane 'function' of subform 'Plot'");


	forminfo->Plot->function->func_2D_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Plot.function.func_2D");
	if (forminfo->Plot->function->func_2D_struct != NULL)
	{
	    selection = forminfo->Plot->function->func_2D_struct->Selptr;
	    kvf_get_attribute(forminfo->Plot->function->func_2D_struct, KVF_STRING_DEF,
	                    &(forminfo->Plot->function->func_2D));
	}
	else
	    _xvf_init_xprism_warning("string selection 'func_2D' on pane 'function' of subform 'Plot'");


	forminfo->Plot->function->x_min_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Plot.function.x_min");
	if (forminfo->Plot->function->x_min_struct != NULL)
	{
	    selection = forminfo->Plot->function->x_min_struct->Selptr;
	    kvf_get_attribute(forminfo->Plot->function->x_min_struct, KVF_STRING_DEF,
	                    &(forminfo->Plot->function->x_min));
	}
	else
	    _xvf_init_xprism_warning("string selection 'x_min' on pane 'function' of subform 'Plot'");


	forminfo->Plot->function->x_max_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Plot.function.x_max");
	if (forminfo->Plot->function->x_max_struct != NULL)
	{
	    selection = forminfo->Plot->function->x_max_struct->Selptr;
	    kvf_get_attribute(forminfo->Plot->function->x_max_struct, KVF_STRING_DEF,
	                    &(forminfo->Plot->function->x_max));
	}
	else
	    _xvf_init_xprism_warning("string selection 'x_max' on pane 'function' of subform 'Plot'");


	forminfo->Plot->function->xnum_pts_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Plot.function.xnum_pts");
	if (forminfo->Plot->function->xnum_pts_struct != NULL)
	{
	    selection = forminfo->Plot->function->xnum_pts_struct->Selptr;
	    kvf_get_attribute(forminfo->Plot->function->xnum_pts_struct, KVF_STRING_DEF,
	                    &(forminfo->Plot->function->xnum_pts));
	}
	else
	    _xvf_init_xprism_warning("string selection 'xnum_pts' on pane 'function' of subform 'Plot'");


	forminfo->Plot->function->y_min_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Plot.function.y_min");
	if (forminfo->Plot->function->y_min_struct != NULL)
	{
	    selection = forminfo->Plot->function->y_min_struct->Selptr;
	    kvf_get_attribute(forminfo->Plot->function->y_min_struct, KVF_STRING_DEF,
	                    &(forminfo->Plot->function->y_min));
	}
	else
	    _xvf_init_xprism_warning("string selection 'y_min' on pane 'function' of subform 'Plot'");


	forminfo->Plot->function->y_max_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Plot.function.y_max");
	if (forminfo->Plot->function->y_max_struct != NULL)
	{
	    selection = forminfo->Plot->function->y_max_struct->Selptr;
	    kvf_get_attribute(forminfo->Plot->function->y_max_struct, KVF_STRING_DEF,
	                    &(forminfo->Plot->function->y_max));
	}
	else
	    _xvf_init_xprism_warning("string selection 'y_max' on pane 'function' of subform 'Plot'");


	forminfo->Plot->function->ynum_pts_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Plot.function.ynum_pts");
	if (forminfo->Plot->function->ynum_pts_struct != NULL)
	{
	    selection = forminfo->Plot->function->ynum_pts_struct->Selptr;
	    kvf_get_attribute(forminfo->Plot->function->ynum_pts_struct, KVF_STRING_DEF,
	                    &(forminfo->Plot->function->ynum_pts));
	}
	else
	    _xvf_init_xprism_warning("string selection 'ynum_pts' on pane 'function' of subform 'Plot'");


	forminfo->Plot->function->where_plot_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Plot.function.where_plot");
	if (forminfo->Plot->function->where_plot_struct != NULL)
	{
	    selection = forminfo->Plot->function->where_plot_struct->Selptr;
	    kvf_get_attribute(forminfo->Plot->function->where_plot_struct, KVF_TOGGLE_NUM,
	                    &(forminfo->Plot->function->where_plot_num));
	    forminfo->Plot->function->where_plot_val = 1;
	}
	else
	    _xvf_init_xprism_warning("toggle selection 'where_plot' on pane 'function' of subform 'Plot'");


	forminfo->Plot->function->plot_function_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Plot.function.plot_function");
	if (forminfo->Plot->function->plot_function_struct == NULL)
	    _xvf_init_xprism_warning("pane action button 'plot_function' on pane 'function' of subform 'Plot'");
	forminfo->Plot->function->plot_function = FALSE;
	selection = forminfo->Plot->function->plot_function_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->Plot->function->func_3D_blk_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Plot.function.func_3D_blk");
	if (forminfo->Plot->function->func_3D_blk_struct == NULL)
	    _xvf_init_xprism_warning("blank selection 'func_3D_blk' on pane 'function' of subform 'Plot'");
	forminfo->Plot->function->func_2D_blk_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Plot.function.func_2D_blk");
	if (forminfo->Plot->function->func_2D_blk_struct == NULL)
	    _xvf_init_xprism_warning("blank selection 'func_2D_blk' on pane 'function' of subform 'Plot'");
	forminfo->Plot->function->blank1_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Plot.function.blank1");
	if (forminfo->Plot->function->blank1_struct == NULL)
	    _xvf_init_xprism_warning("blank selection 'blank1' on pane 'function' of subform 'Plot'");
	forminfo->Plot->function->X_blk_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Plot.function.X_blk");
	if (forminfo->Plot->function->X_blk_struct == NULL)
	    _xvf_init_xprism_warning("blank selection 'X_blk' on pane 'function' of subform 'Plot'");
	forminfo->Plot->function->Y_blk_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Plot.function.Y_blk");
	if (forminfo->Plot->function->Y_blk_struct == NULL)
	    _xvf_init_xprism_warning("blank selection 'Y_blk' on pane 'function' of subform 'Plot'");

	/*
	 * initializing 'xprism->Plot->plot_control' Pane Info structure
	 */

	forminfo->Plot->plot_control = (Plot_plot_control *)
				kcalloc(1, sizeof(Plot_plot_control));
	forminfo->Plot->plot_control_struct =
	    kvf_create_struct_from_panename(subform, "xprism.Plot.plot_control");
	if (forminfo->Plot->plot_control_struct == NULL)
	{
	    _xvf_init_xprism_error("pane 'plot_control' on subform 'Plot'", "Plot_plot_control");
	    return(FALSE);
	}
	pane = forminfo->Plot->plot_control_struct->Controlptr;
	forminfo->Plot->plot_control->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Plot.plot_control.help");
	if (forminfo->Plot->plot_control->help_struct == NULL)
		    _xvf_init_xprism_warning("unknown selection 'help' on pane 'plot_control' of subform 'Plot'");

	forminfo->Plot->plot_control->plot2d_type_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Plot.plot_control.plot2d_type");
	if (forminfo->Plot->plot_control->plot2d_type_struct != NULL)
	{
	    selection = forminfo->Plot->plot_control->plot2d_type_struct->Selptr;
	    kvf_get_attribute(forminfo->Plot->plot_control->plot2d_type_struct, KVF_TOGGLE_NUM,
	                    &(forminfo->Plot->plot_control->plot2d_type_num));
	    forminfo->Plot->plot_control->plot2d_type_val = 1;
	}
	else
	    _xvf_init_xprism_warning("toggle selection 'plot2d_type' on pane 'plot_control' of subform 'Plot'");


	forminfo->Plot->plot_control->plot3d_type_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Plot.plot_control.plot3d_type");
	if (forminfo->Plot->plot_control->plot3d_type_struct != NULL)
	{
	    selection = forminfo->Plot->plot_control->plot3d_type_struct->Selptr;
	    kvf_get_attribute(forminfo->Plot->plot_control->plot3d_type_struct, KVF_TOGGLE_NUM,
	                    &(forminfo->Plot->plot_control->plot3d_type_num));
	    forminfo->Plot->plot_control->plot3d_type_val = 1;
	}
	else
	    _xvf_init_xprism_warning("toggle selection 'plot3d_type' on pane 'plot_control' of subform 'Plot'");


	forminfo->Options_struct =
	    kvf_create_struct_from_subformname(form, "xprism.Options");
	if (forminfo->Options_struct == NULL)
	{
	    _xvf_init_xprism_error("subform 'Options' on form 'xprism'", 
			    "xprism_Options");
	    return(FALSE);
	}

	/*
	 * initializing 'xprism->Options' Subform Info structure
	 */

	forminfo->Options = (xprism_Options *)
				kcalloc(1, sizeof(xprism_Options));
	subform = forminfo->Options_struct->Subformptr;

	/*
	 * initializing 'xprism->Options->options' Pane Info structure
	 */

	forminfo->Options->options = (Options_options *)
				kcalloc(1, sizeof(Options_options));
	forminfo->Options->options_struct =
	    kvf_create_struct_from_panename(subform, "xprism.Options.options");
	if (forminfo->Options->options_struct == NULL)
	{
	    _xvf_init_xprism_error("pane 'options' on subform 'Options'", "Options_options");
	    return(FALSE);
	}
	pane = forminfo->Options->options_struct->Controlptr;
	forminfo->Options->options->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Options.options.help");
	if (forminfo->Options->options->help_struct == NULL)
		    _xvf_init_xprism_warning("unknown selection 'help' on pane 'options' of subform 'Options'");

	forminfo->Options->options->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Options.options.quit");
	if (forminfo->Options->options->quit_struct == NULL)
		    _xvf_init_xprism_warning("quit button 'quit' on pane 'options' of subform 'Options'");
	forminfo->Options->options->quit = FALSE;

	forminfo->Options->options->area_list_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Options.options.area_list");
	if (forminfo->Options->options->area_list_struct != NULL)
	{
	    selection = forminfo->Options->options->area_list_struct->Selptr;
	    kvf_get_attribute(forminfo->Options->options->area_list_struct, KVF_LIST_VAL,
	                    &(forminfo->Options->options->area_list));
	    kvf_get_attribute(forminfo->Options->options->area_list_struct, KVF_LIST_LABEL,
	                    &(forminfo->Options->options->area_list_label));
	}
	else
	    _xvf_init_xprism_warning("displaylist selection 'area_list' on pane 'options' of subform 'Options'");

	forminfo->Options->options->area_list_selected = FALSE;

	forminfo->Options->options->plot_list_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Options.options.plot_list");
	if (forminfo->Options->options->plot_list_struct != NULL)
	{
	    selection = forminfo->Options->options->plot_list_struct->Selptr;
	    kvf_get_attribute(forminfo->Options->options->plot_list_struct, KVF_LIST_VAL,
	                    &(forminfo->Options->options->plot_list));
	    kvf_get_attribute(forminfo->Options->options->plot_list_struct, KVF_LIST_LABEL,
	                    &(forminfo->Options->options->plot_list_label));
	}
	else
	    _xvf_init_xprism_warning("displaylist selection 'plot_list' on pane 'options' of subform 'Options'");

	forminfo->Options->options->plot_list_selected = FALSE;

	forminfo->Options->options->open_area_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Options.options.open_area");
	if (forminfo->Options->options->open_area_struct == NULL)
	    _xvf_init_xprism_warning("pane action button 'open_area' on pane 'options' of subform 'Options'");
	forminfo->Options->options->open_area = FALSE;
	selection = forminfo->Options->options->open_area_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->Options->options->open_plot_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Options.options.open_plot");
	if (forminfo->Options->options->open_plot_struct == NULL)
	    _xvf_init_xprism_warning("pane action button 'open_plot' on pane 'options' of subform 'Options'");
	forminfo->Options->options->open_plot = FALSE;
	selection = forminfo->Options->options->open_plot_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->Options->options->delete_area_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Options.options.delete_area");
	if (forminfo->Options->options->delete_area_struct == NULL)
	    _xvf_init_xprism_warning("pane action button 'delete_area' on pane 'options' of subform 'Options'");
	forminfo->Options->options->delete_area = FALSE;
	selection = forminfo->Options->options->delete_area_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->Options->options->delete_plot_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Options.options.delete_plot");
	if (forminfo->Options->options->delete_plot_struct == NULL)
	    _xvf_init_xprism_warning("pane action button 'delete_plot' on pane 'options' of subform 'Options'");
	forminfo->Options->options->delete_plot = FALSE;
	selection = forminfo->Options->options->delete_plot_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->Print_struct =
	    kvf_create_struct_from_subformname(form, "xprism.Print");
	if (forminfo->Print_struct == NULL)
	{
	    _xvf_init_xprism_error("subform 'Print' on form 'xprism'", 
			    "xprism_Print");
	    return(FALSE);
	}

	/*
	 * initializing 'xprism->Print' Subform Info structure
	 */

	forminfo->Print = (xprism_Print *)
				kcalloc(1, sizeof(xprism_Print));
	subform = forminfo->Print_struct->Subformptr;

	/*
	 * initializing 'xprism->Print->screen_dump' Pane Info structure
	 */

	forminfo->Print->screen_dump = (Print_screen_dump *)
				kcalloc(1, sizeof(Print_screen_dump));
	forminfo->Print->screen_dump_struct =
	    kvf_create_struct_from_panename(subform, "xprism.Print.screen_dump");
	if (forminfo->Print->screen_dump_struct == NULL)
	{
	    _xvf_init_xprism_error("pane 'screen_dump' on subform 'Print'", "Print_screen_dump");
	    return(FALSE);
	}
	pane = forminfo->Print->screen_dump_struct->Controlptr;
	forminfo->Print->screen_dump->display_output_blank_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Print.screen_dump.display_output_blank");
	if (forminfo->Print->screen_dump->display_output_blank_struct == NULL)
	    _xvf_init_xprism_warning("blank selection 'display_output_blank' on pane 'screen_dump' of subform 'Print'");
	forminfo->Print->screen_dump->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Print.screen_dump.help");
	if (forminfo->Print->screen_dump->help_struct == NULL)
		    _xvf_init_xprism_warning("unknown selection 'help' on pane 'screen_dump' of subform 'Print'");

	forminfo->Print->screen_dump->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Print.screen_dump.quit");
	if (forminfo->Print->screen_dump->quit_struct == NULL)
		    _xvf_init_xprism_warning("quit button 'quit' on pane 'screen_dump' of subform 'Print'");
	forminfo->Print->screen_dump->quit = FALSE;

	forminfo->Print->screen_dump->dump_what_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Print.screen_dump.dump_what");
	if (forminfo->Print->screen_dump->dump_what_struct != NULL)
	{
	    selection = forminfo->Print->screen_dump->dump_what_struct->Selptr;
	    kvf_get_attribute(forminfo->Print->screen_dump->dump_what_struct, KVF_TOGGLE_NUM,
	                    &(forminfo->Print->screen_dump->dump_what_num));
	    forminfo->Print->screen_dump->dump_what_val = 2;
	}
	else
	    _xvf_init_xprism_warning("toggle selection 'dump_what' on pane 'screen_dump' of subform 'Print'");


	forminfo->Print->screen_dump->display_file_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Print.screen_dump.display_file");
	if (forminfo->Print->screen_dump->display_file_struct != NULL)
	{
	    selection = forminfo->Print->screen_dump->display_file_struct->Selptr;
	    kvf_get_attribute(forminfo->Print->screen_dump->display_file_struct, KVF_FILE_DEF,
	                    &(forminfo->Print->screen_dump->display_file));
	}
	else
	    _xvf_init_xprism_warning("output selection 'display_file' on pane 'screen_dump' of subform 'Print'");

	forminfo->Print->screen_dump->display_file_selected = FALSE;

	forminfo->Colormap_struct =
	    kvf_create_struct_from_subformname(form, "xprism.Colormap");
	if (forminfo->Colormap_struct == NULL)
	{
	    _xvf_init_xprism_error("subform 'Colormap' on form 'xprism'", 
			    "xprism_Colormap");
	    return(FALSE);
	}

	/*
	 * initializing 'xprism->Colormap' Subform Info structure
	 */

	forminfo->Colormap = (xprism_Colormap *)
				kcalloc(1, sizeof(xprism_Colormap));
	subform = forminfo->Colormap_struct->Subformptr;

	/*
	 * initializing 'xprism->Colormap->colormap' Pane Info structure
	 */

	forminfo->Colormap->colormap = (Colormap_colormap *)
				kcalloc(1, sizeof(Colormap_colormap));
	forminfo->Colormap->colormap_struct =
	    kvf_create_struct_from_panename(subform, "xprism.Colormap.colormap");
	if (forminfo->Colormap->colormap_struct == NULL)
	{
	    _xvf_init_xprism_error("pane 'colormap' on subform 'Colormap'", "Colormap_colormap");
	    return(FALSE);
	}
	pane = forminfo->Colormap->colormap_struct->Controlptr;
	forminfo->Colormap->colormap->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Colormap.colormap.help");
	if (forminfo->Colormap->colormap->help_struct == NULL)
		    _xvf_init_xprism_warning("unknown selection 'help' on pane 'colormap' of subform 'Colormap'");

	forminfo->Colormap->colormap->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Colormap.colormap.quit");
	if (forminfo->Colormap->colormap->quit_struct == NULL)
		    _xvf_init_xprism_warning("quit button 'quit' on pane 'colormap' of subform 'Colormap'");
	forminfo->Colormap->colormap->quit = FALSE;

	if (!(xvf_create_subform(subform, -1, -1, FALSE)))
	   return(FALSE);
	_xvf_get_Colormap(forminfo->Colormap);
	if (!(xvf_create_pane(pane, FALSE)))
	   return(FALSE);
	_xvf_get_colormap(forminfo->Colormap->colormap);
	forminfo->Colormap->colormap->wksp1_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Colormap.colormap.wksp1");
	if (forminfo->Colormap->colormap->wksp1_struct == NULL)
	    _xvf_init_xprism_warning("workspace 'wksp1' on pane 'colormap' of subform 'Colormap'");
	else
	{
	    kvf_get_attribute(forminfo->Colormap->colormap->wksp1_struct, KVF_WORKSPACE,
	                    &(forminfo->Colormap->colormap->wksp1));

	}
	forminfo->Colormap->colormap->wksp2_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Colormap.colormap.wksp2");
	if (forminfo->Colormap->colormap->wksp2_struct == NULL)
	    _xvf_init_xprism_warning("workspace 'wksp2' on pane 'colormap' of subform 'Colormap'");
	else
	{
	    kvf_get_attribute(forminfo->Colormap->colormap->wksp2_struct, KVF_WORKSPACE,
	                    &(forminfo->Colormap->colormap->wksp2));

	}
	forminfo->Colormap->colormap->b1_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Colormap.colormap.b1");
	if (forminfo->Colormap->colormap->b1_struct == NULL)
	    _xvf_init_xprism_warning("blank selection 'b1' on pane 'colormap' of subform 'Colormap'");
	forminfo->Colormap->colormap->b2_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Colormap.colormap.b2");
	if (forminfo->Colormap->colormap->b2_struct == NULL)
	    _xvf_init_xprism_warning("blank selection 'b2' on pane 'colormap' of subform 'Colormap'");
	forminfo->Deflts_struct =
	    kvf_create_struct_from_subformname(form, "xprism.Deflts");
	if (forminfo->Deflts_struct == NULL)
	{
	    _xvf_init_xprism_error("subform 'Deflts' on form 'xprism'", 
			    "xprism_Deflts");
	    return(FALSE);
	}

	/*
	 * initializing 'xprism->Deflts' Subform Info structure
	 */

	forminfo->Deflts = (xprism_Deflts *)
				kcalloc(1, sizeof(xprism_Deflts));
	subform = forminfo->Deflts_struct->Subformptr;

	/*
	 * initializing 'xprism->Deflts->deflts' Pane Info structure
	 */

	forminfo->Deflts->deflts = (Deflts_deflts *)
				kcalloc(1, sizeof(Deflts_deflts));
	forminfo->Deflts->deflts_struct =
	    kvf_create_struct_from_panename(subform, "xprism.Deflts.deflts");
	if (forminfo->Deflts->deflts_struct == NULL)
	{
	    _xvf_init_xprism_error("pane 'deflts' on subform 'Deflts'", "Deflts_deflts");
	    return(FALSE);
	}
	pane = forminfo->Deflts->deflts_struct->Controlptr;
	forminfo->Deflts->deflts->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Deflts.deflts.help");
	if (forminfo->Deflts->deflts->help_struct == NULL)
		    _xvf_init_xprism_warning("unknown selection 'help' on pane 'deflts' of subform 'Deflts'");

	forminfo->Deflts->deflts->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Deflts.deflts.quit");
	if (forminfo->Deflts->deflts->quit_struct == NULL)
		    _xvf_init_xprism_warning("quit button 'quit' on pane 'deflts' of subform 'Deflts'");
	forminfo->Deflts->deflts->quit = FALSE;

	forminfo->Deflts->deflts->new_plot_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Deflts.deflts.new_plot");
	if (forminfo->Deflts->deflts->new_plot_struct != NULL)
	{
	    selection = forminfo->Deflts->deflts->new_plot_struct->Selptr;
	    kvf_get_attribute(forminfo->Deflts->deflts->new_plot_struct, KVF_LIST_VAL,
	                    &(forminfo->Deflts->deflts->new_plot));
	    kvf_get_attribute(forminfo->Deflts->deflts->new_plot_struct, KVF_LIST_LABEL,
	                    &(forminfo->Deflts->deflts->new_plot_label));
	}
	else
	    _xvf_init_xprism_warning("list selection 'new_plot' on pane 'deflts' of subform 'Deflts'");

	forminfo->Deflts->deflts->display_title_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Deflts.deflts.display_title");
	if (forminfo->Deflts->deflts->display_title_struct != NULL)
	{
	    selection = forminfo->Deflts->deflts->display_title_struct->Selptr;
	    kvf_get_attribute(forminfo->Deflts->deflts->display_title_struct, KVF_LOGIC_DEF,
	                    &(forminfo->Deflts->deflts->display_title));
	    kvf_get_attribute(forminfo->Deflts->deflts->display_title_struct, KVF_LOGIC_LABEL,
	                    &(forminfo->Deflts->deflts->display_title_label));
	}
	else
	    _xvf_init_xprism_warning("logical selection 'display_title' on pane 'deflts' of subform 'Deflts'");

	forminfo->Deflts->deflts->display_date_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Deflts.deflts.display_date");
	if (forminfo->Deflts->deflts->display_date_struct != NULL)
	{
	    selection = forminfo->Deflts->deflts->display_date_struct->Selptr;
	    kvf_get_attribute(forminfo->Deflts->deflts->display_date_struct, KVF_LOGIC_DEF,
	                    &(forminfo->Deflts->deflts->display_date));
	    kvf_get_attribute(forminfo->Deflts->deflts->display_date_struct, KVF_LOGIC_LABEL,
	                    &(forminfo->Deflts->deflts->display_date_label));
	}
	else
	    _xvf_init_xprism_warning("logical selection 'display_date' on pane 'deflts' of subform 'Deflts'");

	forminfo->Deflts->deflts->background_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Deflts.deflts.background");
	if (forminfo->Deflts->deflts->background_struct != NULL)
	{
	    selection = forminfo->Deflts->deflts->background_struct->Selptr;
	    kvf_get_attribute(forminfo->Deflts->deflts->background_struct, KVF_STRING_DEF,
	                    &(forminfo->Deflts->deflts->background));
	}
	else
	    _xvf_init_xprism_warning("string list selection 'background' on pane 'deflts' of subform 'Deflts'");


	forminfo->Deflts->deflts->foreground_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "xprism.Deflts.deflts.foreground");
	if (forminfo->Deflts->deflts->foreground_struct != NULL)
	{
	    selection = forminfo->Deflts->deflts->foreground_struct->Selptr;
	    kvf_get_attribute(forminfo->Deflts->deflts->foreground_struct, KVF_STRING_DEF,
	                    &(forminfo->Deflts->deflts->foreground));
	}
	else
	    _xvf_init_xprism_warning("string list selection 'foreground' on pane 'deflts' of subform 'Deflts'");


	forminfo->xprism_struct =
	    kvf_create_struct_from_mastername(form, "xprism");
	if (forminfo->xprism_struct == NULL)
	{
	    _xvf_init_xprism_error("form 'xprism'",
			    "gui_info");
	    return(FALSE);
	}

	return(TRUE);

}

/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_init_xprism_warning
| 
|       Purpose: Prints warning when code is out of sync with UIS file
| 
|         Input: string - item that cannot be found
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 20, 1995
| Modifications:  
| 
------------------------------------------------------------*/
static void _xvf_init_xprism_warning(
    char *string)
{
	kfprintf(kstderr, "Warning: cannot find %s.\n", string);
	kfprintf(kstderr, "         UIS file out of sync with code\n");
	kfprintf(kstderr, "         generated by conductor in 'form_init.c'.\n");
}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_init_xprism_error
| 
|       Purpose: Prints error when code is irreconcilable with UIS file
| 
|         Input: string1 - item that cannot be found
|                string2 - name of FormInfo structure
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 20, 1995
| Modifications:  
| 
------------------------------------------------------------*/
static void _xvf_init_xprism_error(
    char *string1,
    char *string2)
{
	kfprintf(kstderr, "ERROR: cannot find %s.\n", string1);
	kfprintf(kstderr, "         UIS file out of sync with code\n");
	kfprintf(kstderr, "         generated by conductor in 'form_init.c'.\n");
	kfprintf(kstderr, "         Unable to initialize '%s' structure as defined in form_info.h; Aborting.\n", string2);
}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_free_xprism
| 
|       Purpose: Frees the gui_info_struct
| 
|         Input: forminfo - ptr to _xvf_free_xprism_gui_struct
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 20, 1995
| Modifications:  
| 
------------------------------------------------------------*/
void _xvf_free_xprism(
    gui_info_struct *forminfo)
{
	if (forminfo->license_struct != NULL)
	    kfree(forminfo->license_struct);
	if (forminfo->help_struct != NULL)
	    kfree(forminfo->help_struct);
	if (forminfo->quit_struct != NULL)
	    kfree(forminfo->quit_struct);
	if (forminfo->workspace_struct != NULL)
	    kfree(forminfo->workspace_struct);
	if (forminfo->reset_wcs_struct != NULL)
	    kfree(forminfo->reset_wcs_struct);
	if (forminfo->add_indicator_struct != NULL)
	    kfree(forminfo->add_indicator_struct);
	if (forminfo->remove_area_struct != NULL)
	    kfree(forminfo->remove_area_struct);
	if (forminfo->refresh_area_struct != NULL)
	    kfree(forminfo->refresh_area_struct);
	if (forminfo->clear_layout_struct != NULL)
	    kfree(forminfo->clear_layout_struct);
	if (forminfo->layout_menu_struct != NULL)
	    kfree(forminfo->layout_menu_struct);
	if (forminfo->b0_struct != NULL)
	    kfree(forminfo->b0_struct);
	if (forminfo->Plot->help_struct != NULL)
	    kfree(forminfo->Plot->help_struct);
	if (forminfo->Plot->quit_struct != NULL)
	    kfree(forminfo->Plot->quit_struct);
	if (forminfo->Plot->file->input_blank_struct != NULL)
	    kfree(forminfo->Plot->file->input_blank_struct);
	if (forminfo->Plot->file->help_struct != NULL)
	    kfree(forminfo->Plot->file->help_struct);
	kfree(forminfo->Plot->file->input_file);
	if (forminfo->Plot->file->input_file_struct != NULL)
	    kfree(forminfo->Plot->file->input_file_struct);
	if (forminfo->Plot->file->plot_where_struct != NULL)
	    kfree(forminfo->Plot->file->plot_where_struct);
	if (forminfo->Plot->file->object_type_struct != NULL)
	    kfree(forminfo->Plot->file->object_type_struct);
	kfree(forminfo->Plot->file);
	if (forminfo->Plot->file_struct != NULL)
	    kfree(forminfo->Plot->file_struct);

	if (forminfo->Plot->function->help_struct != NULL)
	    kfree(forminfo->Plot->function->help_struct);
	if (forminfo->Plot->function->plot_dim_struct != NULL)
	    kfree(forminfo->Plot->function->plot_dim_struct);
	kfree(forminfo->Plot->function->plot_dim_label);
	kfree(forminfo->Plot->function->func_3D);
	if (forminfo->Plot->function->func_3D_struct != NULL)
	    kfree(forminfo->Plot->function->func_3D_struct);
	kfree(forminfo->Plot->function->func_2D);
	if (forminfo->Plot->function->func_2D_struct != NULL)
	    kfree(forminfo->Plot->function->func_2D_struct);
	kfree(forminfo->Plot->function->x_min);
	if (forminfo->Plot->function->x_min_struct != NULL)
	    kfree(forminfo->Plot->function->x_min_struct);
	kfree(forminfo->Plot->function->x_max);
	if (forminfo->Plot->function->x_max_struct != NULL)
	    kfree(forminfo->Plot->function->x_max_struct);
	kfree(forminfo->Plot->function->xnum_pts);
	if (forminfo->Plot->function->xnum_pts_struct != NULL)
	    kfree(forminfo->Plot->function->xnum_pts_struct);
	kfree(forminfo->Plot->function->y_min);
	if (forminfo->Plot->function->y_min_struct != NULL)
	    kfree(forminfo->Plot->function->y_min_struct);
	kfree(forminfo->Plot->function->y_max);
	if (forminfo->Plot->function->y_max_struct != NULL)
	    kfree(forminfo->Plot->function->y_max_struct);
	kfree(forminfo->Plot->function->ynum_pts);
	if (forminfo->Plot->function->ynum_pts_struct != NULL)
	    kfree(forminfo->Plot->function->ynum_pts_struct);
	if (forminfo->Plot->function->where_plot_struct != NULL)
	    kfree(forminfo->Plot->function->where_plot_struct);
	if (forminfo->Plot->function->plot_function_struct != NULL)
	    kfree(forminfo->Plot->function->plot_function_struct);
	if (forminfo->Plot->function->func_3D_blk_struct != NULL)
	    kfree(forminfo->Plot->function->func_3D_blk_struct);
	if (forminfo->Plot->function->func_2D_blk_struct != NULL)
	    kfree(forminfo->Plot->function->func_2D_blk_struct);
	if (forminfo->Plot->function->blank1_struct != NULL)
	    kfree(forminfo->Plot->function->blank1_struct);
	if (forminfo->Plot->function->X_blk_struct != NULL)
	    kfree(forminfo->Plot->function->X_blk_struct);
	if (forminfo->Plot->function->Y_blk_struct != NULL)
	    kfree(forminfo->Plot->function->Y_blk_struct);
	kfree(forminfo->Plot->function);
	if (forminfo->Plot->function_struct != NULL)
	    kfree(forminfo->Plot->function_struct);

	if (forminfo->Plot->plot_control->help_struct != NULL)
	    kfree(forminfo->Plot->plot_control->help_struct);
	if (forminfo->Plot->plot_control->plot2d_type_struct != NULL)
	    kfree(forminfo->Plot->plot_control->plot2d_type_struct);
	if (forminfo->Plot->plot_control->plot3d_type_struct != NULL)
	    kfree(forminfo->Plot->plot_control->plot3d_type_struct);
	kfree(forminfo->Plot->plot_control);
	if (forminfo->Plot->plot_control_struct != NULL)
	    kfree(forminfo->Plot->plot_control_struct);


	if (forminfo->Plot_struct != NULL)
	    kfree(forminfo->Plot_struct);
	kfree(forminfo->Plot);
	if (forminfo->Options->options->help_struct != NULL)
	    kfree(forminfo->Options->options->help_struct);
	if (forminfo->Options->options->quit_struct != NULL)
	    kfree(forminfo->Options->options->quit_struct);
	if (forminfo->Options->options->area_list_struct != NULL)
	    kfree(forminfo->Options->options->area_list_struct);
	kfree(forminfo->Options->options->area_list_label);
	if (forminfo->Options->options->plot_list_struct != NULL)
	    kfree(forminfo->Options->options->plot_list_struct);
	kfree(forminfo->Options->options->plot_list_label);
	if (forminfo->Options->options->open_area_struct != NULL)
	    kfree(forminfo->Options->options->open_area_struct);
	if (forminfo->Options->options->open_plot_struct != NULL)
	    kfree(forminfo->Options->options->open_plot_struct);
	if (forminfo->Options->options->delete_area_struct != NULL)
	    kfree(forminfo->Options->options->delete_area_struct);
	if (forminfo->Options->options->delete_plot_struct != NULL)
	    kfree(forminfo->Options->options->delete_plot_struct);
	kfree(forminfo->Options->options);
	if (forminfo->Options->options_struct != NULL)
	    kfree(forminfo->Options->options_struct);


	if (forminfo->Options_struct != NULL)
	    kfree(forminfo->Options_struct);
	kfree(forminfo->Options);
	if (forminfo->Print->screen_dump->display_output_blank_struct != NULL)
	    kfree(forminfo->Print->screen_dump->display_output_blank_struct);
	if (forminfo->Print->screen_dump->help_struct != NULL)
	    kfree(forminfo->Print->screen_dump->help_struct);
	if (forminfo->Print->screen_dump->quit_struct != NULL)
	    kfree(forminfo->Print->screen_dump->quit_struct);
	if (forminfo->Print->screen_dump->dump_what_struct != NULL)
	    kfree(forminfo->Print->screen_dump->dump_what_struct);
	kfree(forminfo->Print->screen_dump->display_file);
	if (forminfo->Print->screen_dump->display_file_struct != NULL)
	    kfree(forminfo->Print->screen_dump->display_file_struct);
	kfree(forminfo->Print->screen_dump);
	if (forminfo->Print->screen_dump_struct != NULL)
	    kfree(forminfo->Print->screen_dump_struct);


	if (forminfo->Print_struct != NULL)
	    kfree(forminfo->Print_struct);
	kfree(forminfo->Print);
	if (forminfo->Colormap->colormap->help_struct != NULL)
	    kfree(forminfo->Colormap->colormap->help_struct);
	if (forminfo->Colormap->colormap->quit_struct != NULL)
	    kfree(forminfo->Colormap->colormap->quit_struct);
	if (forminfo->Colormap->colormap->wksp1_struct != NULL)
	    kfree(forminfo->Colormap->colormap->wksp1_struct);
	if (forminfo->Colormap->colormap->wksp2_struct != NULL)
	    kfree(forminfo->Colormap->colormap->wksp2_struct);
	if (forminfo->Colormap->colormap->b1_struct != NULL)
	    kfree(forminfo->Colormap->colormap->b1_struct);
	if (forminfo->Colormap->colormap->b2_struct != NULL)
	    kfree(forminfo->Colormap->colormap->b2_struct);
	kfree(forminfo->Colormap->colormap);
	if (forminfo->Colormap->colormap_struct != NULL)
	    kfree(forminfo->Colormap->colormap_struct);


	if (forminfo->Colormap_struct != NULL)
	    kfree(forminfo->Colormap_struct);
	kfree(forminfo->Colormap);
	if (forminfo->Deflts->deflts->help_struct != NULL)
	    kfree(forminfo->Deflts->deflts->help_struct);
	if (forminfo->Deflts->deflts->quit_struct != NULL)
	    kfree(forminfo->Deflts->deflts->quit_struct);
	if (forminfo->Deflts->deflts->new_plot_struct != NULL)
	    kfree(forminfo->Deflts->deflts->new_plot_struct);
	kfree(forminfo->Deflts->deflts->new_plot_label);
	if (forminfo->Deflts->deflts->display_title_struct != NULL)
	    kfree(forminfo->Deflts->deflts->display_title_struct);
	kfree(forminfo->Deflts->deflts->display_title_label);
	if (forminfo->Deflts->deflts->display_date_struct != NULL)
	    kfree(forminfo->Deflts->deflts->display_date_struct);
	kfree(forminfo->Deflts->deflts->display_date_label);
	kfree(forminfo->Deflts->deflts->background);
	if (forminfo->Deflts->deflts->background_struct != NULL)
	    kfree(forminfo->Deflts->deflts->background_struct);
	kfree(forminfo->Deflts->deflts->foreground);
	if (forminfo->Deflts->deflts->foreground_struct != NULL)
	    kfree(forminfo->Deflts->deflts->foreground_struct);
	kfree(forminfo->Deflts->deflts);
	if (forminfo->Deflts->deflts_struct != NULL)
	    kfree(forminfo->Deflts->deflts_struct);


	if (forminfo->Deflts_struct != NULL)
	    kfree(forminfo->Deflts_struct);
	kfree(forminfo->Deflts);
	kfree(forminfo);
}
