 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for putdata
   >>>> 
   >>>>    Written By: Mark Young
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 10, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _putdata_h_
#define _putdata_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <envision.h>
#include <xvinclude.h>

/* -include_includes */
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$ENVISION/objects/xvroutine/putdata/uis/putdata.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  input file (required infile)
 */
char	*i_file;	/* input file FILENAME */
int	 i_flag;	/* input file FLAG */

/*----- required ME group ----*/
/*
 *  displays the image, given image data (optional flag)
 */
int	 image_flag;  	/* displays the image, given image data FLAG */

/*
 *  displays the value data of the object (optional flag)
 */
int	 pixel_flag;  	/* displays the value data of the object FLAG */

/*
 *  displays an icon image, given image data (optional flag)
 */
int	 imageicon_flag;  	/* displays an icon image, given image data FLAG */

/*
 *  displays the map value data of the object (optional flag)
 */
int	 mapval_flag;  	/* displays the map value data of the object FLAG */

/*
 *  creates a 3D plot of the data (optional flag)
 */
int	 plot3d_flag;  	/* creates a 3D plot of the data FLAG */

/*
 *  zooms in on the data (optional flag)
 */
int	 zoom_flag;  	/* zooms in on the data FLAG */

/*
 *  displays the colormap of the object (optional flag)
 */
int	 palette_flag;  	/* displays the colormap of the object FLAG */

/*
 *  animates an image, given sequenced image data (optional flag)
 */
int	 animate_flag;  	/* animates an image, given sequenced image data FLAG */

	/*---- nested optional   group ----*/
/*
 *  creates a 2D plot of the data (optional flag)
 */
int	 plot2d_flag;  	/* creates a 2D plot of the data FLAG */

/*
 *  display 2D axes with 2D plot (optional flag)
 */
int	 axis2d_flag;  	/* display 2D axes with 2D plot FLAG */

	/*-- nested optional   group end --*/

/*-- required ME group end ---*/

/*
 *  input clip mask file (optional infile)
 */
char	*c_file;	/* input clip mask file FILENAME */
int	 c_flag;	/* input clip mask file FLAG */

/*
 *  input alternate cmap file (optional infile)
 */
char	*cmap_file;	/* input alternate cmap file FILENAME */
int	 cmap_flag;	/* input alternate cmap file FLAG */

/*
 *  use colormap? (optional logical)
 */
int	 use_cmap_logic;	/* use colormap? LOGIC */
int	 use_cmap_flag;  	/* use colormap? FLAG */

/*
 *  x location of GUI (optional integer)
 */
int	 x_int; 	/* x location of GUI INT */
int	 x_flag;	/* x location of GUI FLAG */

/*
 *  The window width (optional integer)
 */
int	 width_int; 	/* The window width INT */
int	 width_flag;	/* The window width FLAG */

/*
 *  y location of GUI (optional integer)
 */
int	 y_int; 	/* y location of GUI INT */
int	 y_flag;	/* y location of GUI FLAG */

/*
 *  The window height (optional integer)
 */
int	 height_int; 	/* The window height INT */
int	 height_flag;	/* The window height FLAG */

/*
 *  initial update time (optional float)
 */
float	 update_float;	/* initial update time FLOAT */
int	 update_flag;   	/* initial update time FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void putdata_get_args PROTO((kform *));
void putdata_usage_additions PROTO((void));
void putdata_free_args PROTO((int, kaddr));

/* -include_routines */
void create_putdata_workspace PROTO((void));
void quit_handler             PROTO((xvobject, kaddr, XEvent *));
void quit_callback            PROTO((xvobject, kaddr, kaddr));
void help_callback            PROTO((xvobject, kaddr, kaddr));
void menu_callback	      PROTO((xvobject, kaddr, kaddr));
int file_callback	      PROTO((xvobject, char *, kaddr));
/* -include_routines_end */

#endif
