 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for putdata
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "putdata.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - General Non-Interactive Data Display Functions
|
|       Purpose: main program for putdata
|
|         Input:
|		char *clui_info->i_file; {input file}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		Required M.E. group:
|		    int clui_info->image_flag; {TRUE if -image specified}
|
|		    int clui_info->pixel_flag; {TRUE if -pixel specified}
|
|		    int clui_info->imageicon_flag; {TRUE if -imageicon specified}
|
|		    int clui_info->mapval_flag; {TRUE if -mapval specified}
|
|		    int clui_info->plot3d_flag; {TRUE if -plot3d specified}
|
|		    int clui_info->zoom_flag; {TRUE if -zoom specified}
|
|		    int clui_info->palette_flag; {TRUE if -palette specified}
|
|		    int clui_info->animate_flag; {TRUE if -animate specified}
|
|		    Loose group:
|			int clui_info->plot2d_flag; {TRUE if -plot2d specified}
|
|			int clui_info->axis2d_flag; {TRUE if -axis2d specified}
|
|		char *clui_info->c_file; {input clip mask file}
|		int   clui_info->c_flag; {TRUE if -c specified}
|
|		char *clui_info->cmap_file; {input alternate cmap file}
|		int   clui_info->cmap_flag; {TRUE if -cmap specified}
|
|		int clui_info->use_cmap_logic; {use colormap?}
|		int clui_info->use_cmap_flag; {TRUE if -use_cmap specified}
|
|		int clui_info->x_int; {x location of GUI}
|		int clui_info->x_flag; {TRUE if -x specified}
|
|		int clui_info->width_int; {The window width}
|		int clui_info->width_flag; {TRUE if -width specified}
|
|		int clui_info->y_int; {y location of GUI}
|		int clui_info->y_flag; {TRUE if -y specified}
|
|		int clui_info->height_int; {The window height}
|		int clui_info->height_flag; {TRUE if -height specified}
|
|		float clui_info->update_float; {initial update time}
|		int   clui_info->update_flag; {TRUE if -update specified}
|
|        Output:
|       Returns:
|
|    Written By: Mark Young
|          Date: Apr 10, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "ENVISION");
	kexit_handler(putdata_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "ENVISION", "putdata",
		               putdata_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	putdata_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

	/*
	 * Initialize xvwidgets lib
	 */
	if (!(xvw_initialize(XVW_MENUS_XVFORMS)))
	{
	     kinfo(KSTANDARD, "Could not open connection to server");
	     kexit(KEXIT_FAILURE);
	}

/* -main_before_lib_call */
	create_putdata_workspace();
/* -main_before_lib_call_end */

/* -main_library_call */
	xvf_run_form();
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: putdata_usage_additions
| 
|       Purpose: Prints usage additions in putdata_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname putdata
|          Date: Apr 10, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void putdata_usage_additions(void)
{
	kfprintf(kstderr, "\tGeneral Non-Interactive Data Display Functions\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: putdata_free_args
| 
|       Purpose: Frees CLUI struct allocated in putdata_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname putdata
|          Date: Apr 10, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
putdata_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->c_file);
	kfree(clui_info->cmap_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
