 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "extractor.h"
/*-----------------------------------------------------------
| 
|  Routine Name: extractor_get_args
| 
|       Purpose: Gets command line args for extractor
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname extractor
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void extractor_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for extractor is out of sync with arguments specified in extractor's *.pane file; please rerun ghostwriter on extractor.";

	char  *value_string;


	/*
	 * allocate the extractor structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "extractor_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "extractor_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "policy", KVF_LIST_LABEL,
			  &(clui_info->policy_label),
			  &(clui_info->policy_flag)) &&
	      kclui_get_value(pane, "policy", KVF_LIST_VAL,
			  &(clui_info->policy_list),
			  &(clui_info->policy_flag))))
	{
	    kerror(NULL, "extractor_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_logical(pane, "disp",
			  &(clui_info->disp_logic),
			  &(clui_info->disp_flag))))
	{
	    kerror(NULL, "extractor_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_logical(pane, "mult",
			  &(clui_info->mult_logic),
			  &(clui_info->mult_flag))))
	{
	    kerror(NULL, "extractor_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "pres", KVF_LIST_LABEL,
			  &(clui_info->pres_label),
			  &(clui_info->pres_flag)) &&
	      kclui_get_value(pane, "pres", KVF_LIST_VAL,
			  &(clui_info->pres_list),
			  &(clui_info->pres_flag))))
	{
	    kerror(NULL, "extractor_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "shape", KVF_TOGGLE_VAL,
			  &value_string,
			  &(clui_info->shape_flag))))
	{
	    kerror(NULL, "extractor_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}
	else clui_info->shape_toggle = atoi(value_string);

	if (!(kclui_get_infile(pane, "form",
	                &(clui_info->form_file),
	                &(clui_info->form_flag))))
	{
	    kerror(NULL, "extractor_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}
	if (!(kclui_get_int(pane, "x",
	                &(clui_info->x_int),
	                &(clui_info->x_flag))))
	{
	    kerror(NULL, "extractor_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}
	if (!(kclui_get_int(pane, "y",
	                &(clui_info->y_int),
	                &(clui_info->y_flag))))
	{
	    kerror(NULL, "extractor_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

}



