 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Form Info Structure for extractor Form
   >>>> 
   >>>>    Written By: conductor -name extractor -l 3
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _form_info_h_
#define _form_info_h_

#include <xvinclude.h>

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

/*
 * Pane Info Struct for 'pane' Pane
 */
typedef struct _subform_pane{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

char         *i;         /* filename for 'i'*/
kform_struct *i_struct;  /* pass to xvf_set_attributes() */
int          i_selected; /* TRUE on <cr> for 'i' */

char         *o;         /* filename for 'o'*/
kform_struct *o_struct;  /* pass to xvf_set_attributes() */
int          o_selected; /* TRUE on <cr> for 'o' */

int          policy;          /* int value of 'policy'*/
char         *policy_label;   /* label representing int value of 'policy'*/
kform_struct *policy_struct;  /* pass to xvf_set_attributes() */
int          policy_selected; /* TRUE on <cr> for 'policy' */

int          disp;          /* boolean value of 'disp'*/
char         *disp_label;   /* label assoc w/ value of 'disp'*/
kform_struct *disp_struct;  /* pass to xvf_set_attributes() */
int          disp_selected; /* TRUE on <cr> for 'disp' */

int          mult;          /* boolean value of 'mult'*/
char         *mult_label;   /* label assoc w/ value of 'mult'*/
kform_struct *mult_struct;  /* pass to xvf_set_attributes() */
int          mult_selected; /* TRUE on <cr> for 'mult' */

int          pres;          /* int value of 'pres'*/
char         *pres_label;   /* label representing int value of 'pres'*/
kform_struct *pres_struct;  /* pass to xvf_set_attributes() */
int          pres_selected; /* TRUE on <cr> for 'pres' */

int          shape_val;      /* value of toggle 'shape'*/
int          shape_num;      /* number of toggle member selected (1-N) */
kform_struct *shape_struct;  /* pass to xvf_set_attributes() */
int          shape_selected; /* TRUE on <cr> for 'shape' */

int          mode_val;      /* value of toggle 'mode'*/
int          mode_num;      /* number of toggle member selected (1-N) */
kform_struct *mode_struct;  /* pass to xvf_set_attributes() */
int          mode_selected; /* TRUE on <cr> for 'mode' */

int          line_x1;          /* int for 'line_x1'*/
kform_struct *line_x1_struct;  /* pass to xvf_set_attributes() */

int          circle_x;          /* int for 'circle_x'*/
kform_struct *circle_x_struct;  /* pass to xvf_set_attributes() */

int          ellipse_x;          /* int for 'ellipse_x'*/
kform_struct *ellipse_x_struct;  /* pass to xvf_set_attributes() */

int          rect_x;          /* int for 'rect_x'*/
kform_struct *rect_x_struct;  /* pass to xvf_set_attributes() */

int          line_x2;          /* int for 'line_x2'*/
kform_struct *line_x2_struct;  /* pass to xvf_set_attributes() */

int          circle_radius;          /* int for 'circle_radius'*/
kform_struct *circle_radius_struct;  /* pass to xvf_set_attributes() */

int          ellipse_a;          /* int for 'ellipse_a'*/
kform_struct *ellipse_a_struct;  /* pass to xvf_set_attributes() */

int          rect_width;          /* int for 'rect_width'*/
kform_struct *rect_width_struct;  /* pass to xvf_set_attributes() */

int          extract;          /* TRUE when user clicks on 'extract'*/
kform_struct *extract_struct;  /* pass to xvf_set_attributes() */

int          line_y1;          /* int for 'line_y1'*/
kform_struct *line_y1_struct;  /* pass to xvf_set_attributes() */

int          circle_y;          /* int for 'circle_y'*/
kform_struct *circle_y_struct;  /* pass to xvf_set_attributes() */

int          ellipse_y;          /* int for 'ellipse_y'*/
kform_struct *ellipse_y_struct;  /* pass to xvf_set_attributes() */

int          rect_y;          /* int for 'rect_y'*/
kform_struct *rect_y_struct;  /* pass to xvf_set_attributes() */

int          line_y2;          /* int for 'line_y2'*/
kform_struct *line_y2_struct;  /* pass to xvf_set_attributes() */

int          ellipse_b;          /* int for 'ellipse_b'*/
kform_struct *ellipse_b_struct;  /* pass to xvf_set_attributes() */

int          rect_height;          /* int for 'rect_height'*/
kform_struct *rect_height_struct;  /* pass to xvf_set_attributes() */

} subform_pane;

/*
 * Subform Info Struct for 'subform' Subform
 */
typedef struct _form_subform {

subform_pane  *pane;          /* ptr to Pane Info struct for pane 'pane' */
int          pane_selected;          /* TRUE if input was from pane 'pane' */
kform_struct *pane_struct;          /* pass to xvf_set_attributes() */

}  form_subform;

/*
 * Form Info Struct for 'form' form
 */
typedef struct _gui_info_struct {

kform_struct *license_struct; /* pass to xvf_set_attributes() */

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Quit' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

xvobject     wksp;          /* address of workspace 'wksp'*/
kform_struct *wksp_struct;  /* pass to xvf_set_attributes() */

kform_struct *blank1_struct; /* pass to xvf_set_attributes() */

form_subform  *subform;
int subform_selected;
kform_struct *subform_struct;


kform_struct *form_struct;


 } gui_info_struct; 

        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void _xvf_free_form PROTO((gui_info_struct *));
void _xvf_get_form  PROTO((gui_info_struct *));

int  _xvf_init_form PROTO((kform *, gui_info_struct *));
void run_form       PROTO((kform *, ksubform *, kaddr));

void run_subform      PROTO((form_subform *));
void _xvf_get_subform PROTO((form_subform *));

void run_pane      PROTO((subform_pane *));
void _xvf_get_pane PROTO((subform_pane *));
void pane_i	PROTO((subform_pane *));
void pane_o	PROTO((subform_pane *));
void pane_policy	PROTO((subform_pane *));
void pane_disp	PROTO((subform_pane *));
void pane_mult	PROTO((subform_pane *));
void pane_pres	PROTO((subform_pane *));
void pane_shape	PROTO((subform_pane *));
void pane_mode	PROTO((subform_pane *));
void pane_extract	PROTO((subform_pane *));




#endif /* _form_info_h_ */ 
/* Don't add after this point */
