 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for extractor
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "extractor.h"

clui_info_struct *clui_info = NULL;

gui_info_struct *gui_info;

/*-----------------------------------------------------------
|
|  Routine Name: main() - interactive image ROI extraction
|
|       Purpose: main program for extractor
|
|         Input:
|		char *clui_info->i_file; {input image from which to extract ROI}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {output image in which to save ROI}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		int   clui_info->policy_list; {ROI extraction policy}
|		char *clui_info->policy_label;
|		int   clui_info->policy_flag; {TRUE if -policy specified}
|
|		int clui_info->disp_logic; {display extracted ROI in separate window}
|		int clui_info->disp_flag; {TRUE if -disp specified}
|
|		int clui_info->mult_logic; {extract multiple ROIs from the same window}
|		int clui_info->mult_flag; {TRUE if -mult specified}
|
|		int   clui_info->pres_list; {ROI presentation}
|		char *clui_info->pres_label;
|		int   clui_info->pres_flag; {TRUE if -pres specified}
|
|		int clui_info->shape_toggle; {specifies desired shape for ROI}
|		int clui_info->shape_flag; {TRUE if -shape specified}
|
|        Output:
|       Returns:
|
|    Written By: 
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *form;            /* form tree representing *.form file */
	char   *form_filestring; /* *.form file for extractor    */ 
	char   *form_pathname;   /* location of extractor.form   */
	char   *form_fullpath;   /* expanded extractor.form path */
	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "ENVISION");
	kexit_handler(extractor_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_XVROUTINE, "ENVISION", "extractor",
		extractor_usage_additions);

	extractor_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

	/*
	 * Initialize xvwidgets lib
	 */
	if (!(xvw_initialize(XVW_MENUS_XVFORMS)))
	{
	     kinfo(KSTANDARD, "Could not open connection to server");
	     kexit(KEXIT_FAILURE);
	}

	/*
	 * Set location of extractor.form
	 */
	if (clui_info->form_flag)
	{
	    form_filestring = kstrdup(clui_info->form_file);
	    form_pathname   = NULL;
	}
	else
	{
	    form_filestring = kstrdup("extractor.form");
	    form_pathname   = kstrdup("$TOOLBOX/objects/xvroutine/extractor/uis");
	}
	form_fullpath   = kfullpath(form_filestring, form_pathname, NULL);

	/*
	 * Allocate the GUI Info structure 
	 */
	gui_info = (gui_info_struct *)
				kcalloc (1, sizeof (gui_info_struct));
	/*
	 * Create the forms for extractor 
	 */
	form = xvf_create_form(form_fullpath, NONE, run_form, gui_info,
				clui_info->x_int, clui_info->y_int,
				XVF_PARTIAL_EDIT);
	if (form == NULL)
	   kexit(KEXIT_FAILURE);

	/*
	 * Initialize the GUI Info structure 
	 */
	if (!(_xvf_init_form(form, gui_info)))
	    kexit(KEXIT_FAILURE);

/* -main_before_lib_call */
	/*
	 *  create the image object
	 */
	image    = xvw_create_image(gui_info->wksp, "image");
	xvw_set_attribute(image, XVW_IMAGE_IMAGEFILE, clui_info->i_file);

	/*
	 *  create the position object underneath the image object
	 */
	position = xvw_create_position(gui_info->wksp, "position");
	xvw_set_attributes(position,
			   XVW_BELOW,             image,
			   XVW_LEFT_OF,           NULL,
			   XVW_RIGHT_OF,          NULL,
                           XVW_POSITION_FILENAME, clui_info->i_file,
			   NULL);

	panicon = xvw_create_panicon(gui_info->wksp, "panicon");
        xvw_set_attributes(panicon,
                XVW_BELOW,           NULL,
                XVW_RIGHT_OF,        NULL,
                XVW_IMAGE_IMAGEFILE, clui_info->i_file,
                NULL);
	/*
	 *  adjust GUI according to CLUI arguments, and start
	 */
	startup_from_clui();
/* -main_before_lib_call_end */

/* -main_library_call */
	xvf_run_form();
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */

	kfree(form_filestring);
	kfree(form_pathname);
	kfree(form_fullpath);

	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: extractor_usage_additions
| 
|       Purpose: Prints usage additions in extractor_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname extractor
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void extractor_usage_additions(void)
{
	kfprintf(kstderr, "\tinteractive image ROI extraction\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: extractor_free_args
| 
|       Purpose: Frees CLUI struct allocated in extractor_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname extractor
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
extractor_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
		kfree(clui_info->form_file);
	kfree(clui_info->o_file);
	kfree(clui_info->policy_label);
	kfree(clui_info->pres_label);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
