 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	FormInfo Extraction Routines
   >>>> 
   >>>>  Private: 
   >>>> 	_xvf_get_editimage
   >>>> 
   >>>>   Static: 
   >>>> 	_xvf_get_File
   >>>> 	_xvf_get_file
   >>>> 	_xvf_get_options
   >>>> 	_xvf_get_capture
   >>>> 	_xvf_get_lists
   >>>> 	_xvf_get_display
   >>>> 	_xvf_get_comment
   >>>> 	_xvf_get_colormap
   >>>> 	_xvf_get_roi
   >>>> 	_xvf_get_function
   >>>> 	_xvf_get_Zoom
   >>>> 	_xvf_get_zoom
   >>>> 	_xvf_get_Pixel
   >>>> 	_xvf_get_pixel
   >>>> 	_xvf_get_MapValues
   >>>> 	_xvf_get_mapvals
   >>>> 	_xvf_get_Pseudo
   >>>> 	_xvf_get_pseudo
   >>>> 	_xvf_get_Thresh
   >>>> 	_xvf_get_thresh
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "editimage.h"


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_editimage
| 
|       Purpose: Extracts information from GUI
| 
|         Input: forminfo - pointer to gui_info_struct
| 
|        Output: none
|    Written By: conductor -name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_editimage(
     gui_info_struct *forminfo)
{
	kselection *selection;
	ksubform   *subform;
	if (forminfo->quit_struct != NULL)
	{
	    selection = forminfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->quit));

	}

	if (forminfo->workspace_struct != NULL)
	{
	    selection = forminfo->workspace_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_WORKSPACE,
	                    &(forminfo->workspace));
	    }

	}

	if (forminfo->File_struct != NULL)
	{
	    subform = forminfo->File_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->File_selected));
	    _xvf_get_File(forminfo->File);

	}
	if (forminfo->options_struct != NULL)
	{
	    subform = forminfo->options_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->options_selected));
	    _xvf_get_options(forminfo->options);

	}
	if (forminfo->Zoom_struct != NULL)
	{
	    subform = forminfo->Zoom_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->Zoom_selected));
	    _xvf_get_Zoom(forminfo->Zoom);

	}
	if (forminfo->Pixel_struct != NULL)
	{
	    subform = forminfo->Pixel_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->Pixel_selected));
	    _xvf_get_Pixel(forminfo->Pixel);

	}
	if (forminfo->MapValues_struct != NULL)
	{
	    subform = forminfo->MapValues_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->MapValues_selected));
	    _xvf_get_MapValues(forminfo->MapValues);

	}
	if (forminfo->Pseudo_struct != NULL)
	{
	    subform = forminfo->Pseudo_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->Pseudo_selected));
	    _xvf_get_Pseudo(forminfo->Pseudo);

	}
	if (forminfo->Thresh_struct != NULL)
	{
	    subform = forminfo->Thresh_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->Thresh_selected));
	    _xvf_get_Thresh(forminfo->Thresh);

	}

}

/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_File
| 
|       Purpose: Extracts information from File subform
| 
|         Input: subforminfo - pointer to editimage_File structure
| 
|        Output: none
|    Written By: conductor -name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_File(
     editimage_File *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->file_struct != NULL)
	{
	    pane = subforminfo->file_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->file_selected));
	    _xvf_get_file(subforminfo->file);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_file
| 
|       Purpose: Extracts information from file pane
| 
|         Input: paneinfo - pointer to File_file structure
| 
|        Output: none
|    Written By: conductor -name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_file(
     File_file *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'editimage->File->file' Pane Info structure
	 */

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->i_struct != NULL)
	{
	    selection = paneinfo->i_struct->Selptr;
	    if (selection->modified)
	    {
		if (paneinfo->i != NULL) kfree(paneinfo->i);
		kvf_get_attribute(selection->back_kformstruct, KVF_FILE_NAME,
		                  &(paneinfo->i));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->i_selected));
	    }
	}

	if (paneinfo->c_struct != NULL)
	{
	    selection = paneinfo->c_struct->Selptr;
	    if (selection->modified)
	    {
		if (paneinfo->c != NULL) kfree(paneinfo->c);
		kvf_get_attribute(selection->back_kformstruct, KVF_FILE_NAME,
		                  &(paneinfo->c));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->c_selected));
	    }
	}

	if (paneinfo->cmap_struct != NULL)
	{
	    selection = paneinfo->cmap_struct->Selptr;
	    if (selection->modified)
	    {
		if (paneinfo->cmap != NULL) kfree(paneinfo->cmap);
		kvf_get_attribute(selection->back_kformstruct, KVF_FILE_NAME,
		                  &(paneinfo->cmap));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->cmap_selected));
	    }
	}

	if (paneinfo->format_struct != NULL)
	{
	    selection = paneinfo->format_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_VAL,
	                    &(paneinfo->format));
	    if (paneinfo->format_label != NULL) kfree(paneinfo->format_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_LABEL,
	                    &(paneinfo->format_label));
	    }

	}

	if (paneinfo->o_struct != NULL)
	{
	    selection = paneinfo->o_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->o != NULL) kfree(paneinfo->o);
	    kvf_get_attribute(selection->back_kformstruct, KVF_FILE_NAME,
	                    &(paneinfo->o));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->o_selected));
	    }
	}

	if (paneinfo->out_cmap_struct != NULL)
	{
	    selection = paneinfo->out_cmap_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->out_cmap != NULL) kfree(paneinfo->out_cmap);
	    kvf_get_attribute(selection->back_kformstruct, KVF_FILE_NAME,
	                    &(paneinfo->out_cmap));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->out_cmap_selected));
	    }
	}

	if (paneinfo->d_struct != NULL)
	{
	    selection = paneinfo->d_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->d != NULL) kfree(paneinfo->d);
	    kvf_get_attribute(selection->back_kformstruct, KVF_FILE_NAME,
	                    &(paneinfo->d));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->d_selected));
	    }
	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_options
| 
|       Purpose: Extracts information from options subform
| 
|         Input: subforminfo - pointer to editimage_options structure
| 
|        Output: none
|    Written By: conductor -name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_options(
     editimage_options *subforminfo)
{
	kselection *selection;
	kcontrol   *pane;
	if (subforminfo->quit_struct != NULL)
	{
	    selection = subforminfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->quit));

	}

	if (subforminfo->capture_struct != NULL)
	{
	    pane = subforminfo->capture_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->capture_selected));
	    _xvf_get_capture(subforminfo->capture);
	}

	if (subforminfo->lists_struct != NULL)
	{
	    pane = subforminfo->lists_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->lists_selected));
	    _xvf_get_lists(subforminfo->lists);
	}

	if (subforminfo->display_struct != NULL)
	{
	    pane = subforminfo->display_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->display_selected));
	    _xvf_get_display(subforminfo->display);
	}

	if (subforminfo->comment_struct != NULL)
	{
	    pane = subforminfo->comment_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->comment_selected));
	    _xvf_get_comment(subforminfo->comment);
	}

	if (subforminfo->colormap_struct != NULL)
	{
	    pane = subforminfo->colormap_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->colormap_selected));
	    _xvf_get_colormap(subforminfo->colormap);
	}

	if (subforminfo->roi_struct != NULL)
	{
	    pane = subforminfo->roi_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->roi_selected));
	    _xvf_get_roi(subforminfo->roi);
	}

	if (subforminfo->function_struct != NULL)
	{
	    pane = subforminfo->function_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->function_selected));
	    _xvf_get_function(subforminfo->function);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_capture
| 
|       Purpose: Extracts information from capture pane
| 
|         Input: paneinfo - pointer to options_capture structure
| 
|        Output: none
|    Written By: conductor -name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_capture(
     options_capture *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'editimage->options->capture' Pane Info structure
	 */

	if (paneinfo->all_struct != NULL)
	{
	   selection = paneinfo->all_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->all));
	    }

	}

	if (paneinfo->decor_struct != NULL)
	{
	   selection = paneinfo->decor_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->decor));
	    }

	}

	if (paneinfo->b_struct != NULL)
	{
	   selection = paneinfo->b_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->b));
	    }

	}

	if (paneinfo->o_struct != NULL)
	{
	    selection = paneinfo->o_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->o != NULL) kfree(paneinfo->o);
	    kvf_get_attribute(selection->back_kformstruct, KVF_FILE_NAME,
	                    &(paneinfo->o));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->o_selected));
	    }
	}

	if (paneinfo->capture_struct != NULL)
	{
	    selection = paneinfo->capture_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->capture));

	}

	if (paneinfo->screen_struct != NULL)
	{
	   selection = paneinfo->screen_struct->Selptr;
	    if (selection->modified || selection->back_group->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->screen));
	    }

	}

	if (paneinfo->win_struct != NULL)
	{
	   selection = paneinfo->win_struct->Selptr;
	    if (selection->modified || selection->back_group->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->win));
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_lists
| 
|       Purpose: Extracts information from lists pane
| 
|         Input: paneinfo - pointer to options_lists structure
| 
|        Output: none
|    Written By: conductor -name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_lists(
     options_lists *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'editimage->options->lists' Pane Info structure
	 */

	if (paneinfo->image_list_struct != NULL)
	{
	    selection = paneinfo->image_list_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_VAL,
	                    &(paneinfo->image_list));
	    if (paneinfo->image_list_label != NULL) kfree(paneinfo->image_list_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_LABEL,
	                    &(paneinfo->image_list_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->image_list_selected));
	    }

	}

	if (paneinfo->band_list_struct != NULL)
	{
	    selection = paneinfo->band_list_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_VAL,
	                    &(paneinfo->band_list));
	    if (paneinfo->band_list_label != NULL) kfree(paneinfo->band_list_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_LABEL,
	                    &(paneinfo->band_list_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->band_list_selected));
	    }

	}

	if (paneinfo->elements_struct != NULL)
	{
	   selection = paneinfo->elements_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->elements));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->elements_selected));
	    }

	}

	if (paneinfo->depth_struct != NULL)
	{
	   selection = paneinfo->depth_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->depth));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->depth_selected));
	    }

	}

	if (paneinfo->time_struct != NULL)
	{
	   selection = paneinfo->time_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->time));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->time_selected));
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_display
| 
|       Purpose: Extracts information from display pane
| 
|         Input: paneinfo - pointer to options_display structure
| 
|        Output: none
|    Written By: conductor -name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_display(
     options_display *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'editimage->options->display' Pane Info structure
	 */

	if (paneinfo->norm_type_struct != NULL)
	{
	    selection = paneinfo->norm_type_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_CYCLE_VAL,
	                    &(paneinfo->norm_type));
	    if (paneinfo->norm_type_label != NULL) kfree(paneinfo->norm_type_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_CYCLE_LABEL,
	                    &(paneinfo->norm_type_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->norm_type_selected));
	    }

	}

	if (paneinfo->norm_method_struct != NULL)
	{
	    char *value_string;
	    selection = paneinfo->norm_method_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_NUM,
	                    &(paneinfo->norm_method_num));
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_VAL,
	                    &(value_string));
	    paneinfo->norm_method_val = atoi(value_string);
	    kfree(value_string);
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->norm_method_selected));
	    }

	}

	if (paneinfo->red_mapcol_struct != NULL)
	{
	    selection = paneinfo->red_mapcol_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->red_mapcol));

	}

	if (paneinfo->green_mapcol_struct != NULL)
	{
	    selection = paneinfo->green_mapcol_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->green_mapcol));

	}

	if (paneinfo->blue_mapcol_struct != NULL)
	{
	    selection = paneinfo->blue_mapcol_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->blue_mapcol));

	}

	if (paneinfo->red_function_struct != NULL)
	{
	    selection = paneinfo->red_function_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->red_function != NULL) kfree(paneinfo->red_function);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->red_function));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->red_function_selected));
	    }

	}

	if (paneinfo->green_function_struct != NULL)
	{
	    selection = paneinfo->green_function_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->green_function != NULL) kfree(paneinfo->green_function);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->green_function));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->green_function_selected));
	    }

	}

	if (paneinfo->blue_function_struct != NULL)
	{
	    selection = paneinfo->blue_function_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->blue_function != NULL) kfree(paneinfo->blue_function);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->blue_function));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->blue_function_selected));
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_comment
| 
|       Purpose: Extracts information from comment pane
| 
|         Input: paneinfo - pointer to options_comment structure
| 
|        Output: none
|    Written By: conductor -name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_comment(
     options_comment *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'editimage->options->comment' Pane Info structure
	 */

	if (paneinfo->comment_string_struct != NULL)
	{
	    selection = paneinfo->comment_string_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->comment_string != NULL) kfree(paneinfo->comment_string);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->comment_string));
	    }

	}

	if (paneinfo->change_comment_struct != NULL)
	{
	    selection = paneinfo->change_comment_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->change_comment));

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_colormap
| 
|       Purpose: Extracts information from colormap pane
| 
|         Input: paneinfo - pointer to options_colormap structure
| 
|        Output: none
|    Written By: conductor -name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_colormap(
     options_colormap *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'editimage->options->colormap' Pane Info structure
	 */

	if (paneinfo->wksp1_struct != NULL)
	{
	    selection = paneinfo->wksp1_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_WORKSPACE,
	                    &(paneinfo->wksp1));
	    }

	}

	if (paneinfo->wksp2_struct != NULL)
	{
	    selection = paneinfo->wksp2_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_WORKSPACE,
	                    &(paneinfo->wksp2));
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_roi
| 
|       Purpose: Extracts information from roi pane
| 
|         Input: paneinfo - pointer to options_roi structure
| 
|        Output: none
|    Written By: conductor -name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_roi(
     options_roi *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'editimage->options->roi' Pane Info structure
	 */

	if (paneinfo->o_struct != NULL)
	{
	    selection = paneinfo->o_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->o != NULL) kfree(paneinfo->o);
	    kvf_get_attribute(selection->back_kformstruct, KVF_FILE_NAME,
	                    &(paneinfo->o));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->o_selected));
	    }
	}

	if (paneinfo->policy_struct != NULL)
	{
	    selection = paneinfo->policy_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_VAL,
	                    &(paneinfo->policy));
	    if (paneinfo->policy_label != NULL) kfree(paneinfo->policy_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_LABEL,
	                    &(paneinfo->policy_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->policy_selected));
	    }

	}

	if (paneinfo->disp_struct != NULL)
	{
	   selection = paneinfo->disp_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_VAL,
	                    &(paneinfo->disp));
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_LABEL,
	                    &(paneinfo->disp_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->disp_selected));
	    }

	}

	if (paneinfo->mult_struct != NULL)
	{
	   selection = paneinfo->mult_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_VAL,
	                    &(paneinfo->mult));
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_LABEL,
	                    &(paneinfo->mult_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->mult_selected));
	    }

	}

	if (paneinfo->pres_struct != NULL)
	{
	    selection = paneinfo->pres_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_VAL,
	                    &(paneinfo->pres));
	    if (paneinfo->pres_label != NULL) kfree(paneinfo->pres_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_LABEL,
	                    &(paneinfo->pres_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->pres_selected));
	    }

	}

	if (paneinfo->shape_struct != NULL)
	{
	    char *value_string;
	    selection = paneinfo->shape_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_NUM,
	                    &(paneinfo->shape_num));
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_VAL,
	                    &(value_string));
	    paneinfo->shape_val = atoi(value_string);
	    kfree(value_string);
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->shape_selected));
	    }

	}

	if (paneinfo->mode_struct != NULL)
	{
	    char *value_string;
	    selection = paneinfo->mode_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_NUM,
	                    &(paneinfo->mode_num));
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_VAL,
	                    &(value_string));
	    paneinfo->mode_val = atoi(value_string);
	    kfree(value_string);
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->mode_selected));
	    }

	}

	if (paneinfo->line_x1_struct != NULL)
	{
	    selection = paneinfo->line_x1_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->line_x1));
	    }
	}

	if (paneinfo->circle_x_struct != NULL)
	{
	    selection = paneinfo->circle_x_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->circle_x));
	    }
	}

	if (paneinfo->ellipse_x_struct != NULL)
	{
	    selection = paneinfo->ellipse_x_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->ellipse_x));
	    }
	}

	if (paneinfo->rect_x_struct != NULL)
	{
	    selection = paneinfo->rect_x_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->rect_x));
	    }
	}

	if (paneinfo->line_x2_struct != NULL)
	{
	    selection = paneinfo->line_x2_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->line_x2));
	    }
	}

	if (paneinfo->circle_radius_struct != NULL)
	{
	    selection = paneinfo->circle_radius_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->circle_radius));
	    }
	}

	if (paneinfo->ellipse_a_struct != NULL)
	{
	    selection = paneinfo->ellipse_a_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->ellipse_a));
	    }
	}

	if (paneinfo->rect_width_struct != NULL)
	{
	    selection = paneinfo->rect_width_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->rect_width));
	    }
	}

	if (paneinfo->extract_roi_struct != NULL)
	{
	    selection = paneinfo->extract_roi_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->extract_roi));

	}

	if (paneinfo->line_y1_struct != NULL)
	{
	    selection = paneinfo->line_y1_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->line_y1));
	    }
	}

	if (paneinfo->circle_y_struct != NULL)
	{
	    selection = paneinfo->circle_y_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->circle_y));
	    }
	}

	if (paneinfo->ellipse_y_struct != NULL)
	{
	    selection = paneinfo->ellipse_y_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->ellipse_y));
	    }
	}

	if (paneinfo->rect_y_struct != NULL)
	{
	    selection = paneinfo->rect_y_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->rect_y));
	    }
	}

	if (paneinfo->line_y2_struct != NULL)
	{
	    selection = paneinfo->line_y2_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->line_y2));
	    }
	}

	if (paneinfo->ellipse_b_struct != NULL)
	{
	    selection = paneinfo->ellipse_b_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->ellipse_b));
	    }
	}

	if (paneinfo->rect_height_struct != NULL)
	{
	    selection = paneinfo->rect_height_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->rect_height));
	    }
	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_function
| 
|       Purpose: Extracts information from function pane
| 
|         Input: paneinfo - pointer to options_function structure
| 
|        Output: none
|    Written By: conductor -name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_function(
     options_function *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'editimage->options->function' Pane Info structure
	 */

	if (paneinfo->create_struct != NULL)
	{
	    selection = paneinfo->create_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->create));

	}

	if (paneinfo->expr_struct != NULL)
	{
	    selection = paneinfo->expr_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->expr != NULL) kfree(paneinfo->expr);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->expr));
	    }

	}

	if (paneinfo->wbegin_struct != NULL)
	{
	    selection = paneinfo->wbegin_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_DOUBLE_VAL,
	                    &(paneinfo->wbegin));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->wbegin_optsel));
	    }

	}

	if (paneinfo->wend_struct != NULL)
	{
	    selection = paneinfo->wend_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_DOUBLE_VAL,
	                    &(paneinfo->wend));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->wend_optsel));
	    }

	}

	if (paneinfo->wsize_struct != NULL)
	{
	    selection = paneinfo->wsize_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->wsize));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->wsize_optsel));
	    }
	}

	if (paneinfo->hbegin_struct != NULL)
	{
	    selection = paneinfo->hbegin_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_DOUBLE_VAL,
	                    &(paneinfo->hbegin));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->hbegin_optsel));
	    }

	}

	if (paneinfo->hend_struct != NULL)
	{
	    selection = paneinfo->hend_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_DOUBLE_VAL,
	                    &(paneinfo->hend));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->hend_optsel));
	    }

	}

	if (paneinfo->hsize_struct != NULL)
	{
	    selection = paneinfo->hsize_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->hsize));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->hsize_optsel));
	    }
	}

	if (paneinfo->dbegin_struct != NULL)
	{
	    selection = paneinfo->dbegin_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_DOUBLE_VAL,
	                    &(paneinfo->dbegin));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->dbegin_optsel));
	    }

	}

	if (paneinfo->dend_struct != NULL)
	{
	    selection = paneinfo->dend_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_DOUBLE_VAL,
	                    &(paneinfo->dend));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->dend_optsel));
	    }

	}

	if (paneinfo->dsize_struct != NULL)
	{
	    selection = paneinfo->dsize_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->dsize));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->dsize_optsel));
	    }
	}

	if (paneinfo->tbegin_struct != NULL)
	{
	    selection = paneinfo->tbegin_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_DOUBLE_VAL,
	                    &(paneinfo->tbegin));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->tbegin_optsel));
	    }

	}

	if (paneinfo->tend_struct != NULL)
	{
	    selection = paneinfo->tend_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_DOUBLE_VAL,
	                    &(paneinfo->tend));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->tend_optsel));
	    }

	}

	if (paneinfo->tsize_struct != NULL)
	{
	    selection = paneinfo->tsize_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->tsize));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->tsize_optsel));
	    }
	}

	if (paneinfo->ebegin_struct != NULL)
	{
	    selection = paneinfo->ebegin_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_DOUBLE_VAL,
	                    &(paneinfo->ebegin));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->ebegin_optsel));
	    }

	}

	if (paneinfo->eend_struct != NULL)
	{
	    selection = paneinfo->eend_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_DOUBLE_VAL,
	                    &(paneinfo->eend));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->eend_optsel));
	    }

	}

	if (paneinfo->esize_struct != NULL)
	{
	    selection = paneinfo->esize_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->esize));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->esize_optsel));
	    }
	}

	if (paneinfo->type_struct != NULL)
	{
	    selection = paneinfo->type_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_VAL,
	                    &(paneinfo->type));
	    if (paneinfo->type_label != NULL) kfree(paneinfo->type_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_LABEL,
	                    &(paneinfo->type_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_OPTSEL,
	                    &(paneinfo->type_optsel));
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_Zoom
| 
|       Purpose: Extracts information from Zoom subform
| 
|         Input: subforminfo - pointer to editimage_Zoom structure
| 
|        Output: none
|    Written By: conductor -name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_Zoom(
     editimage_Zoom *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->zoom_struct != NULL)
	{
	    pane = subforminfo->zoom_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->zoom_selected));
	    _xvf_get_zoom(subforminfo->zoom);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_zoom
| 
|       Purpose: Extracts information from zoom pane
| 
|         Input: paneinfo - pointer to Zoom_zoom structure
| 
|        Output: none
|    Written By: conductor -name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_zoom(
     Zoom_zoom *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'editimage->Zoom->zoom' Pane Info structure
	 */

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->zoomfactor_struct != NULL)
	{
	    selection = paneinfo->zoomfactor_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_FLOAT_VAL,
	                    &(paneinfo->zoomfactor));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->zoomfactor_selected));
	    }

	}

	if (paneinfo->update_mode_struct != NULL)
	{
	   selection = paneinfo->update_mode_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_VAL,
	                    &(paneinfo->update_mode));
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_LABEL,
	                    &(paneinfo->update_mode_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->update_mode_selected));
	    }

	}

	if (paneinfo->zoom_object_struct != NULL)
	{
	    selection = paneinfo->zoom_object_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_WORKSPACE,
	                    &(paneinfo->zoom_object));
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_Pixel
| 
|       Purpose: Extracts information from Pixel subform
| 
|         Input: subforminfo - pointer to editimage_Pixel structure
| 
|        Output: none
|    Written By: conductor -name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_Pixel(
     editimage_Pixel *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->pixel_struct != NULL)
	{
	    pane = subforminfo->pixel_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->pixel_selected));
	    _xvf_get_pixel(subforminfo->pixel);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_pixel
| 
|       Purpose: Extracts information from pixel pane
| 
|         Input: paneinfo - pointer to Pixel_pixel structure
| 
|        Output: none
|    Written By: conductor -name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_pixel(
     Pixel_pixel *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'editimage->Pixel->pixel' Pane Info structure
	 */

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->update_mode_struct != NULL)
	{
	   selection = paneinfo->update_mode_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_VAL,
	                    &(paneinfo->update_mode));
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_LABEL,
	                    &(paneinfo->update_mode_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->update_mode_selected));
	    }

	}

	if (paneinfo->pixel_object_struct != NULL)
	{
	    selection = paneinfo->pixel_object_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_WORKSPACE,
	                    &(paneinfo->pixel_object));
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_MapValues
| 
|       Purpose: Extracts information from MapValues subform
| 
|         Input: subforminfo - pointer to editimage_MapValues structure
| 
|        Output: none
|    Written By: conductor -name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_MapValues(
     editimage_MapValues *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->mapvals_struct != NULL)
	{
	    pane = subforminfo->mapvals_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->mapvals_selected));
	    _xvf_get_mapvals(subforminfo->mapvals);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_mapvals
| 
|       Purpose: Extracts information from mapvals pane
| 
|         Input: paneinfo - pointer to MapValues_mapvals structure
| 
|        Output: none
|    Written By: conductor -name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_mapvals(
     MapValues_mapvals *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'editimage->MapValues->mapvals' Pane Info structure
	 */

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->update_mode_struct != NULL)
	{
	   selection = paneinfo->update_mode_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_VAL,
	                    &(paneinfo->update_mode));
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_LABEL,
	                    &(paneinfo->update_mode_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->update_mode_selected));
	    }

	}

	if (paneinfo->policy_struct != NULL)
	{
	    selection = paneinfo->policy_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_CYCLE_VAL,
	                    &(paneinfo->policy));
	    if (paneinfo->policy_label != NULL) kfree(paneinfo->policy_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_CYCLE_LABEL,
	                    &(paneinfo->policy_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->policy_selected));
	    }

	}

	if (paneinfo->display_width_struct != NULL)
	{
	    selection = paneinfo->display_width_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->display_width));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->display_width_selected));
	    }
	}

	if (paneinfo->display_height_struct != NULL)
	{
	    selection = paneinfo->display_height_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->display_height));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->display_height_selected));
	    }
	}

	if (paneinfo->mapval_object_struct != NULL)
	{
	    selection = paneinfo->mapval_object_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_WORKSPACE,
	                    &(paneinfo->mapval_object));
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_Pseudo
| 
|       Purpose: Extracts information from Pseudo subform
| 
|         Input: subforminfo - pointer to editimage_Pseudo structure
| 
|        Output: none
|    Written By: conductor -name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_Pseudo(
     editimage_Pseudo *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->pseudo_struct != NULL)
	{
	    pane = subforminfo->pseudo_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->pseudo_selected));
	    _xvf_get_pseudo(subforminfo->pseudo);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_pseudo
| 
|       Purpose: Extracts information from pseudo pane
| 
|         Input: paneinfo - pointer to Pseudo_pseudo structure
| 
|        Output: none
|    Written By: conductor -name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_pseudo(
     Pseudo_pseudo *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'editimage->Pseudo->pseudo' Pane Info structure
	 */

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->palette_type_struct != NULL)
	{
	    char *value_string;
	    selection = paneinfo->palette_type_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_NUM,
	                    &(paneinfo->palette_type_num));
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_VAL,
	                    &(value_string));
	    paneinfo->palette_type_val = atoi(value_string);
	    kfree(value_string);
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->palette_type_selected));
	    }

	}

	if (paneinfo->pseudo_object_struct != NULL)
	{
	    selection = paneinfo->pseudo_object_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_WORKSPACE,
	                    &(paneinfo->pseudo_object));
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_Thresh
| 
|       Purpose: Extracts information from Thresh subform
| 
|         Input: subforminfo - pointer to editimage_Thresh structure
| 
|        Output: none
|    Written By: conductor -name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_Thresh(
     editimage_Thresh *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->thresh_struct != NULL)
	{
	    pane = subforminfo->thresh_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->thresh_selected));
	    _xvf_get_thresh(subforminfo->thresh);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_thresh
| 
|       Purpose: Extracts information from thresh pane
| 
|         Input: paneinfo - pointer to Thresh_thresh structure
| 
|        Output: none
|    Written By: conductor -name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_thresh(
     Thresh_thresh *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'editimage->Thresh->thresh' Pane Info structure
	 */

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->thresholding_struct != NULL)
	{
	    char *value_string;
	    selection = paneinfo->thresholding_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_NUM,
	                    &(paneinfo->thresholding_num));
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_VAL,
	                    &(value_string));
	    paneinfo->thresholding_val = atoi(value_string);
	    kfree(value_string);
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->thresholding_selected));
	    }

	}

	if (paneinfo->accept_struct != NULL)
	{
	   selection = paneinfo->accept_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_VAL,
	                    &(paneinfo->accept));
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_LABEL,
	                    &(paneinfo->accept_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->accept_selected));
	    }

	}

	if (paneinfo->invert_struct != NULL)
	{
	   selection = paneinfo->invert_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_VAL,
	                    &(paneinfo->invert));
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_LABEL,
	                    &(paneinfo->invert_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->invert_selected));
	    }

	}

	if (paneinfo->thresh_object_struct != NULL)
	{
	    selection = paneinfo->thresh_object_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_WORKSPACE,
	                    &(paneinfo->thresh_object));
	    }

	}

}


