 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	GUI Drivers for 'editimage'
   >>>> 
   >>>>  Private: 
   >>>> 	run_editimage
   >>>> 	run_File
   >>>> 	run_file
   >>>> 	run_options
   >>>> 	run_capture
   >>>> 	run_lists
   >>>> 	run_display
   >>>> 	run_comment
   >>>> 	run_roi
   >>>> 	run_function
   >>>> 	run_Zoom
   >>>> 	run_zoom
   >>>> 	run_Pixel
   >>>> 	run_pixel
   >>>> 	run_MapValues
   >>>> 	run_mapvals
   >>>> 	run_Pseudo
   >>>> 	run_pseudo
   >>>> 	run_Thresh
   >>>> 	run_thresh
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "editimage.h"

/*-----------------------------------------------------------
| 
|  Routine Name: run_editimage
| 
|       Purpose: Main GUI Driver for editimage
| 
|         Input: None
| 
|        Output: Returns TRUE on success, FALSE on failure
|    Written By: conductor -oname editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void run_editimage(
     kform    *form,
     ksubform *subform,
     kaddr    client_data)
{
	/*
	 * GUI info structure passed in as client_data 
	 */
	gui_info_struct *master_info = (gui_info_struct *) client_data;

	/*
	 * Get information from the forms
	 */
	_xvf_get_editimage(master_info);

	if (form->quit)
	{
	    xvf_destroy_allforms();
	    _xvf_free_editimage(master_info);
	    return;
	}

	/*
	 * action came from the 'File' subform
	 */
	if (master_info->File_selected)
	    run_File(master_info->File);
	/*
	 * action came from the 'options' subform
	 */
	if (master_info->options_selected)
	    run_options(master_info->options);
	/*
	 * action came from the 'Zoom' subform
	 */
	if (master_info->Zoom_selected)
	    run_Zoom(master_info->Zoom);
	/*
	 * action came from the 'Pixel' subform
	 */
	if (master_info->Pixel_selected)
	    run_Pixel(master_info->Pixel);
	/*
	 * action came from the 'MapValues' subform
	 */
	if (master_info->MapValues_selected)
	    run_MapValues(master_info->MapValues);
	/*
	 * action came from the 'Pseudo' subform
	 */
	if (master_info->Pseudo_selected)
	    run_Pseudo(master_info->Pseudo);
	/*
	 * action came from the 'Thresh' subform
	 */
	if (master_info->Thresh_selected)
	    run_Thresh(master_info->Thresh);

	xvf_clear_selections(form);

}

/*-----------------------------------------------------------
| 
|  Routine Name: run_File
| 
|       Purpose: GUI Driver for subform 'File'
| 
|         Input: form      - pointer to the form tree
|                File_info - pointer to editimage_File struct
| 
|        Output: None
|    Written By: conductor -program_name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_File(
     editimage_File *File_info)
{

	/*
	 * action came from the 'file' pane
	 */
	if (File_info->file_selected)
	    run_file(File_info->file);


}   /* end run_File */



/*-----------------------------------------------------------
| 
|  Routine Name: run_file
| 
|       Purpose: GUI Driver for pane 'file'
| 
|         Input: form - pointer to the form tree
|                file_info - pointer to File_file struct
| 
|        Output: None
|    Written By: conductor -program_name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_file(
     File_file *file_info)

{

	/*
	 * user selected 'live' input file selection 'i'
	 */
	if (file_info->i_selected)
	{
	    file_i(file_info);
	    file_info->i_selected = FALSE;
	}
	/*
	 * user selected 'live' input file selection 'c'
	 */
	else if (file_info->c_selected)
	{
	    file_c(file_info);
	    file_info->c_selected = FALSE;
	}
	/*
	 * user selected 'live' input file selection 'cmap'
	 */
	else if (file_info->cmap_selected)
	{
	    file_cmap(file_info);
	    file_info->cmap_selected = FALSE;
	}
	/*
	 * user selected 'live' output file selection 'o'
	 */
	else if (file_info->o_selected)
	{
	    file_o(file_info);
	    file_info->o_selected = FALSE;
	}
	/*
	 * user selected 'live' output file selection 'out_cmap'
	 */
	else if (file_info->out_cmap_selected)
	{
	    file_out_cmap(file_info);
	    file_info->out_cmap_selected = FALSE;
	}
	/*
	 * user selected 'live' output file selection 'd'
	 */
	else if (file_info->d_selected)
	{
	    file_d(file_info);
	    file_info->d_selected = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_options
| 
|       Purpose: GUI Driver for subform 'options'
| 
|         Input: form      - pointer to the form tree
|                options_info - pointer to editimage_options struct
| 
|        Output: None
|    Written By: conductor -program_name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_options(
     editimage_options *options_info)
{

	/*
	 * action came from the 'capture' pane
	 */
	if (options_info->capture_selected)
	    run_capture(options_info->capture);

	/*
	 * action came from the 'lists' pane
	 */
	else if (options_info->lists_selected)
	    run_lists(options_info->lists);

	/*
	 * action came from the 'display' pane
	 */
	else if (options_info->display_selected)
	    run_display(options_info->display);

	/*
	 * action came from the 'comment' pane
	 */
	else if (options_info->comment_selected)
	    run_comment(options_info->comment);

	/*
	 * action came from the 'roi' pane
	 */
	else if (options_info->roi_selected)
	    run_roi(options_info->roi);

	/*
	 * action came from the 'function' pane
	 */
	else if (options_info->function_selected)
	    run_function(options_info->function);


}   /* end run_options */



/*-----------------------------------------------------------
| 
|  Routine Name: run_capture
| 
|       Purpose: GUI Driver for pane 'capture'
| 
|         Input: form - pointer to the form tree
|                capture_info - pointer to options_capture struct
| 
|        Output: None
|    Written By: conductor -program_name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_capture(
     options_capture *capture_info)

{

	/*
	 * user selected 'live' output file selection 'o'
	 */
	if (capture_info->o_selected)
	{
	    capture_o(capture_info);
	    capture_info->o_selected = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'capture'
	 */
	else if (capture_info->capture)
	{
	    capture_capture(capture_info);
	    capture_info->capture = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_lists
| 
|       Purpose: GUI Driver for pane 'lists'
| 
|         Input: form - pointer to the form tree
|                lists_info - pointer to options_lists struct
| 
|        Output: None
|    Written By: conductor -program_name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_lists(
     options_lists *lists_info)

{

	/*
	 * user selected 'live' flag selection 'elements'
	 */
	if (lists_info->elements_selected)
	{
	    lists_elements(lists_info);
	    lists_info->elements_selected = FALSE;
	}
	/*
	 * user selected 'live' flag selection 'depth'
	 */
	else if (lists_info->depth_selected)
	{
	    lists_depth(lists_info);
	    lists_info->depth_selected = FALSE;
	}
	/*
	 * user selected 'live' flag selection 'time'
	 */
	else if (lists_info->time_selected)
	{
	    lists_time(lists_info);
	    lists_info->time_selected = FALSE;
	}
	/*
	 * user selected 'live' list selection 'image_list'
	 */
	else if (lists_info->image_list_selected)
	{
	    lists_image_list(lists_info);
	    lists_info->image_list_selected = FALSE;
	}
	/*
	 * user selected 'live' list selection 'band_list'
	 */
	else if (lists_info->band_list_selected)
	{
	    lists_band_list(lists_info);
	    lists_info->band_list_selected = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_display
| 
|       Purpose: GUI Driver for pane 'display'
| 
|         Input: form - pointer to the form tree
|                display_info - pointer to options_display struct
| 
|        Output: None
|    Written By: conductor -program_name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_display(
     options_display *display_info)

{

	/*
	 * user selected 'live' cycle selection 'norm_type'
	 */
	if (display_info->norm_type_selected)
	{
	    display_norm_type(display_info);
	    display_info->norm_type_selected = FALSE;
	}
	/*
	 * user selected 'live' toggle selection 'norm_method'
	 */
	else if (display_info->norm_method_selected)
	{
	    display_norm_method(display_info);
	    display_info->norm_method_selected = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'red_mapcol'
	 */
	else if (display_info->red_mapcol)
	{
	    display_red_mapcol(display_info);
	    display_info->red_mapcol = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'green_mapcol'
	 */
	else if (display_info->green_mapcol)
	{
	    display_green_mapcol(display_info);
	    display_info->green_mapcol = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'blue_mapcol'
	 */
	else if (display_info->blue_mapcol)
	{
	    display_blue_mapcol(display_info);
	    display_info->blue_mapcol = FALSE;
	}
	/*
	 * user selected 'live' string selection 'red_function'
	 */
	else if (display_info->red_function_selected)
	{
	    display_red_function(display_info);
	    display_info->red_function_selected = FALSE;
	}
	/*
	 * user selected 'live' string selection 'green_function'
	 */
	else if (display_info->green_function_selected)
	{
	    display_green_function(display_info);
	    display_info->green_function_selected = FALSE;
	}
	/*
	 * user selected 'live' string selection 'blue_function'
	 */
	else if (display_info->blue_function_selected)
	{
	    display_blue_function(display_info);
	    display_info->blue_function_selected = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_comment
| 
|       Purpose: GUI Driver for pane 'comment'
| 
|         Input: form - pointer to the form tree
|                comment_info - pointer to options_comment struct
| 
|        Output: None
|    Written By: conductor -program_name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_comment(
     options_comment *comment_info)

{

	/*
	 * user clicked on pane action button selection 'change_comment'
	 */
	if (comment_info->change_comment)
	{
	    comment_change_comment(comment_info);
	    comment_info->change_comment = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_roi
| 
|       Purpose: GUI Driver for pane 'roi'
| 
|         Input: form - pointer to the form tree
|                roi_info - pointer to options_roi struct
| 
|        Output: None
|    Written By: conductor -program_name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_roi(
     options_roi *roi_info)

{

	/*
	 * user selected 'live' output file selection 'o'
	 */
	if (roi_info->o_selected)
	{
	    roi_o(roi_info);
	    roi_info->o_selected = FALSE;
	}
	/*
	 * user selected 'live' list selection 'policy'
	 */
	else if (roi_info->policy_selected)
	{
	    roi_policy(roi_info);
	    roi_info->policy_selected = FALSE;
	}
	/*
	 * user selected 'live' logical selection 'disp'
	 */
	else if (roi_info->disp_selected)
	{
	    roi_disp(roi_info);
	    roi_info->disp_selected = FALSE;
	}
	/*
	 * user selected 'live' logical selection 'mult'
	 */
	else if (roi_info->mult_selected)
	{
	    roi_mult(roi_info);
	    roi_info->mult_selected = FALSE;
	}
	/*
	 * user selected 'live' list selection 'pres'
	 */
	else if (roi_info->pres_selected)
	{
	    roi_pres(roi_info);
	    roi_info->pres_selected = FALSE;
	}
	/*
	 * user selected 'live' toggle selection 'shape'
	 */
	else if (roi_info->shape_selected)
	{
	    roi_shape(roi_info);
	    roi_info->shape_selected = FALSE;
	}
	/*
	 * user selected 'live' toggle selection 'mode'
	 */
	else if (roi_info->mode_selected)
	{
	    roi_mode(roi_info);
	    roi_info->mode_selected = FALSE;
	}
	/*
	 * user clicked on pane action button selection 'extract_roi'
	 */
	else if (roi_info->extract_roi)
	{
	    roi_extract_roi(roi_info);
	    roi_info->extract_roi = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_function
| 
|       Purpose: GUI Driver for pane 'function'
| 
|         Input: form - pointer to the form tree
|                function_info - pointer to options_function struct
| 
|        Output: None
|    Written By: conductor -program_name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_function(
     options_function *function_info)

{

	/*
	 * user clicked on pane action button selection 'create'
	 */
	if (function_info->create)
	{
	    function_create(function_info);
	    function_info->create = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_Zoom
| 
|       Purpose: GUI Driver for subform 'Zoom'
| 
|         Input: form      - pointer to the form tree
|                Zoom_info - pointer to editimage_Zoom struct
| 
|        Output: None
|    Written By: conductor -program_name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_Zoom(
     editimage_Zoom *Zoom_info)
{

	/*
	 * action came from the 'zoom' pane
	 */
	if (Zoom_info->zoom_selected)
	    run_zoom(Zoom_info->zoom);


}   /* end run_Zoom */



/*-----------------------------------------------------------
| 
|  Routine Name: run_zoom
| 
|       Purpose: GUI Driver for pane 'zoom'
| 
|         Input: form - pointer to the form tree
|                zoom_info - pointer to Zoom_zoom struct
| 
|        Output: None
|    Written By: conductor -program_name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_zoom(
     Zoom_zoom *zoom_info)

{

	/*
	 * user selected 'live' float selection 'zoomfactor'
	 */
	if (zoom_info->zoomfactor_selected)
	{
	    zoom_zoomfactor(zoom_info);
	    zoom_info->zoomfactor_selected = FALSE;
	}
	/*
	 * user selected 'live' logical selection 'update_mode'
	 */
	else if (zoom_info->update_mode_selected)
	{
	    zoom_update_mode(zoom_info);
	    zoom_info->update_mode_selected = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_Pixel
| 
|       Purpose: GUI Driver for subform 'Pixel'
| 
|         Input: form      - pointer to the form tree
|                Pixel_info - pointer to editimage_Pixel struct
| 
|        Output: None
|    Written By: conductor -program_name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_Pixel(
     editimage_Pixel *Pixel_info)
{

	/*
	 * action came from the 'pixel' pane
	 */
	if (Pixel_info->pixel_selected)
	    run_pixel(Pixel_info->pixel);


}   /* end run_Pixel */



/*-----------------------------------------------------------
| 
|  Routine Name: run_pixel
| 
|       Purpose: GUI Driver for pane 'pixel'
| 
|         Input: form - pointer to the form tree
|                pixel_info - pointer to Pixel_pixel struct
| 
|        Output: None
|    Written By: conductor -program_name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_pixel(
     Pixel_pixel *pixel_info)

{

	/*
	 * user selected 'live' logical selection 'update_mode'
	 */
	if (pixel_info->update_mode_selected)
	{
	    pixel_update_mode(pixel_info);
	    pixel_info->update_mode_selected = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_MapValues
| 
|       Purpose: GUI Driver for subform 'MapValues'
| 
|         Input: form      - pointer to the form tree
|                MapValues_info - pointer to editimage_MapValues struct
| 
|        Output: None
|    Written By: conductor -program_name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_MapValues(
     editimage_MapValues *MapValues_info)
{

	/*
	 * action came from the 'mapvals' pane
	 */
	if (MapValues_info->mapvals_selected)
	    run_mapvals(MapValues_info->mapvals);


}   /* end run_MapValues */



/*-----------------------------------------------------------
| 
|  Routine Name: run_mapvals
| 
|       Purpose: GUI Driver for pane 'mapvals'
| 
|         Input: form - pointer to the form tree
|                mapvals_info - pointer to MapValues_mapvals struct
| 
|        Output: None
|    Written By: conductor -program_name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_mapvals(
     MapValues_mapvals *mapvals_info)

{

	/*
	 * user selected 'live' logical selection 'update_mode'
	 */
	if (mapvals_info->update_mode_selected)
	{
	    mapvals_update_mode(mapvals_info);
	    mapvals_info->update_mode_selected = FALSE;
	}
	/*
	 * user selected 'live' cycle selection 'policy'
	 */
	else if (mapvals_info->policy_selected)
	{
	    mapvals_policy(mapvals_info);
	    mapvals_info->policy_selected = FALSE;
	}
	/*
	 * user selected 'live' integer selection 'display_width'
	 */
	else if (mapvals_info->display_width_selected)
	{
	    mapvals_display_width(mapvals_info);
	    mapvals_info->display_width_selected = FALSE;
	}
	/*
	 * user selected 'live' integer selection 'display_height'
	 */
	else if (mapvals_info->display_height_selected)
	{
	    mapvals_display_height(mapvals_info);
	    mapvals_info->display_height_selected = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_Pseudo
| 
|       Purpose: GUI Driver for subform 'Pseudo'
| 
|         Input: form      - pointer to the form tree
|                Pseudo_info - pointer to editimage_Pseudo struct
| 
|        Output: None
|    Written By: conductor -program_name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_Pseudo(
     editimage_Pseudo *Pseudo_info)
{

	/*
	 * action came from the 'pseudo' pane
	 */
	if (Pseudo_info->pseudo_selected)
	    run_pseudo(Pseudo_info->pseudo);


}   /* end run_Pseudo */



/*-----------------------------------------------------------
| 
|  Routine Name: run_pseudo
| 
|       Purpose: GUI Driver for pane 'pseudo'
| 
|         Input: form - pointer to the form tree
|                pseudo_info - pointer to Pseudo_pseudo struct
| 
|        Output: None
|    Written By: conductor -program_name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_pseudo(
     Pseudo_pseudo *pseudo_info)

{

	/*
	 * user selected 'live' toggle selection 'palette_type'
	 */
	if (pseudo_info->palette_type_selected)
	{
	    pseudo_palette_type(pseudo_info);
	    pseudo_info->palette_type_selected = FALSE;
	}


}


/*-----------------------------------------------------------
| 
|  Routine Name: run_Thresh
| 
|       Purpose: GUI Driver for subform 'Thresh'
| 
|         Input: form      - pointer to the form tree
|                Thresh_info - pointer to editimage_Thresh struct
| 
|        Output: None
|    Written By: conductor -program_name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_Thresh(
     editimage_Thresh *Thresh_info)
{

	/*
	 * action came from the 'thresh' pane
	 */
	if (Thresh_info->thresh_selected)
	    run_thresh(Thresh_info->thresh);


}   /* end run_Thresh */



/*-----------------------------------------------------------
| 
|  Routine Name: run_thresh
| 
|       Purpose: GUI Driver for pane 'thresh'
| 
|         Input: form - pointer to the form tree
|                thresh_info - pointer to Thresh_thresh struct
| 
|        Output: None
|    Written By: conductor -program_name editimage -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void run_thresh(
     Thresh_thresh *thresh_info)

{

	/*
	 * user selected 'live' toggle selection 'thresholding'
	 */
	if (thresh_info->thresholding_selected)
	{
	    thresh_thresholding(thresh_info);
	    thresh_info->thresholding_selected = FALSE;
	}
	/*
	 * user selected 'live' logical selection 'accept'
	 */
	else if (thresh_info->accept_selected)
	{
	    thresh_accept(thresh_info);
	    thresh_info->accept_selected = FALSE;
	}
	/*
	 * user selected 'live' logical selection 'invert'
	 */
	else if (thresh_info->invert_selected)
	{
	    thresh_invert(thresh_info);
	    thresh_info->invert_selected = FALSE;
	}


}


