 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for editimage
   >>>> 
   >>>>    Written By: 
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 13, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _editimage_h_
#define _editimage_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <envision.h>
#include <xvinclude.h>
#include "form_info.h"

/* -include_includes */
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
#define EXTRACT_W_MOUSE 1
#define EXTRACT_W_KEYBD 2
/* -include_defines_end */

#define PANEPATH "$ENVISION/objects/xvroutine/editimage/uis/editimage.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Alternate UIS file (optional infile)
 */
char	*form_file;	/* Alternate UIS file FILENAME */
int	 form_flag;	/* Alternate UIS file FLAG */

/*
 *  (x,y) position for automatic GUI placement */

int	 x_int;		/* x position INT */
int	 x_flag;	/* x position FLAG */

int	 y_int;		/* y position INT */
int	 y_flag;	/* y position FLAG */

/*
 *  input image filename (optional infile)
 */
char	*i_file;	/* input image filename FILENAME */
int	 i_flag;	/* input image filename FLAG */

/*
 *  input clip mask filename (optional infile)
 */
char	*c_file;	/* input clip mask filename FILENAME */
int	 c_flag;	/* input clip mask filename FLAG */

/*
 *  input alternate colormap file (optional infile)
 */
char	*cmap_file;	/* input alternate colormap file FILENAME */
int	 cmap_flag;	/* input alternate colormap file FLAG */

/*
 *  use colormap? (optional logical)
 */
int	 use_cmap_logic;	/* use colormap? LOGIC */
int	 use_cmap_flag;  	/* use colormap? FLAG */

/*
 *  initial zoom factor (optional float)
 */
float	 zoom_float;	/* initial zoom factor FLOAT */
int	 zoom_flag;   	/* initial zoom factor FLAG */

/*
 *  initial update time (optional float)
 */
float	 update_float;	/* initial update time FLOAT */
int	 update_flag;   	/* initial update time FLAG */

/*
 *  Read Only or Read Write Visual (Optional cycle)
 */
int	 visual_cycle;	/* Read Only or Read Write Visual CYCLE INDEX */
char	 *visual_label;	/* Read Only or Read Write Visual CYCLE LABEL */
int	 visual_flag;	/* Read Only or Read Write Visual FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
extern gui_info_struct *gui_info;

/* -include_variables */
extern xvobject image;	     /* the image wksp on main editimage GUI        */
extern xvobject position;    /* position object under image wksp            */
extern xvobject panicon;     /* panicon appears for large images            */
extern xvobject printpixel;  /* printpixel object for PrintPixel subform    */
extern xvobject printmapval; /* printmapval object for PrintMapVal subform  */
extern xvobject zoom;        /* zoom object for Zoom subform                */
extern xvobject pseudo;      /* pseudocolor object for Pseudo subform       */
extern xvobject threshold;   /* threshold object for Threshold subform      */

extern xvobject disp_roi;    /* toplevel of popup ROI extraction display    */
extern xvobject disp_area;   /* area for popup ROI display (signal ROI)     */
extern xvobject disp_plot2d; /* plot for popup ROI display (signal ROI)     */
extern xvobject disp_plot3d; /* plot for popup ROI display (signal ROI)     */
extern xvobject disp_axis2d; /* plot for popup ROI display (signal ROI)     */
extern xvobject disp_image;  /* image for popup ROI display (all other ROI) */

extern xvobject autocolor_list; /* list object for autocolor procedurees    */ 
extern xvobject cmap_op_list;   /* list object for colormap operations      */

extern int     numimages;
extern int     dimensions;
extern kobject *images; 
extern kobject current_image;
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void editimage_get_args PROTO((kform *));
void editimage_usage_additions PROTO((void));
void editimage_free_args PROTO((int, kaddr));

/* -include_routines */
/* autocolor.c */
void edimg_init_autocolor_display PROTO((kobject));

/* utilities.c */
void edimg_input_newimage        PROTO(());
void edimg_startup_from_clui     PROTO((void));
void edimg_update_image_list     PROTO((int));
void edimg_update_band_list      PROTO((void));
void adjust_gui_from_roi_shape   PROTO((void));
void adjust_gui_from_roi_mode    PROTO((void));
void set_current_image_object    PROTO((void));
void set_alternate_colormap      PROTO((char *));

/* create.c */
void edimg_create_image       PROTO((void));
void edimg_create_panicon     PROTO((void));
void edimg_create_position    PROTO((void));
void edimg_create_printpixel  PROTO((void));
void edimg_create_printmapval PROTO((void));
void edimg_create_zoom        PROTO((void));
void edimg_create_pseudo      PROTO((void));
void edimg_create_threshold   PROTO((void));
/* -include_routines_end */

#endif
