 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane thresh
   >>>> 
   >>>>  Private: 
   >>>> 	thresh_thresholding
   >>>> 	thresh_accept
   >>>> 	thresh_invert
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "editimage.h"

/*-----------------------------------------------------------
| 
|  Routine Name: thresh_thresholding
| 
|       Purpose: Do routine which is called when
|                  toggle selection thresholding is used
| 
|         Input: thresh_info - ptr to PaneInfo struct for thresh pane
| 
|        Output: None
|    Written By: Mark Young and Danielle Argiro
|          Date: Oct 11, 1993
| Modifications: 
| 
------------------------------------------------------------*/
void thresh_thresholding(
     Thresh_thresh *thresh_info)
{
	xvw_set_attribute(threshold, XVW_THRESHOLD_POLICY,
		          thresh_info->thresholding_val);
}


/*-----------------------------------------------------------
| 
|  Routine Name: thresh_accept
| 
|       Purpose: Do routine which is called when
|                  logical selection accept is used
| 
|         Input: thresh_info - ptr to PaneInfo struct for thresh pane
| 
|        Output: None
|    Written By: Mark Young and Danielle Argiro
|          Date: Oct 11, 1993
| Modifications: 
| 
------------------------------------------------------------*/
void thresh_accept(
     Thresh_thresh *thresh_info)
{
	xvw_set_attribute(threshold, XVW_THRESHOLD_CLIP_ACCEPT,
		thresh_info->accept);
}

/*-----------------------------------------------------------
| 
|  Routine Name: thresh_invert
| 
|       Purpose: Do routine which is called when
|                  logical selection invert is used
| 
|         Input: thresh_info - ptr to PaneInfo struct for thresh pane
| 
|        Output: None
|    Written By: Mark Young and Danielle Argiro
|          Date: Oct 11, 1993
| Modifications: 
| 
------------------------------------------------------------*/
void thresh_invert(
     Thresh_thresh *thresh_info)
{
	xvw_set_attribute(threshold, XVW_THRESHOLD_THRES_INVERT,
		thresh_info->invert);
}
