/*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>         Functionality routines for editcmap
   >>>>
   >>>>  Private: create_cmap_workspace
   >>>>
   >>>>   Static: save_callback
   >>>>           options_callback
   >>>>           quit_handler
   >>>>           quit_callback
   >>>>           help_callback
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "editcmap.h"

kobject  value_object      = NULL;
xvobject cmap_object       = NULL;
int      colormap_modified = FALSE;

#define USE_PSEUDO 1
#define USE_THRESH 2
#define USE_LUT    3

static void save_callback        PROTO((xvobject, kaddr, kaddr));
static void save_needed_callback PROTO((xvobject, kaddr, kaddr));
static void quit_handler         PROTO((xvobject, kaddr, XEvent *));
static void quit_callback        PROTO((xvobject, kaddr, kaddr));
static void help_callback        PROTO((xvobject, kaddr, kaddr));
static void options_callback     PROTO((xvobject, kaddr, kaddr));


/*-----------------------------------------------------------
|
|  Routine Name: create_cmap_workspace()
|
|       Purpose: Creates the display workspace for editcmap
|         Input:
|        Output:
|       Returns:
|    Written By: Mark Young
|          Date: Sep 08, 1993
| Modifications:
|
------------------------------------------------------------*/
void create_cmap_workspace(void)
{
	xvobject parent, options, help, quit, save, palette;
	char     temp[KLENGTH]; 
	char     *cmap_file;
	char     *outfile = clui_info->o_file;

        /*
         *  create parent object
         */
	if (clui_info->cmap_file != NULL)
	    cmap_file = clui_info->cmap_file;
	else if (clui_info->i_file != NULL)
	    cmap_file = clui_info->i_file;

        ksprintf(temp, "Editcmap: %s", cmap_file);
        parent = xvw_create_manager(NULL, temp);
        xvw_set_attributes(parent,
                XVW_MINIMUM_WIDTH,  250,
                XVW_MINIMUM_HEIGHT, 200,
                XVW_CHAR_WIDTH,     45.0,
                XVW_SELECTABLE,     TRUE,
                XVW_RESIZABLE,      TRUE,
                NULL);
 
	if (clui_info->pseudo_flag)
	    xvw_set_attribute(parent, XVW_CHAR_HEIGHT, 12.0);
	else if (clui_info->thresh_flag)
	    xvw_set_attribute(parent, XVW_CHAR_HEIGHT, 8.0);
	
        /*
         * create Options button which will bring up internal menuform
         */
        options = xvw_create_button(parent, "options");
        xvw_set_attributes(options,
                XVW_BELOW,        NULL,
                XVW_RIGHT_OF,     NULL,
                XVW_LABEL,        "Options",
                XVW_BUTTON_SHAPE, KBUTTON_SHAPE_OVAL,
                NULL);

        /*
         *  create save button
         */
        save = xvw_create_button(parent, "save");
        xvw_set_attributes(save,
                XVW_RIGHT_OF,    options,
                XVW_LABEL,      "Save",
                XVW_CHAR_WIDTH,  5.0,
                NULL);
        xvw_add_callback(save, XVW_BUTTON_SELECT, save_callback, NULL);

        /*
         *  create quit button
         */
        quit = xvw_create_button(parent, "quit");
        xvw_set_attributes(quit,
                XVW_BELOW,        NULL,
                XVW_LEFT_OF,      NULL,
                XVW_LABEL,        "Quit",
                NULL);
	xvw_add_callback(quit, XVW_BUTTON_SELECT, quit_callback, NULL);

        /*
         *  create help button
         */
        help = xvw_create_button(parent, "help");
        xvw_set_attributes(help,
                XVW_LEFT_OF,     quit,
                XVW_LABEL,      "Help",
                XVW_CHAR_WIDTH,  5.0,
                NULL);
        xvw_add_callback(help, XVW_BUTTON_SELECT, help_callback, NULL);

        if (clui_info->i_file)
	   value_object = kpds_open_object(clui_info->i_file, KOBJ_READ);

        if (clui_info->x_flag || clui_info->y_flag)
        {
           xvobject toplevel = xvw_toplevel(parent);
 
           if (clui_info->x_flag)
              xvw_set_attribute(toplevel, XVW_SHELL_X, clui_info->x_int);
           if (clui_info->y_flag)
              xvw_set_attribute(toplevel, XVW_SHELL_Y, clui_info->y_int);
        }

	/*
	 *  [-pseudo]: create pseudocolor object
	 */
        if (clui_info->pseudo_flag)
        {
	   if (!(cmap_object = xvw_create_pseudo(parent, "pseudo")))
	   {
	       kerror(NULL, "create_cmap_workspace",
		      "Sorry, can't create pseudo");
	       kexit(KEXIT_FAILURE);
	   }
	   xvw_set_attribute(cmap_object, XVW_TACK_EDGE, KMANAGER_TACK_ALL);
	   xvw_insert_callback(cmap_object, XVW_PSEUDO_CALLBACK, FALSE, 
			       save_needed_callback, save);
	   xvw_get_attribute(cmap_object, XVW_PSEUDO_PALETTE_OBJECT, 
			     &palette);
        }

	/*
	 *  [-thresh]: create thresholding object
	 */
       else if (clui_info->thresh_flag)
       {
	   if (!(cmap_object = xvw_create_threshold(parent, "threshold")))
	   {
	       kerror(NULL, "create_cmap_workspace",
		      "Sorry, can't create threshold");
	       kexit(KEXIT_FAILURE);
           }
	   xvw_set_attribute(cmap_object, XVW_TACK_EDGE, KMANAGER_TACK_ALL);
           xvw_insert_callback(cmap_object, XVW_THRESHOLD_CALLBACK, FALSE, 
			       save_needed_callback, save);
	   xvw_get_attribute(cmap_object, XVW_THRESHOLD_PALETTE_OBJECT, 
			     &palette);
        }

        xvw_add_callback(options, XVW_BUTTON_SELECT, options_callback, 
			 cmap_object);
	xvw_add_action(cmap_object, "<Key>q", quit_handler, NULL, TRUE);

	xvw_set_attribute(cmap_object, XVW_BELOW, options);

	/*
	 * NOTE! Setting XVW_COLOR_COLORFILE on the palette sub-part of
	 *       the pseudo or threshold object rather than the pseudo
	 *       or threshold object itself is a kludge. This is to
	 *       fix the bug where  pseudo and threshold objects are using
	 *       the default visual, rather than using the visual that 
	 *       matches the data (which might be 24 bit).  Since all the
	 *       color object share a common structure, we now have the
	 *       problem that some visuals may be 8-bit and some 24-bit.
	 *       We should fix this so the XVW_COLOR_COLORFILE can be
	 *       set directly on the threshold or pseudo object.
	 */
	xvw_set_attribute(palette,     XVW_COLOR_COLORFILE, cmap_file);
	xvw_set_attribute(cmap_object, XVW_COLOR_COLORFILE, cmap_file);
}

/*-----------------------------------------------------------
|
|  Routine Name: save_callback
|
|       Purpose: Callback to updates output file
|                according to current colormap
|
|         Input: save_button - the save button
|                client_data - not used
|                call_data   - not used
|        Output:
|       Returns:
|    Written By: Mark Young & Danielle Argiro
|          Date: Apr 21, 1995
| Modifications:
|
------------------------------------------------------------*/
static void save_callback(
   xvobject save_button,
   kaddr    client_data,
   kaddr    call_data)
{
        char    *outfile = clui_info->o_file;

        if (!(xvw_set_attribute(cmap_object, XVW_COLOR_SAVEMAP, outfile)))
        {
           kerror(NULL, "save_callback",
                  "Could not save colormap to file '%s'", outfile);
        }
	if (colormap_modified)
	    xvw_set_attribute(save_button, XVW_LABEL, "Save");
	colormap_modified = FALSE;
}

/*-----------------------------------------------------------
|
|  Routine Name: save_needed_callback
|
|       Purpose: Callback fired when psuedocolor or threshold scrollbars move,
|		 updates "Save" button to say "Save (Needed)" (if necessary).
|		 Use of global flag simplifies implementation.
|
|         Input: object      - the save button
|                client_data - not used
|                call_data   - not used
|        Output:
|       Returns:
|    Written By: Mark Young & Danielle Argiro
|          Date: Apr 21, 1995
| Modifications:
|
------------------------------------------------------------*/
static void save_needed_callback(
   xvobject object,
   kaddr    client_data,
   kaddr    call_data)
{
	xvobject save_button = (xvobject) client_data;

	/* button already reads, "Save (Needed)" */
	if (colormap_modified) return;

	xvw_set_attribute(save_button, XVW_LABEL, "Save (Needed)");
	colormap_modified = TRUE;
	
}


/*-----------------------------------------------------------
|
|  Routine Name: quit_handler()
|
|       Purpose: Action handler quits the editcmap program when
|                user hits 'Q' or 'q'.
|
|         Input: object      - the lut, psuedo, or threshold object
|                client_data - not used
|                event       - the 'q' or 'Q' keypress event
|        Output:
|       Returns:
|    Written By: Danielle Argiro
|          Date: Nov 3, 1993
| Modifications:
|
------------------------------------------------------------*/
static void quit_handler(
   xvobject object,
   kaddr    client_data,
   XEvent   *event)
{
        xvw_destroy(object);
        kexit(KEXIT_SUCCESS);
}

/*-----------------------------------------------------------
|
|  Routine Name: quit_callback()
|
|       Purpose: Callback quits when user hits quit button
|
|         Input: object      - the image, plot, or other object
|                client_data - not used
|                call_data   - not used
|        Output: None
|       Returns: None
|    Written By: Danielle Argiro
|          Date: March 6, 1995
| Modifications:
|
------------------------------------------------------------*/
static void quit_callback(
   xvobject object,
   kaddr    client_data,
   kaddr    call_data)
{
        xvw_destroy(xvw_parent(object));
        kexit(KEXIT_SUCCESS);
}



/*-----------------------------------------------------------
|
|  Routine Name: help_callback()
|
|       Purpose: Callback displays appropriate help page
|                according to the type of visual display being used
|
|         Input: object      - the quit button
|                client_data - not used
|                call_data   - not used
|        Output: None
|       Returns: None
|    Written By: Danielle Argiro
|          Date: March 7, 1995
| Modifications:
|
------------------------------------------------------------*/
static void help_callback(
   xvobject object,
   kaddr    client_data,
   kaddr    call_data)
{
        xvobject   helppage;
        char *filename = "$ENVISION/objects/xvroutine/editcmap/help/editcmap.hlp";


        helppage = xvw_create_help(NULL, "Online Help");
        xvw_set_attributes(helppage,
                           XVW_HELP_TITLE,  "Online Help",
                           XVW_HELP_FILENAME, filename,
                           NULL);
}


/*-----------------------------------------------------------
|
|  Routine Name: options_callback()
|
|       Purpose: Callback for the Options button which will
|                display the internal menuform for the 
|		 psuedocolor or threshold object.
|
|         Input: object      - the options button
|                client_data - not used
|                call_data   - the image, plot, or other object
|        Output: None
|       Returns: None
|    Written By: Mark Young
|          Date: Aug 19, 1994
| Modifications:
|
------------------------------------------------------------*/
static void options_callback(
    xvobject object,
    kaddr    client_data,
    kaddr    call_data)
{
        xvobject visual_obj = (xvobject) client_data;
 
        xvw_activate_menu(visual_obj);
}
