 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */



#include "animate.h"
/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for master animate
   >>>> 
   >>>>  Private: 
   >>>> 	animate_previous
   >>>> 	animate_next
   >>>> 	animate_forward
   >>>> 	animate_reverse
   >>>> 	animate_stop
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


/*-----------------------------------------------------------
| 
|  Routine Name: animate_previous
| 
|       Purpose: Called when master action button previous is used
| 
|         Input: master_info - ptr to FormInfo struct for animate
| 
|        Output: None
|    Written By: Mark Young
|          Date: Mon Dec 28 19:49:42 1992
| Modifications: 
| 
------------------------------------------------------------*/
void animate_previous(
   gui_info_struct *master_info)
{
        xvw_set_attribute(animate, XVW_ANIMATE_DIRECTION, 
		          KANIMATE_DIRECTION_PREVIOUS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: animate_next
| 
|       Purpose: Called when master action button next is used
| 
|         Input: master_info - ptr to FormInfo struct for animate
| 
|        Output: None
|    Written By: Mark Young
|          Date: Mon Dec 28 19:49:42 1992
| Modifications: 
| 
------------------------------------------------------------*/
void animate_next(
   gui_info_struct *master_info)
{
        xvw_set_attribute(animate, XVW_ANIMATE_DIRECTION, 
			  KANIMATE_DIRECTION_NEXT);
}


/*-----------------------------------------------------------
| 
|  Routine Name: animate_forward
| 
|       Purpose: Called when master action button forward is used
| 
|         Input: master_info - ptr to FormInfo struct for animate
| 
|        Output: None
|    Written By: Mark Young 
|          Date: Mon Dec 28 19:49:42 1992
| Modifications: 
| 
------------------------------------------------------------*/
void animate_forward(
   gui_info_struct *master_info)
{
	int bandnum, maxbands, control;

	xvw_get_attributes(animate, 
			   XVW_IMAGE_BANDNUM,     &bandnum,		
			   XVW_IMAGE_BAND_MAXNUM, &maxbands,
			   XVW_ANIMATE_CONTROL,   &control,
			   NULL);
	if ((control == KANIMATE_CONTROL_SINGLE) &&
	    (bandnum == maxbands))
	{
	    kerror(NULL, "animate_forward", "At end of sequence");
	    return;
	}
        xvw_set_attribute(animate, XVW_ANIMATE_DIRECTION, 
			  KANIMATE_DIRECTION_FORWARD);
}


/*-----------------------------------------------------------
| 
|  Routine Name: animate_reverse
| 
|       Purpose: Called when master action button reverse is used
| 
|         Input: master_info - ptr to FormInfo struct for animate
| 
|        Output: None
|    Written By: Mark Young 
|          Date: Mon Dec 28 19:49:42 1992
| Modifications: 
| 
------------------------------------------------------------*/
void animate_reverse(
   gui_info_struct *master_info)
{
	int bandnum, maxbands, control;
	xvw_get_attributes(animate,
                           XVW_IMAGE_BANDNUM,     &bandnum,
                           XVW_IMAGE_BAND_MAXNUM, &maxbands,
                           XVW_ANIMATE_CONTROL,   &control,
                           NULL);
        if ((control == KANIMATE_CONTROL_SINGLE) &&
            (bandnum == 0))
        {
            kerror(NULL, "animate_forward", "At beginning of sequence");
            return;
        }
        xvw_set_attribute(animate, XVW_ANIMATE_DIRECTION, 
			  KANIMATE_DIRECTION_REVERSE);
}


/*-----------------------------------------------------------
| 
|  Routine Name: animate_stop
| 
|       Purpose: Called when master action button stop is used
| 
|         Input: master_info - ptr to FormInfo struct for animate
| 
|        Output: None
|    Written By: Mark Young 
|          Date: Mon Dec 28 19:49:42 1992
| Modifications: 
| 
------------------------------------------------------------*/
void animate_stop(
   gui_info_struct *master_info)
{
        xvw_set_attribute(animate, XVW_ANIMATE_DIRECTION, 
			  KANIMATE_DIRECTION_STOP);
}
