 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kautocolor.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kautocolor_get_args
| 
|       Purpose: Gets command line args for kautocolor
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kautocolor
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kautocolor_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kautocolor is out of sync with arguments specified in kautocolor's *.pane file; please rerun ghostwriter on kautocolor.";

	char  *value_string;


	/*
	 * allocate the kautocolor structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "kautocolor_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "autocolor", KVF_TOGGLE_VAL,
			  &value_string,
			  &(clui_info->autocolor_flag))))
	{
	    kerror(NULL, "kautocolor_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}
	else clui_info->autocolor_toggle = atoi(value_string);

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "kautocolor_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



