#include "xvinclude.h"

/*
 * This program puts up an image object displaying the entire image; it
 * also creates a smaller image object in which a region of interest can
 * be displayed.
 *
 * As each Region of Interest is extracted, the shape type is incremented.
 * This causes the user to cycle thru the different types of extraction
 * shapes.
 */
main(
   int  argc,
   char *argv[],
   char *envp[])
{
        xvobject image, roi = NULL;
        int shape = KIMAGE_ROI_RECTANGLE;
        kobject image_object, roi_object;


        /* initialize xvwidgets lib */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
           kerror(NULL, "main", "unable to open display");
           kexit(1);
        }

        /* create the xvobject to display the image */
        image_object = kpds_open_object("image:ball", KOBJ_READ);
        kcolor_set_attribute(image_object, KCOLOR_MAP_AUTOCOLOR, KRGB_SPIRAL);

        image = xvw_create_image(NULL, "image");
        xvw_set_attributes(image,
                XVW_IMAGE_IMAGEOBJ,   image_object,
                NULL);

        while (1)
        {
	   /*
	    *  Set the desired Roi Shape Extraction type.  Initially this
	    *  will be rectangle, but it will then cycle thru polyline, circle,
	    *  ellipse, line, and then freehand.
	    */
           xvw_set_attribute(image, XVW_IMAGE_ROI_SHAPE, shape);

           /*
            * let image object do ROI extraction, it'll pass back a
	    * temporary data object (kobject) which can then be displayed
	    * by the roi image display.
            */
           xvw_get_attribute(image, XVW_IMAGE_ROI, &roi_object);
           if (roi_object == NULL)
              break;

           if (roi == NULL) roi = xvw_create_image(NULL, "image");
           xvw_set_attribute(roi, XVW_IMAGE_IMAGEOBJ, roi_object);
           kpds_close_object(roi_object);

	   /*
	    *  Cycle thru the different extraction shapes.
	    */
           if (++shape > KIMAGE_ROI_FREEHAND)
	      shape = KIMAGE_ROI_RECTANGLE;
        }
}
