#include <xvinclude.h>

void  quit_program       PROTO((xvobject, kaddr, XEvent *));
void  region_of_interest PROTO((xvobject, kaddr, XEvent *));

xvobject img_visual_obj; /* image object to display entire image */

/*
 * This program puts up an image object displaying the entire image; it
 * creates a smaller image object to the lower left in which a region
 * of interest can be displayed.  You can rubberband regions of interest
 * in the image, and the smaller image on the bottom will be updated
 * with the latest region of interest.
 *
 * After the image is displayed, rubberband the area of interest by
 * clicking in the image (the cursor will change to the "hand") and dragging
 * the mouse so that the desired region of interest is outlined. 
 * When you release the button, the smaller image on the bottom will be
 * immediately updated with the region of interest.  This process may
 * be repeated as many times as desired.
 *
 */

void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject manager;        /* backplane for both image objects */
        xvobject roi_visual_obj; /* image object to display ROI */
	kobject  data_obj;

	/* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/* initialize the xvwidgets library */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
           kerror(NULL, "main", "unable to open display");
           kexit(KEXIT_FAILURE);
        }
	
	/* create a manager backplane */
	manager = xvw_create_manager(NULL, "parent");

	/* create the image object which will display the entire image */
        img_visual_obj = xvw_create_image(manager, "image");

	/* associate the image data with the image visual object */
	data_obj = kpds_open_input_object("image:lizard");
        xvw_set_attribute(img_visual_obj, XVW_IMAGE_IMAGEOBJ, data_obj);

	/*
	 *  change the size of the data object to be 100x100 so that the
	 *  roi image object will initially display the upper-left hand
	 *  corner of the image. 
	 */
	kpds_set_attribute(data_obj, KPDS_VALUE_SIZE, 100, 100, 1, 1, 1);

	/* create the image object which will display the region of interest */
        roi_visual_obj = xvw_create_image(manager, "image");
        xvw_set_attributes(roi_visual_obj,
		           XVW_BELOW,    img_visual_obj,
        		   XVW_IMAGE_IMAGEOBJ, data_obj,
		           NULL);

	/* add the action handler to quit the program */
	xvw_add_action(img_visual_obj, "<Key>q", quit_program, NULL, TRUE);

	/* add an event handler to start the region of interest extraction */
	xvw_add_event(img_visual_obj, ButtonPressMask, region_of_interest,
			(kaddr) roi_visual_obj);

	/* display and run */
        xvf_run_form();
}

/*
 *  event handler to get region of interest and display the
 *  region of interest in the smaller image visual object.
 */
void  region_of_interest(
    xvobject object, 
    kaddr    client_data,  
    XEvent   *event)
{
	kobject  iobject = NULL;
 	xvobject roi_visual_obj = (xvobject) client_data;

	/* 
	 * simply getting the XVW_IMAGE_ROI attribute causes all
	 * the work to be done automatically;  the user is prompted to
         * rubberband the area of interest, the rubberbanding is performed,
	 * and a data object containing the extracted region of interest
	 * is returned.
	 */
        xvw_get_attribute(img_visual_obj, XVW_IMAGE_ROI, &iobject);
	if (iobject == NULL) return;

	/*
	 * region of interest successfully extracted; update image object
	 */
	xvw_set_attribute(roi_visual_obj, XVW_IMAGE_IMAGEOBJ, iobject);
	kpds_close_object(iobject);
}


/*
 *  action handler to quit program on Key Press 'q'
 */
void  quit_program(
   xvobject object,
   kaddr    client_data,
   XEvent   *event)
{
        xvw_destroy(object);
        kexit(KEXIT_SUCCESS);
}

