#include <xvinclude.h>

char *list[] = { "image:USA", "image:ball", "clust:scow", "image:moon"};

void switch_image PROTO((xvobject, kaddr, XEvent *, Boolean *));

/*
 * This example program creates a display containing an image object that will
 * be used to cycle through a number of predefined images, and a pan icon 
 * that appears near the upper left hand corner of the image.  An event handler
 * allows the user to switch to the next image by clicking on the image.
 * The event handler simply changes the image that is displayed in the image
 * object; if the image being displayed is large enough to need a pan icon,
 * the pan icon will appear;  if it is not, the pan icon will disappear.
 */

void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject manager;         /* need a backplane to hold both */
        xvobject image, panicon;  /* image and panicon visual object */

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/* initialize xvwidgets library */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
           kerror(NULL, "main", "unable to open display");
           kexit(KEXIT_FAILURE);
        }

	/* create parent for image & panicon */
	manager = xvw_create_manager(NULL, "parent");

	/* create image object */
        image   = xvw_create_image(manager, "image");

	/* create pan icon */
        panicon = xvw_create_panicon(manager, "panicon");

	/* image to right of pan icon */
	xvw_set_attribute(image, XVW_RIGHT_OF, panicon);

	/* specify file to be used as image data on both */
        xvw_set_attribute(image,   XVW_IMAGE_IMAGEFILE, list[0]);
        xvw_set_attribute(panicon, XVW_IMAGE_IMAGEFILE, list[0]);

	/* add event handler to switch images on button press */
	xvw_add_event(image, ButtonPressMask, switch_image, (kaddr) panicon);

	/* display & run */
        xvf_run_form();
}

/*
 * the event handler which will switch the image on Button Press
 */
void  switch_image(
xvobject image,    
kaddr    clientData,
XEvent   *event,
Boolean  *dispatch)
{
	static int count = 1;
	xvobject panicon = (xvobject) clientData;

	if (count == knumber(list)) count = 0;

	xvw_set_attribute(image,   XVW_IMAGE_IMAGEFILE, list[count]);
	xvw_set_attribute(panicon, XVW_IMAGE_IMAGEFILE, list[count]);

	count++;
}


