#include <xvinclude.h>

void  quit_program  PROTO((xvobject, kaddr, XEvent *));
void  track_image   PROTO((xvobject, kaddr, XEvent *, Boolean *));

/*
 * This program puts up an image, and adds an event handler which
 * is used to move a marker on the image.  Click on the marker and
 * hold the button down to "drag" it across the image.  The position
 * of the marker in the image is tracked, and a label object under
 * the image updated to display the position of the marker and the
 * pixel value at that location.
 */
xvobject label;

void main(
   int  argc,
   char *argv[],
   char *envp[])
{
        xvobject parent, image, marker;
        char *filename = "image:ball";
 
        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/*  initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/* use filename specified on cmd line if provided */
	if (argc > 1)
	   filename = argv[1];

        /*
         *  Create parent for image & label
         */
        parent = xvw_create_manager(NULL, "parent");

        /*
         *  Create the image display
         */
        image = xvw_create_image(parent, "image");
        xvw_set_attribute(image, XVW_IMAGE_IMAGEFILE, filename);

	/*
	 *  Now create a marker in the center of the image.  We can choose
	 *  a bunch of different marker types, but circle maybe what we want.
	 */
	marker = xvw_create_marker(image, "marker");
	xvw_set_attributes(marker,
		XVW_GRAPHICS_MARKERTYPE, KMARKER_CIRCLE,
		XVW_MARKER_XPLACEMENT, 0.5,
		XVW_MARKER_YPLACEMENT, 0.5,
		NULL);

	/* 
	 * you should have been able to do this above, but there is a
         * bug that kicks in (the marker will be invisible) unless you
         * set the foreground separately.  
	 */
	xvw_set_attribute(marker, XVW_FOREGROUND_COLOR, "red");

	/* add the action handler to quit on KeyPress 'q' */
	xvw_add_action(image, "<Key>q", quit_program, image, TRUE);

	/* add the event handler to track movement of the marker on the image */
	xvw_add_event(image, ButtonPressMask | ButtonMotionMask, 
		      track_image, marker);

	/* add label underneath image to display location of marker */
	label = xvw_create_label(parent, "label");
	xvw_set_attributes(label,
			   XVW_LEFT_OF,  NULL,
			   XVW_RIGHT_OF, NULL,
			   XVW_BELOW,    image,
			   XVW_LABEL,    "marker at position (20, 20)",
			   NULL);

	/* display & run */
        xvf_run_form();
}

/*
 *  event handler to quit program on Button Press
 */
void  quit_program(
   xvobject object,
   kaddr    client_data,
   XEvent   *event)
{
	xvw_destroy(object);
        kexit(0);
}

/*
 *  event handler to track the movement of the pointer in the image,
 *  to move the marker to that location, and update the label object
 *  to display the location & pixel value at that point.
 */
void  track_image(
   xvobject object,
   kaddr    client_data,
   XEvent   *event,
   Boolean  *dispatch)
{
	xvobject image  = object;
	xvobject marker = (xvobject) client_data;

	int    x, y;
	double value;
	char   temp[KLENGTH];

	/*
	 *  get the current location of the pointer in the image,
         *  and the pixel value at that location
	 */
	xvw_get_attributes(image, 
			   XVW_IMAGE_XPOSITION, &x, 
			   XVW_IMAGE_YPOSITION, &y, 
			   XVW_IMAGE_VALUE,     &value, 
			   NULL);

	/*
	 *  move the marker to that location by setting its X and Y position.
 	 */
	xvw_set_attributes(marker,
                           XVW_XPOSITION, x,
                           XVW_YPOSITION, y,
                           NULL);

	/*
	 *  update the text displayed by the label to indicate the
         *  current location and pixel value
 	 */
	ksprintf(temp, "marker at position (%d,%d), pixel value %g", 
		 x, y, value);
	xvw_set_attribute(label, XVW_LABEL, temp); 
}
