#include <xvinclude.h>

/* 
 * This example creates an image with a 2D plot displayed over it.
 */
void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject image, plot2d;
	char *filename = "image:moon";

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/*  initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/* create the image object */
	image = xvw_create_image(NULL, "image");

	/* specify the filename of image to be displayed in image object */
	xvw_set_attribute(image, XVW_IMAGE_IMAGEFILE, filename);

	/* create the 2D plot object with the image as its parent */
	plot2d = xvw_create_plot2d(image, "Plot2D");

	/* set the file containing plot data, the foreground color of plot */
	xvw_set_attributes(plot2d, 
			   XVW_PLOT2D_PLOTFILE,  "plot2d:sine",
			   XVW_FOREGROUND_COLOR, "red",
			   NULL);

	/* display & run; there is no way to exit the program but ^C */
	xvf_run_form();
}
