#include <xvinclude.h>

char *list[] = { "image:ball", "image:kitten", "image:head", "image:moon",
		 "image:spine", "image:slav", "image:mandril"};

void switch_or_quit PROTO((xvobject, kaddr, XEvent *, Boolean *));

/*
 * This example program creates a window containing an image object that will
 * be used to cycle through a number of predefined images.  An event handler
 * allows the user to switch to the next image by clicking on the image.
 * The event handler simply changes the image that is displayed in the image
 * object  (as opposed to example 2, which destroys the old image and creates
 * a new one). The same event handler allows the user to quit the program by
 * pressing 'q' or 'Q'.
 */
void main(
   int  argc,
   char *argv[],
   char *envp[])
{
        xvobject object;  /* image visual object */

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/* initialize xvwidgets library */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
           kerror(NULL, "main", "unable to open display");
           kexit(KEXIT_FAILURE);
        }

	/* create image visual object w/ default parent, default toplevel */
        object = xvw_create_image(NULL, "image");

	/* specify file to be used as image data */
        xvw_set_attribute(object, XVW_IMAGE_IMAGEFILE, list[0]);
        xvw_set_attribute(object, XVW_BACKGROUND_COLOR, "black");

	/* add event handler to switch images & quit */
	xvw_add_event(object, ButtonPressMask | KeyPressMask,
		      switch_or_quit, NULL);

	/* display & run */
        xvf_run_form();
}

/*
 * the event handler which will switch the image on Button Press,
 * or quit the program on Key press 'Q' or 'q'
 */
void  switch_or_quit(
xvobject object,    
kaddr    clientData,
XEvent   *event,
Boolean  *dispatch)
{
	char   ch;
	static int count = 1;

	/* 
	 * since there is no formalized GUI, need a way to exit
         * the program. quit if they type 'Q' or 'q'
	 */
	if (event->type == KeyPress)
	{
	   if (XLookupString(&(event->xkey), &ch, 1, NULL, NULL)  == 0)
	      return;
	   if (ch == 'q' || ch == 'Q')
	   {
	        xvw_destroy(object);
		kexit(KEXIT_SUCCESS);
	   }
	}

	/*
	 *  If they button pressed in the image, switch to next image.
	 */
        else if (event->type == ButtonPress)
        {
	   if (count == knumber(list)) count = 0;
	      xvw_set_attribute(object, XVW_IMAGE_IMAGEFILE, list[count++]);
	}
}


