#include <xvinclude.h>

/*
 *  This program creates an image object, a position object to reflect the
 *  location of the mouse pointer in the image, and a printpixel object to
 *  print the values of the pixels surrounding that location.
 *
 *  Note that you do NOT have to write an event handler to make the 
 *  printpixel object update; the fact that we have created an image object
 *  using the same file for it's data does the trick.  The image object will
 *  recognise pointer motion within it, and cause the printpixel object (and
 *  the position object as well) to be updated automatically.
 */
void main(
     int  argc,
     char **argv, 
     char **envp)
{
	kobject  object;
	char     *filename = "image:lizard-rgb";
	xvobject image, zoom, position, parent, printpixel;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/* create a data object from the information in the image file */
	object = kpds_open_input_object(filename);

        /* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/* create a manager to contain printpixel & position objects */
	parent = xvw_create_manager(NULL, "parent");

	/* create the image object, associate it with the "image:ball" data */
	image = xvw_create_image(parent, "image");
	xvw_set_attribute(image, XVW_IMAGE_IMAGEOBJ, object);

	/* 
	 * create the position object in the center below the image; 
	 * associate it, too, with the "image:ball" data
	 */
	position = xvw_create_position(parent, "position");
	xvw_set_attributes(position,
			   XVW_BELOW,           image,
			   XVW_LEFT_OF,         image,
			   XVW_RIGHT_OF,        image,
			   XVW_POSITION_OBJECT, object,
			   NULL);

	/*
	 * create the printpixel object to the right of the image object,
         * associate the printpixel object with the "image:ball"data, 
         * and use the XVW_PRINTPIXEL_SHOWCOLOR attribute to indicate that we 
         * want the background of each label displaying a pixel value to have 
         * a background filled with the color of that pixel.
	 */
	parent = xvw_create_manager(NULL, "printpixel_parent");
        xvw_set_attributes(parent,
                           XVW_WIDTH,  300,
                           XVW_HEIGHT, 200,
                           NULL);

	printpixel = xvw_create_printpixel(parent, "printpixel");
	xvw_set_attributes(printpixel,
			   XVW_PRINTPIXEL_OBJECT,    object,
			   XVW_PRINTPIXEL_SHOWCOLOR, TRUE,
			   XVW_PRINTPIXEL_WIDTH,     10,
                           XVW_PRINTPIXEL_HEIGHT,    10,
			   XVW_TACK_EDGE,            KMANAGER_TACK_ALL,
			   NULL);

	/* display & run the program */
	xvf_run_form();
}
