#include <xvinclude.h>

/*
 *  This program creates an image object, a position object to reflect the
 *  location of the mouse pointer in the image, and a printmapval object to
 *  print the values of the map values indexed by the pixels surrounding that 
 *  location.
 *
 *  Note that you do NOT have to write an event handler to make the 
 *  printmapval object update; the fact that we have created an image object
 *  using the same file for its data does the trick.  The image object will
 *  recognise pointer motion within it, and cause the printmapval object (and
 *  the position object as well) to be updated automatically.
 */
static void change_policy PROTO((xvobject, kaddr, kaddr));

void main(
     int  argc,
     char **argv, 
     char **envp)
{
	kobject  object;
	char     *filename = "clust:albq1";
	xvobject image, zoom, position, parent; 
	xvobject label, button, printmapval;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/* create a data object from the information in the image file */
	object = kpds_open_input_object(filename);

        /* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/* create a manager to contain image & position objects */
	parent = xvw_create_manager(NULL, "image_parent");

	/* create the image object, associate it with the "image:ball" data */
	image = xvw_create_image(parent, "image");
	xvw_set_attribute(image, XVW_IMAGE_IMAGEOBJ, object);

	/* 
	 * create the position object in the center below the image; 
	 * associate it, too, with the "image:ball" data
	 */
	position = xvw_create_position(parent, "position");
	xvw_set_attributes(position,
			   XVW_BELOW,           image,
			   XVW_LEFT_OF,         NULL,
			   XVW_RIGHT_OF,        NULL,
			   XVW_POSITION_OBJECT, object,
			   NULL);

	/* create a manager to contain image & position objects */
	parent = xvw_create_manager(NULL, "printmapval_parent");

	/* create printmapval object */
	label = xvw_create_labelstr(parent, "label");
	xvw_set_attributes(label,
			   XVW_RIGHT_OF, NULL,
			   XVW_LABEL,    "PrintMapVal Policy:",
			   NULL);

	button = xvw_create_button(parent, "button");
	xvw_set_attributes(button,
			   XVW_RIGHT_OF, label,
			   XVW_LABEL,    "Print Displayed Map Values",
			   NULL);

	printmapval = xvw_create_printmapval(parent, "printmapval");
	xvw_set_attributes(printmapval,
			   XVW_BELOW,                 button,
			   XVW_TACK_EDGE,             KMANAGER_TACK_ALL,
			   XVW_MINIMUM_WIDTH,         300,
			   XVW_MINIMUM_HEIGHT,        600,
			   XVW_PRINTMAPVAL_OBJECT,    object,
			   XVW_PRINTMAPVAL_SHOWCOLOR, TRUE,
			   XVW_PRINTMAPVAL_WIDTH,     9,
                           XVW_PRINTMAPVAL_HEIGHT,    9,
			   NULL);

	xvw_add_callback(button, XVW_BUTTON_SELECT,
			 change_policy, printmapval);

	/* display & run the program */
	xvf_run_form();
}

static void change_policy(
    xvobject object,  
    kaddr    client_data,
    kaddr    call_data)
{
	int policy;
	xvobject printmapval = (xvobject) client_data;

	xvw_get_attribute(printmapval, XVW_PRINTMAPVAL_POLICY, &policy);
	if (policy == KPRINTMAPVAL_MAPDATAVALUES)
	{
	    xvw_set_attribute(printmapval, XVW_PRINTMAPVAL_POLICY, 
			      KPRINTMAPVAL_DISPLAYEDVALUES);
	    xvw_set_attribute(object, XVW_LABEL, "Print Displayed Map Values");
	}
	else
	{
	    xvw_set_attribute(printmapval, XVW_PRINTMAPVAL_POLICY, 
			      KPRINTMAPVAL_MAPDATAVALUES);
	    xvw_set_attribute(object, XVW_LABEL, "Print Actual  Map Values");
	}
}

