#include <xvinclude.h>

/*
 *
 * This example creates a window with a single string annotation in it.
 *
 * After the manager object parent is put into edit mode (hold down
 * shift key and click the left mouse button), the string can be
 * interactively moved by "grabbing" it in the middle with the left mouse
 * button; grabbing it near an end will cause the string to resize.
 *
 * In this example, the internal menuform for the string is displayed
 * automatically.
 */

void main( 
   int  argc,
   char *argv[],
   char *envp[])
{
        xvobject parent;
        xvobject string;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

        /* initialize the xvwidgets lib */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
           kerror(NULL, "main", "unable to open display");
           kexit(KEXIT_FAILURE);
        }

        /*
         *  create a manager backplane. make it selectable so
         *  the user can put it in edit mode & move the string around.
         */
        parent = xvw_create_manager(NULL, "parent");
        xvw_set_attributes(parent,
                           XVW_WIDTH,      300,
                           XVW_HEIGHT,     300,
                           XVW_SELECTABLE, TRUE,
                           NULL);

        /*
         *  create the string object.  specify placement in world coordinates,
         *  the string to be displayed, and the justification.
         *  make it menuable so user has access to its internal menuform.
         */
        string = xvw_create_string(parent, "string");
        xvw_set_attributes(string,
		           XVW_STRING_XPLACEMENT,    0.5,
		           XVW_STRING_YPLACEMENT,    0.5,
			   XVW_CHAR_WIDTH,           25.0,
			   XVW_CHAR_HEIGHT,          10.0,
		           XVW_STRING_STRING,	    "Test String",
		           XVW_STRING_JUSTIFICATION, KSTRING_JUSTIFY_CENTER,
                           XVW_MENUABLE,             TRUE,
		           NULL);
        /*
         *  activate the internal menuform so user doesn't
         *  have to bring it up.
         */
        xvw_activate_menu(string);

        /* display & run the program */
        xvf_run_form();
}
