 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Form Info Structure for preview Form
   >>>> 
   >>>>    Written By: conductor -name preview -l 3
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _form_info_h_
#define _form_info_h_

#include <xvinclude.h>

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

/*
 * Pane Info Struct for 'view' Pane
 */
typedef struct _show_view{

kform_struct *license_struct; /* pass to xvf_set_attributes() */

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Quit' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

char         *i;         /* filename for 'i'*/
kform_struct *i_struct;  /* pass to xvf_set_attributes() */
int          i_selected; /* TRUE on <cr> for 'i' */

int          revisit;          /* TRUE when user clicks on 'revisit'*/
kform_struct *revisit_struct;  /* pass to xvf_set_attributes() */

int          edit;          /* TRUE when user clicks on 'edit'*/
kform_struct *edit_struct;  /* pass to xvf_set_attributes() */

char         *print;         /* filename for 'print'*/
kform_struct *print_struct;  /* pass to xvf_set_attributes() */
int          print_selected; /* TRUE on <cr> for 'print' */

} show_view;

/*
 * Subform Info Struct for 'show' Subform
 */
typedef struct _preview_show {

show_view   *view;          /* ptr to Pane Info struct for pane 'view' */
int        view_selected;          /* TRUE if input was from pane 'view' */
kform_struct *view_struct;          /* pass to xvf_set_attributes() */

}  preview_show;

/*
 * Form Info Struct for 'preview' form
 */
typedef struct _gui_info_struct {

preview_show  *show;
int show_selected;
kform_struct *show_struct;


 } gui_info_struct; 

        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void _xvf_free_preview PROTO((gui_info_struct *));
void _xvf_get_preview  PROTO((gui_info_struct *));

int  _xvf_init_preview PROTO((kform *, gui_info_struct *));
void run_preview       PROTO((kform *, ksubform *, kaddr));

void run_show      PROTO((preview_show *));
void _xvf_get_show PROTO((preview_show *));

void run_view      PROTO((show_view *));
void _xvf_get_view PROTO((show_view *));
void view_i	PROTO((show_view *));
void view_revisit	PROTO((show_view *));
void view_edit	PROTO((show_view *));
void view_print	PROTO((show_view *));




#endif /* _form_info_h_ */ 
/* Don't add after this point */
