 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for guise
   >>>> 
   >>>>    Written By: Danielle Argiro
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 14, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _guise_h_
#define _guise_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <design.h>
#include <xvinclude.h>
#include "form_info.h"

/* -include_includes */
#include "kcms/kcms.h"
#include "kutils/ksignal.h"
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
#define EDITOR "vi"

#define TMPL_I  3 
#define TMPL_O  4 
#define TMPL_s  5 
#define TMPL_f  6 
#define TMPL_i  7 
#define TMPL_y  8 
#define TMPL_l  9 
#define TMPL_c  10
#define TMPL_x  11
#define TMPL_t  12
#define TMPL_a  13
#define TMPL_R  14
#define TMPL_Q  15
#define TMPL_H  16

#define EMPTY_FORM_UIS "$DESIGN/objects/library/xvforms/uis/xvf_edit/empty.form"
/* -include_defines_end */

#define PANEPATH "$DESIGN/objects/xvroutine/guise/uis/guise.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Alternate UIS file (optional infile)
 */
char	*form_file;	/* Alternate UIS file FILENAME */
int	 form_flag;	/* Alternate UIS file FLAG */

/*
 *  (x,y) position for automatic GUI placement */

int	 x_int;		/* x position INT */
int	 x_flag;	/* x position FLAG */

int	 y_int;		/* y position INT */
int	 y_flag;	/* y position FLAG */

/*
 *  force output (optional flag)
 */
int	 force_flag;  	/* force output FLAG */

/*
 *  output UIS file (optional outfile)
 */
char	*o_file;	/* output UIS file FILENAME */
int	 o_flag;	/* output UIS file FLAG */

/*----- optional ME group ----*/
/*
 *  initial UIS file (optional infile)
 */
char	*i_file;	/* initial UIS file FILENAME */
int	 i_flag;	/* initial UIS file FLAG */

	/*---- nested optional MI group ----*/
/*
 *  toolbox (optional string)
 */
char	*tb_string;	/* toolbox STRING */
int	 tb_flag;   	/* toolbox FLAG */

/*
 *  object name (optional string)
 */
char	*oname_string;	/* object name STRING */
int	 oname_flag;   	/* object name FLAG */

/*
 *  UIS file to edit (do not include path) (optional string)
 */
char	*uis_string;	/* UIS file to edit (do not include path) STRING */
int	 uis_flag;   	/* UIS file to edit (do not include path) FLAG */

	/*-- nested optional MI group end --*/

/*-- optional ME group end ---*/

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
extern gui_info_struct *gui_info;

/* -include_variables */
/* see globals.c */
extern int     editor_up;
extern int     force_output;
extern int     editor_pid;
extern int     save_needed;
extern char    *output_filename;
extern kform   *display_form;
extern int     save_control_dest;
extern kobject display_toolbox;
extern kobject display_program;
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void guise_get_args PROTO((kform *));
void guise_usage_additions PROTO((void));
void guise_free_args PROTO((int, kaddr));

/* -include_routines */
/* compare.c */
int identical_output_file PROTO((char *));
int identical_forms       PROTO((kform *,      kform *));
int identical_subforms    PROTO((ksubform *,   ksubform *));
int identical_guides      PROTO((kguide *,     kguide *));
int identical_selections  PROTO((kselection *, kselection *));

/* displayed.c */
kcontrol *find_displayed_pane        PROTO((kform *));
kcontrol *find_displayed_control     PROTO((char *, char *, int, ksubform **,
					    kguide **, kcontrol **));
ksubform *find_displayed_subform     PROTO((kform *));

/* do_control.c */
void run_display PROTO((kform *, ksubform *, kaddr));

/* init.c */
void guise_initialize     PROTO((void));
void put_gui_in_edit_mode PROTO((void));
void set_uis_directory    PROTO((char *));



/* run_guise.c */
void run_guise PROTO((kform *, ksubform *, kaddr));

/* utilities.c */
void link_selection                  PROTO((kcontrol *, kselection *));
void reload_form                     PROTO((char *, char *));
void set_save_needed                 PROTO((kform_struct *, char *, 
					    kaddr, kaddr));
void set_save_notneeded              PROTO((kform_struct *));
void adjust_gui_from_infile          PROTO((char *, options_create *));
void install_gui_attribute_callbacks PROTO((void));
void add_uis_misc_file               PROTO((kform_struct *, char *, 
					    kaddr, kaddr));
char *check_all_variables             PROTO((void));


int       update_form                PROTO((xvobject, char *, kaddr)); 
int       display_empty_form         PROTO((char *));
int       existing_selection         PROTO((kselection *, int));
int       output_display_form        PROTO((char *, int, char *));
int       find_pane_num              PROTO((ksubform *));
int       find_subform_num           PROTO((kform *));
int       add_item_to_submenu        PROTO((kselection *, kform_struct *));

float     xvf_calculate_y_position       PROTO((kcontrol *));

char      *compose_gb_name           PROTO((ksubform *, int *));
char      *compose_sfb_name          PROTO((kform *, int *));

xvobject   *get_selected_gui_items   PROTO((int *, kcontrol **, int*));
kselection *create_new_selection     PROTO((kcontrol *, char *));


/* gui_util.c */
void add_save_needed_callback  PROTO((kform_struct *));
/* -include_routines_end */

#endif
