 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Form Info Structure for guise Form
   >>>> 
   >>>>    Written By: conductor -name guise -l 3
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 14, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _form_info_h_
#define _form_info_h_

#include <xvinclude.h>

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

/*
 * Pane Info Struct for 'create' Pane
 */
typedef struct _options_create{

kform_struct *license_struct; /* pass to xvf_set_attributes() */

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Quit' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

char         *i;         /* filename for 'i'*/
kform_struct *i_struct;  /* pass to xvf_set_attributes() */
int          i_selected; /* TRUE on <cr> for 'i' */

int          save;          /* TRUE when user clicks on 'save'*/
kform_struct *save_struct;  /* pass to xvf_set_attributes() */

int          reload;          /* TRUE when user clicks on 'reload'*/
kform_struct *reload_struct;  /* pass to xvf_set_attributes() */

int          edit;          /* TRUE when user clicks on 'edit'*/
kform_struct *edit_struct;  /* pass to xvf_set_attributes() */

int          new;          /* TRUE when user clicks on 'new'*/
kform_struct *new_struct;  /* pass to xvf_set_attributes() */

kform_struct *options_struct; /* submenu button, pass to xvf_set_attributes() */

int          copy;          /* TRUE when user clicks on 'copy'*/
kform_struct *copy_struct;  /* pass to xvf_set_attributes() */

int          menuform;          /* TRUE when user clicks on 'menuform'*/
kform_struct *menuform_struct;  /* pass to xvf_set_attributes() */

int          delete;          /* TRUE when user clicks on 'delete'*/
kform_struct *delete_struct;  /* pass to xvf_set_attributes() */

kform_struct *grouping_struct; /* submenu button, pass to xvf_set_attributes() */

int          submenu;          /* TRUE when user clicks on 'submenu'*/
kform_struct *submenu_struct;  /* pass to xvf_set_attributes() */

int          me_group_req;          /* TRUE when user clicks on 'me_group_req'*/
kform_struct *me_group_req_struct;  /* pass to xvf_set_attributes() */

int          me_group_opt;          /* TRUE when user clicks on 'me_group_opt'*/
kform_struct *me_group_opt_struct;  /* pass to xvf_set_attributes() */

int          mi_group;          /* TRUE when user clicks on 'mi_group'*/
kform_struct *mi_group_struct;  /* pass to xvf_set_attributes() */

int          ls_group;          /* TRUE when user clicks on 'ls_group'*/
kform_struct *ls_group_struct;  /* pass to xvf_set_attributes() */

char         *o;         /* filename for 'o'*/
kform_struct *o_struct;  /* pass to xvf_set_attributes() */
int          o_selected; /* TRUE on <cr> for 'o' */

int          control_dest_val;      /* value of toggle 'control_dest'*/
int          control_dest_num;      /* number of toggle member selected (1-N) */
kform_struct *control_dest_struct;  /* pass to xvf_set_attributes() */
int          control_dest_selected; /* TRUE on <cr> for 'control_dest' */

int          force;          /* boolean value of 'force'*/
char         *force_label;   /* label assoc w/ value of 'force'*/
kform_struct *force_struct;  /* pass to xvf_set_attributes() */
int          force_selected; /* TRUE on <cr> for 'force' */

kform_struct *simples_struct; /* submenu button, pass to xvf_set_attributes() */

int          int_sel;          /* TRUE when user clicks on 'int_sel'*/
kform_struct *int_sel_struct;  /* pass to xvf_set_attributes() */

int          float_sel;          /* TRUE when user clicks on 'float_sel'*/
kform_struct *float_sel_struct;  /* pass to xvf_set_attributes() */

int          double_sel;          /* TRUE when user clicks on 'double_sel'*/
kform_struct *double_sel_struct;  /* pass to xvf_set_attributes() */

int          string_sel;          /* TRUE when user clicks on 'string_sel'*/
kform_struct *string_sel_struct;  /* pass to xvf_set_attributes() */

int          flag_sel;          /* TRUE when user clicks on 'flag_sel'*/
kform_struct *flag_sel_struct;  /* pass to xvf_set_attributes() */

int          logic_sel;          /* TRUE when user clicks on 'logic_sel'*/
kform_struct *logic_sel_struct;  /* pass to xvf_set_attributes() */

kform_struct *files_struct; /* submenu button, pass to xvf_set_attributes() */

int          infile_sel;          /* TRUE when user clicks on 'infile_sel'*/
kform_struct *infile_sel_struct;  /* pass to xvf_set_attributes() */

int          outfile_sel;          /* TRUE when user clicks on 'outfile_sel'*/
kform_struct *outfile_sel_struct;  /* pass to xvf_set_attributes() */

int          stdin_sel;          /* TRUE when user clicks on 'stdin_sel'*/
kform_struct *stdin_sel_struct;  /* pass to xvf_set_attributes() */

int          stdout_sel;          /* TRUE when user clicks on 'stdout_sel'*/
kform_struct *stdout_sel_struct;  /* pass to xvf_set_attributes() */

kform_struct *buttons_struct; /* submenu button, pass to xvf_set_attributes() */

int          action_button;          /* TRUE when user clicks on 'action_button'*/
kform_struct *action_button_struct;  /* pass to xvf_set_attributes() */

int          routine_button;          /* TRUE when user clicks on 'routine_button'*/
kform_struct *routine_button_struct;  /* pass to xvf_set_attributes() */

int          help_button;          /* TRUE when user clicks on 'help_button'*/
kform_struct *help_button_struct;  /* pass to xvf_set_attributes() */

int          quit_button;          /* TRUE when user clicks on 'quit_button'*/
kform_struct *quit_button_struct;  /* pass to xvf_set_attributes() */

int          guide_button;          /* TRUE when user clicks on 'guide_button'*/
kform_struct *guide_button_struct;  /* pass to xvf_set_attributes() */

kform_struct *lists_struct; /* submenu button, pass to xvf_set_attributes() */

int          cycle_sel;          /* TRUE when user clicks on 'cycle_sel'*/
kform_struct *cycle_sel_struct;  /* pass to xvf_set_attributes() */

int          list_sel;          /* TRUE when user clicks on 'list_sel'*/
kform_struct *list_sel_struct;  /* pass to xvf_set_attributes() */

int          displaylist_sel;          /* TRUE when user clicks on 'displaylist_sel'*/
kform_struct *displaylist_sel_struct;  /* pass to xvf_set_attributes() */

int          strlist_sel;          /* TRUE when user clicks on 'strlist_sel'*/
kform_struct *strlist_sel_struct;  /* pass to xvf_set_attributes() */

kform_struct *toggles_struct; /* submenu button, pass to xvf_set_attributes() */

int          flag_toggle;          /* TRUE when user clicks on 'flag_toggle'*/
kform_struct *flag_toggle_struct;  /* pass to xvf_set_attributes() */

int          logical_toggle;          /* TRUE when user clicks on 'logical_toggle'*/
kform_struct *logical_toggle_struct;  /* pass to xvf_set_attributes() */

int          int_toggle;          /* TRUE when user clicks on 'int_toggle'*/
kform_struct *int_toggle_struct;  /* pass to xvf_set_attributes() */

int          flt_toggle;          /* TRUE when user clicks on 'flt_toggle'*/
kform_struct *flt_toggle_struct;  /* pass to xvf_set_attributes() */

int          dbl_toggle;          /* TRUE when user clicks on 'dbl_toggle'*/
kform_struct *dbl_toggle_struct;  /* pass to xvf_set_attributes() */

int          str_toggle;          /* TRUE when user clicks on 'str_toggle'*/
kform_struct *str_toggle_struct;  /* pass to xvf_set_attributes() */

int          infile_toggle;          /* TRUE when user clicks on 'infile_toggle'*/
kform_struct *infile_toggle_struct;  /* pass to xvf_set_attributes() */

int          outfile_toggle;          /* TRUE when user clicks on 'outfile_toggle'*/
kform_struct *outfile_toggle_struct;  /* pass to xvf_set_attributes() */

int          wksp_sel;          /* TRUE when user clicks on 'wksp_sel'*/
kform_struct *wksp_sel_struct;  /* pass to xvf_set_attributes() */

int          blank_sel;          /* TRUE when user clicks on 'blank_sel'*/
kform_struct *blank_sel_struct;  /* pass to xvf_set_attributes() */

int          subform_button;          /* TRUE when user clicks on 'subform_button'*/
kform_struct *subform_button_struct;  /* pass to xvf_set_attributes() */

} options_create;

/*
 * Subform Info Struct for 'options' Subform
 */
typedef struct _guise_options {

options_create  *create;          /* ptr to Pane Info struct for pane 'create' */
int            create_selected;          /* TRUE if input was from pane 'create' */
kform_struct   *create_struct;          /* pass to xvf_set_attributes() */

}  guise_options;

/*
 * Form Info Struct for 'guise' form
 */
typedef struct _gui_info_struct {

guise_options  *options;
int options_selected;
kform_struct *options_struct;


 } gui_info_struct; 

        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void _xvf_free_guise PROTO((gui_info_struct *));
void _xvf_get_guise  PROTO((gui_info_struct *));

int  _xvf_init_guise PROTO((kform *, gui_info_struct *));
void run_guise       PROTO((kform *, ksubform *, kaddr));

void run_options      PROTO((guise_options *));
void _xvf_get_options PROTO((guise_options *));

void run_create      PROTO((options_create *));
void _xvf_get_create PROTO((options_create *));
void create_i	PROTO((options_create *));
void create_save	PROTO((options_create *));
void create_reload	PROTO((options_create *));
void create_edit	PROTO((options_create *));
void create_new	PROTO((options_create *));
void create_copy	PROTO((options_create *));
void create_menuform	PROTO((options_create *));
void create_delete	PROTO((options_create *));
void create_submenu	PROTO((options_create *));
void create_me_group_req	PROTO((options_create *));
void create_me_group_opt	PROTO((options_create *));
void create_mi_group	PROTO((options_create *));
void create_ls_group	PROTO((options_create *));
void create_o	PROTO((options_create *));
void create_control_dest	PROTO((options_create *));
void create_force	PROTO((options_create *));
void create_int_sel	PROTO((options_create *));
void create_float_sel	PROTO((options_create *));
void create_double_sel	PROTO((options_create *));
void create_string_sel	PROTO((options_create *));
void create_flag_sel	PROTO((options_create *));
void create_logic_sel	PROTO((options_create *));
void create_infile_sel	PROTO((options_create *));
void create_outfile_sel	PROTO((options_create *));
void create_stdin_sel	PROTO((options_create *));
void create_stdout_sel	PROTO((options_create *));
void create_action_button	PROTO((options_create *));
void create_routine_button	PROTO((options_create *));
void create_help_button	PROTO((options_create *));
void create_quit_button	PROTO((options_create *));
void create_guide_button	PROTO((options_create *));
void create_cycle_sel	PROTO((options_create *));
void create_list_sel	PROTO((options_create *));
void create_displaylist_sel	PROTO((options_create *));
void create_strlist_sel	PROTO((options_create *));
void create_flag_toggle	PROTO((options_create *));
void create_logical_toggle	PROTO((options_create *));
void create_int_toggle	PROTO((options_create *));
void create_flt_toggle	PROTO((options_create *));
void create_dbl_toggle	PROTO((options_create *));
void create_str_toggle	PROTO((options_create *));
void create_infile_toggle	PROTO((options_create *));
void create_outfile_toggle	PROTO((options_create *));
void create_wksp_sel	PROTO((options_create *));
void create_blank_sel	PROTO((options_create *));
void create_subform_button	PROTO((options_create *));




#endif /* _form_info_h_ */ 
/* Don't add after this point */
